/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.geotools.process;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import net.refractions.udig.catalog.ID;
import net.refractions.udig.catalog.IProcess;
import net.refractions.udig.catalog.IProcessInfo;
import net.refractions.udig.catalog.IResolve;
import net.refractions.udig.catalog.geotools.process.LocalProcessFolder;
import net.refractions.udig.catalog.geotools.process.LocalProcessService;
import net.refractions.udig.catalog.ui.CatalogUIPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.opengis.feature.type.Name;
import org.opengis.util.InternationalString;

public class LocalProcess
extends IProcess {
    LocalProcessFolder folder;
    Name name;
    private IProcessInfo info;
    private ID id;

    LocalProcess(LocalProcessFolder folder, Name name) {
        this.folder = folder;
        this.name = name;
        this.id = new ID(folder.getID(), name.getLocalPart());
    }

    public IResolve.Status getStatus() {
        return this.folder.getStatus();
    }

    public Throwable getMessage() {
        return this.folder.getMessage();
    }

    public String getTitle() {
        if (this.info != null) {
            return this.info.getTitle();
        }
        return this.name.getLocalPart();
    }

    public synchronized IProcessInfo getInfo(IProgressMonitor monitor) throws IOException {
        if (this.info == null) {
            this.info = new LocalProcessInfo();
        }
        return this.info;
    }

    public LocalProcessService service(IProgressMonitor monitor) throws IOException {
        return this.folder.parent(monitor);
    }

    public URL getIdentifier() {
        return this.id.toURL();
    }

    public ID getID() {
        return this.id;
    }

    public class LocalProcessInfo
    extends IProcessInfo {
        LocalProcessInfo() {
            String version;
            this.processName = LocalProcess.this.name;
            this.processFactory = LocalProcess.this.folder.getFactory();
            this.processName = LocalProcess.this.name;
            try {
                this.schema = new URI(this.processName.getNamespaceURI());
            }
            catch (URISyntaxException uRISyntaxException) {}
            InternationalString processDescription = this.processFactory.getDescription(this.processName);
            InternationalString processTitle = this.processFactory.getTitle(this.processName);
            if (processDescription != null) {
                this.description = processDescription.toString();
            }
            if (processTitle != null) {
                this.title = processTitle.toString();
            }
            if ((version = this.processFactory.getVersion(this.processName)) != null) {
                this.keywords = new String[]{version};
            }
            this.icon = CatalogUIPlugin.getDefault().getImageDescriptor("obj16/grid_obj.gif");
        }
    }
}

