/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.geotools.data;

import java.io.File;
import java.net.URL;
import java.util.Map;
import net.refractions.udig.catalog.ID;
import net.refractions.udig.catalog.geotools.data.Params;
import net.refractions.udig.catalog.ui.CatalogUIPlugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.FileDataStoreFactorySpi;
import org.geotools.data.property.PropertyDataStoreFactory;
import org.geotools.data.wfs.WFSDataStoreFactory;
import org.geotools.jdbc.JDBCDataStoreFactory;

enum GTFormat {
    JDBC{

        @Override
        public boolean accepts(DataAccessFactory factory) {
            if (factory instanceof JDBCDataStoreFactory) {
                return false;
            }
            DataAccessFactory.Param[] paramArray = factory.getParametersInfo();
            int n = paramArray.length;
            int n2 = 0;
            while (n2 < n) {
                DataAccessFactory.Param param = paramArray[n2];
                if ("dbtype".equalsIgnoreCase(param.key)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        @Override
        public String getTitle(DataAccessFactory factory, Map<String, ?> params) {
            Params keys = new Params(factory);
            String dbtype = keys.lookup(String.class, "dbtype", params);
            String the_host = keys.lookup(String.class, "host", params);
            Integer intPort = keys.lookup(Integer.class, "port", params);
            String the_database = keys.lookup(String.class, "database", params);
            String the_username = keys.lookup(String.class, "user", params);
            String the_password = keys.lookup(String.class, "passwd", params);
            String port = intPort == null ? "" : ":" + intPort;
            String cfr_ignored_0 = String.valueOf(the_host) + port + "/" + the_database;
            ID id = this.toID(dbtype, the_username, the_password, the_host, intPort, the_database);
            return id.labelServer();
        }

        public ID toID(String dbtype, String the_username, String the_password, String the_host, Object intPort, String the_database) {
            if (intPort == null) {
                intPort = "";
            }
            String the_spec = "jdbc://" + the_username + ":" + the_password + "@" + the_host + ":" + intPort + "/" + the_database;
            return new ID(the_spec, dbtype);
        }

        @Override
        public ID toID(DataAccessFactory factory, Map<String, ?> params) {
            Params keys = new Params(factory);
            String dbtype = keys.lookup(String.class, "dbtype", params);
            String the_host = keys.lookup(String.class, "host", params);
            Integer intPort = keys.lookup(Integer.class, "port", params);
            String the_database = keys.lookup(String.class, "database", params);
            String the_username = keys.lookup(String.class, "user", params);
            String the_password = keys.lookup(String.class, "passwd", params);
            ID id = this.toID(dbtype, the_username, the_password, the_host, intPort, the_database);
            return id;
        }

        @Override
        public ImageDescriptor getIcon() {
            return CatalogUIPlugin.getDefault().getImageDescriptor("obj16/database_obj.gif");
        }
    }
    ,
    FILE{

        @Override
        public boolean accepts(DataAccessFactory factory) {
            return factory instanceof FileDataStoreFactorySpi;
        }

        @Override
        public String getTitle(DataAccessFactory factory, Map<String, ?> params) {
            Params keys = new Params(factory);
            File file = keys.lookup(File.class, params);
            if (file != null) {
                ID id = new ID(file, factory.getDisplayName());
                return id.labelServer();
            }
            URL url = keys.lookup(URL.class, params);
            if (url != null) {
                ID id = new ID(url, factory.getDisplayName());
                return id.labelServer();
            }
            return null;
        }

        @Override
        public ID toID(DataAccessFactory factory, Map<String, ?> params) {
            Params keys = new Params(factory);
            File file = keys.lookup(File.class, params);
            if (file != null) {
                ID id = new ID(file, factory.getDisplayName());
                return id;
            }
            URL url = keys.lookup(URL.class, params);
            if (url != null) {
                ID id = new ID(url, factory.getDisplayName());
                return id;
            }
            return OTHER.toID(factory, params);
        }

        @Override
        public ImageDescriptor getIcon() {
            return CatalogUIPlugin.getDefault().getImageDescriptor("obj16/feature_file_obj.gif");
        }
    }
    ,
    WFS{

        @Override
        public boolean accepts(DataAccessFactory factory) {
            return factory instanceof WFSDataStoreFactory;
        }

        @Override
        public String getTitle(DataAccessFactory factory, Map<String, ?> params) {
            Params keys = new Params(factory);
            URL url = keys.lookup(URL.class, params);
            if (url != null) {
                ID id = new ID(url, factory.getDisplayName());
                return id.labelServer();
            }
            return null;
        }

        @Override
        public ID toID(DataAccessFactory factory, Map<String, ?> params) {
            return null;
        }

        @Override
        public ImageDescriptor getIcon() {
            return CatalogUIPlugin.getDefault().getImageDescriptor("obj16/wfs_obj.gif");
        }
    }
    ,
    PROPERTY{

        @Override
        public boolean accepts(DataAccessFactory factory) {
            return factory instanceof PropertyDataStoreFactory;
        }

        @Override
        public String getTitle(DataAccessFactory factory, Map<String, ?> params) {
            Params keys = new Params(factory);
            File file = keys.lookup(File.class, params);
            if (file != null) {
                ID id = new ID(file, factory.getDisplayName());
                return id.labelServer();
            }
            return null;
        }

        @Override
        public ID toID(DataAccessFactory factory, Map<String, ?> params) {
            Params keys = new Params(factory);
            File file = keys.lookup(File.class, params);
            if (file != null) {
                ID id = new ID(file, factory.getDisplayName());
                return id;
            }
            return OTHER.toID(factory, params);
        }

        @Override
        public ImageDescriptor getIcon() {
            return CatalogUIPlugin.getDefault().getImageDescriptor("obj16/feature_file_obj.gif");
        }
    }
    ,
    OTHER{

        @Override
        public boolean accepts(DataAccessFactory factory) {
            return true;
        }

        @Override
        public String getTitle(DataAccessFactory factory, Map<String, ?> params) {
            Params keys = new Params(factory);
            File file = keys.lookup(File.class, params);
            if (file != null) {
                ID id = new ID(file, factory.getDisplayName());
                return id.labelServer();
            }
            URL url = keys.lookup(URL.class, params);
            if (url != null) {
                ID id = new ID(url, factory.getDisplayName());
                return id.labelServer();
            }
            StringBuffer buf = new StringBuffer();
            buf.append("unknown:/");
            for (Object value : params.values()) {
                if (value == null) continue;
                buf.append("/");
                buf.append(value);
            }
            return buf.toString();
        }

        @Override
        public ID toID(DataAccessFactory factory, Map<String, ?> params) {
            Params keys = new Params(factory);
            File file = keys.lookup(File.class, params);
            if (file != null) {
                ID id = new ID(file, factory.getDisplayName());
                return id;
            }
            URL url = keys.lookup(URL.class, params);
            if (url != null) {
                ID id = new ID(url, factory.getDisplayName());
                return id;
            }
            StringBuffer buf = new StringBuffer();
            buf.append("unknown:/");
            for (Object value : params.values()) {
                if (value == null) continue;
                buf.append("/");
                buf.append(value);
            }
            return new ID(buf.toString(), "unknown");
        }

        @Override
        public ImageDescriptor getIcon() {
            return CatalogUIPlugin.getDefault().getImageDescriptor("obj16/datastore_obj.gif");
        }
    };


    private GTFormat() {
    }

    abstract boolean accepts(DataAccessFactory var1);

    public abstract ID toID(DataAccessFactory var1, Map<String, ?> var2);

    public String getTitle(DataAccessFactory factory, Map<String, ?> params) {
        ID id = this.toID(factory, params);
        return id.labelServer();
    }

    public static GTFormat format(DataAccessFactory factory) {
        GTFormat[] gTFormatArray = GTFormat.values();
        int n = gTFormatArray.length;
        int n2 = 0;
        while (n2 < n) {
            GTFormat format = gTFormatArray[n2];
            if (format.accepts(factory)) {
                return format;
            }
            ++n2;
        }
        return OTHER;
    }

    public abstract ImageDescriptor getIcon();

    /* synthetic */ GTFormat(String string, int n, GTFormat gTFormat) {
        this();
    }
}

