/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.geotools.data;

import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;
import net.miginfocom.swt.MigLayout;
import net.refractions.udig.catalog.ui.AbstractUDIGImportPage;
import net.refractions.udig.catalog.ui.CatalogUIPlugin;
import net.refractions.udig.catalog.ui.UDIGConnectionPage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.DataAccessFinder;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.data.FileDataStoreFactorySpi;
import org.geotools.jdbc.JDBCDataStoreFactory;

public class DataStoreConnectionPage
extends AbstractUDIGImportPage
implements UDIGConnectionPage {
    private static final String DEFAULT_PROMPT = "Choose a data store you wish to connect to.";
    private static final String TYPE_FILTER_TEXT = "type filter text";
    protected DataAccessFactory factory = null;
    private LabelProvider labelProvider = new DataStoreLabelProvider();
    private TableViewer viewer;
    private Text filterText;
    private ViewerFilter filter = new ViewerFilter(){

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            DataAccessFactory factory = (DataAccessFactory)element;
            String search = DataStoreConnectionPage.this.filterText.getText();
            if (search == null || search.length() == 0 || search.equals(DataStoreConnectionPage.TYPE_FILTER_TEXT)) {
                return true;
            }
            search = search.toUpperCase();
            return factory.getDisplayName().toUpperCase().contains(search) || factory.getDescription().toUpperCase().contains(search);
        }
    };
    private ISelectionChangedListener listener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            IStructuredSelection selection;
            if (event.getSelection() instanceof IStructuredSelection && !(selection = (IStructuredSelection)event.getSelection()).isEmpty()) {
                DataAccessFactory factory = (DataAccessFactory)selection.getFirstElement();
                if (!factory.isAvailable()) {
                    DataStoreConnectionPage.this.setErrorMessage("This factory is not avaiable, usually indicating a missing JDBC driver, or ImageIO-EXT not being installed in your JRE.");
                    return;
                }
                DataStoreConnectionPage.this.setMessage(factory.getDescription(), 1);
            }
            DataStoreConnectionPage.this.setErrorMessage(null);
        }
    };
    private IDoubleClickListener clicked = new IDoubleClickListener(){

        public void doubleClick(DoubleClickEvent event) {
            IWizardContainer container = DataStoreConnectionPage.this.getContainer();
            if (container instanceof Dialog) {
                Dialog d = (Dialog)container;
                Button button = this.findButton(d.buttonBar, 15);
                if (button != null) {
                    button.notifyListeners(13, new Event());
                }
            }
        }

        protected Button findButton(Control buttonBar, int buttonID) {
            Button button;
            if (buttonBar instanceof Composite) {
                Control[] children;
                Composite composite = (Composite)buttonBar;
                Control[] controlArray = children = composite.getChildren();
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    Button button2;
                    Control control = controlArray[n2];
                    if (control instanceof Button ? (Integer)(button2 = (Button)control).getData() == buttonID : control instanceof Composite && (button2 = this.findButton(control, buttonID)) != null) {
                        return button2;
                    }
                    ++n2;
                }
            }
            if (buttonBar instanceof Button && (Integer)(button = (Button)buttonBar).getData() == buttonID) {
                return button;
            }
            return null;
        }
    };

    public DataAccessFactory getFactory() {
        if (this.viewer != null && !this.viewer.getControl().isDisposed()) {
            IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
            this.factory = selection.isEmpty() ? null : (DataAccessFactory)selection.getFirstElement();
        }
        return this.factory;
    }

    public DataStoreConnectionPage() {
        super("DataStore");
        this.setTitle("Select");
        this.setDescription(DEFAULT_PROMPT);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new MigLayout("", "[grow]", "[pref!]rel[pref!]rel[grow]"));
        this.setControl((Control)composite);
        Label prompt = new Label(composite, 16640);
        prompt.setLayoutData((Object)"wrap");
        prompt.setText("Select an input source:");
        this.filterText = new Text(composite, 132);
        this.filterText.setLayoutData((Object)"growx,wrap");
        this.filterText.setText(TYPE_FILTER_TEXT);
        this.filterText.setSelection(0, this.filterText.getCharCount());
        this.filterText.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                DataStoreConnectionPage.this.viewer.refresh();
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        ScrolledComposite scroll = new ScrolledComposite(composite, 2560);
        scroll.setLayoutData((Object)"growx,growy");
        scroll.setAlwaysShowScrollBars(true);
        scroll.setExpandHorizontal(true);
        scroll.setExpandVertical(true);
        scroll.setMinSize(300, 100);
        scroll.setSize(300, 100);
        this.viewer = new TableViewer((Composite)scroll, 4);
        scroll.setContent(this.viewer.getControl());
        this.viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.viewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        TreeSet<DataAccessFactory> sorted = new TreeSet<DataAccessFactory>(new Comparator<DataAccessFactory>(){

            @Override
            public int compare(DataAccessFactory factory1, DataAccessFactory factory2) {
                return factory1.getDisplayName().compareTo(factory2.getDisplayName());
            }
        });
        Iterator iter = DataAccessFinder.getAllDataStores();
        while (iter.hasNext()) {
            DataAccessFactory entry = (DataAccessFactory)iter.next();
            String name = entry.getDisplayName();
            if (name == null || name.indexOf("JNDI") != -1) continue;
            sorted.add(entry);
        }
        this.viewer.setInput(sorted);
        this.viewer.setFilters(new ViewerFilter[]{this.filter});
        this.viewer.addSelectionChangedListener(this.listener);
        this.viewer.addDoubleClickListener(this.clicked);
    }

    public boolean isPageComplete() {
        DataAccessFactory factory = this.getFactory();
        return factory != null && factory.isAvailable();
    }

    public class DataStoreLabelProvider
    extends LabelProvider {
        public String getText(Object element) {
            if (element instanceof DataAccessFactory) {
                DataAccessFactory factory = (DataAccessFactory)element;
                return factory.getDisplayName();
            }
            return super.getText(element);
        }

        public Image getImage(Object element) {
            String name = element.getClass().getSimpleName();
            if (element instanceof JDBCDataStoreFactory) {
                return CatalogUIPlugin.getDefault().getImage("obj16/database_obj.gif");
            }
            if (element instanceof FileDataStoreFactorySpi) {
                return CatalogUIPlugin.getDefault().getImage("obj16/feature_file_obj.gif");
            }
            if (name.indexOf("WFSDataStoreFactory") != -1) {
                return CatalogUIPlugin.getDefault().getImage("obj16/wfs_obj.gif");
            }
            if (name.indexOf("PropertyDataStoreFactory") != -1) {
                return CatalogUIPlugin.getDefault().getImage("obj16/feature_file_obj.gif");
            }
            if (name.indexOf("PostgisDataStoreFactory") != -1) {
                return CatalogUIPlugin.getDefault().getImage("obj16/database_obj.gif");
            }
            if (element instanceof DataStoreFactorySpi) {
                return CatalogUIPlugin.getDefault().getImage("obj16/datastore_obj.gif");
            }
            return super.getImage(element);
        }
    }
}

