/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.stream.old;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.methods.GetMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.util.CancelTask;

public class NetcdfRemote
extends NetcdfFile {
    public static final String SCHEME = "ncstream:";
    private static Logger logger = LoggerFactory.getLogger(NetcdfRemote.class);
    private static HttpClient httpClient;
    private final String remoteURI;

    public static void setHttpClient(HttpClient client) {
        httpClient = client;
    }

    private synchronized void initHttpClient() {
        if (httpClient != null) {
            return;
        }
        MultiThreadedHttpConnectionManager connectionManager = new MultiThreadedHttpConnectionManager();
        httpClient = new HttpClient((HttpConnectionManager)connectionManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public NetcdfRemote(String _remoteURI, CancelTask cancel) throws IOException {
        this.initHttpClient();
        if (_remoteURI.startsWith(SCHEME)) {
            this.remoteURI = "http:" + _remoteURI.substring(SCHEME.length());
            this.location = _remoteURI;
        } else {
            if (!_remoteURI.startsWith("http:")) throw new MalformedURLException(_remoteURI + " must start with dods: or http:");
            this.location = SCHEME + _remoteURI.substring(5);
            this.remoteURI = _remoteURI;
        }
        GetMethod method = null;
        try {
            method = new GetMethod(this.remoteURI);
            method.setFollowRedirects(true);
            int statusCode = httpClient.executeMethod((HttpMethod)method);
            if (statusCode == 404) {
                throw new FileNotFoundException(method.getPath() + " " + method.getStatusLine());
            }
            if (statusCode >= 300) {
                throw new IOException(method.getPath() + " " + method.getStatusLine());
            }
            InputStream is = method.getResponseBodyAsStream();
            this.open(is, cancel);
            Object var7_6 = null;
            if (method == null) return;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (method == null) throw throwable;
            method.releaseConnection();
            throw throwable;
        }
        method.releaseConnection();
    }

    NetcdfRemote(String fileURI) throws IOException {
        this.location = fileURI;
        this.remoteURI = fileURI;
        FileInputStream in = new FileInputStream(fileURI);
        this.open(in, null);
    }

    private void open(InputStream in, CancelTask cancel) throws IOException {
        long start = System.nanoTime();
        XMLInputFactory myFactory = XMLInputFactory.newInstance();
        myFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
        XMLStreamReader parser = null;
        Group parentGroup = this.getRootGroup();
        Variable usingVariable = null;
        int tab = 0;
        try {
            parser = myFactory.createXMLStreamReader(in);
            while (true) {
                int event;
                if ((event = parser.next()) == 8) {
                    parser.close();
                    break;
                }
                if (event == 1) {
                    if (parser.getLocalName().equals("attribute")) {
                        Attribute att = this.readAttribute(parser);
                        if (usingVariable != null) {
                            this.addVariableAttribute(usingVariable, att);
                        } else {
                            this.addAttribute(parentGroup, att);
                        }
                    }
                    if (parser.getLocalName().equals("dimension")) {
                        Dimension dim = this.readDimension(parser);
                        this.addDimension(parentGroup, dim);
                    }
                    if (parser.getLocalName().equals("group")) {
                        Group group = this.readGroup(parser, parentGroup);
                        this.addGroup(parentGroup, group);
                        parentGroup = group;
                    }
                    if (parser.getLocalName().equals("netcdf")) {
                        this.readNetcdf(parser);
                    }
                    if (parser.getLocalName().equals("values")) {
                        if (usingVariable == null) {
                            logger.warn("values element not inside a variable");
                            continue;
                        }
                        Array data = this.readValues(parser, usingVariable.getDataType());
                        if (data != null) {
                            usingVariable.setCachedData(data, false);
                        }
                    }
                    if (parser.getLocalName().equals("variable")) {
                        Variable v = this.readVariable(parser);
                        this.addVariable(parentGroup, v);
                        usingVariable = v;
                    }
                }
                if (event == 2) {
                    --tab;
                    if (parser.getLocalName().equals("group")) {
                        parentGroup = parentGroup.getParentGroup();
                    }
                    if (parser.getLocalName().equals("variable")) {
                        usingVariable = null;
                    }
                }
                if (cancel != null && cancel.isCancel()) break;
            }
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
            String text = parser.hasText() ? parser.getText().trim() : "";
            System.out.println("BAD  text=(" + text + ")");
        }
        this.finish();
        double took = 1.0E-9 * (double)(System.nanoTime() - start);
        System.out.println(" that took = " + took + "sec; ");
        System.out.println("\n" + this);
    }

    void indent(int tab) {
        for (int i = 0; i < tab; ++i) {
            System.out.print("  ");
        }
    }

    private Attribute readAttribute(XMLStreamReader parser) {
        DataType dtype;
        String name = null;
        String value = null;
        String typeName = null;
        String seperate = null;
        for (int a = 0; a < parser.getAttributeCount(); ++a) {
            if (parser.getAttributeLocalName(a).equals("name")) {
                name = parser.getAttributeValue(a);
                continue;
            }
            if (parser.getAttributeLocalName(a).equals("type")) {
                typeName = parser.getAttributeValue(a);
                continue;
            }
            if (parser.getAttributeLocalName(a).equals("value")) {
                value = parser.getAttributeValue(a);
                continue;
            }
            if (!parser.getAttributeLocalName(a).equals("separator")) continue;
            seperate = parser.getAttributeValue(a);
        }
        DataType dataType = dtype = typeName == null ? DataType.STRING : DataType.getType(typeName);
        if (dtype == DataType.STRING) {
            return new Attribute(name, value);
        }
        return new Attribute(name, this.convertValues(dtype, value, seperate));
    }

    private Array convertValues(DataType dtype, String values, String seperate) {
        if (seperate == null) {
            seperate = " ";
        }
        String[] value = values.split(seperate);
        return Array.makeArray(dtype, Arrays.asList(value));
    }

    private Dimension readDimension(XMLStreamReader parser) {
        String name = null;
        String length = null;
        boolean isUnlimited = false;
        boolean isVlen = false;
        boolean isShared = true;
        for (int a = 0; a < parser.getAttributeCount(); ++a) {
            if (parser.getAttributeLocalName(a).equals("name")) {
                name = parser.getAttributeValue(a);
                continue;
            }
            if (parser.getAttributeLocalName(a).equals("length")) {
                length = parser.getAttributeValue(a);
                continue;
            }
            if (parser.getAttributeLocalName(a).equals("isUnlimited")) {
                isUnlimited = Boolean.parseBoolean(parser.getAttributeValue(a));
                continue;
            }
            if (parser.getAttributeLocalName(a).equals("isVariableLength")) {
                isVlen = Boolean.parseBoolean(parser.getAttributeValue(a));
                continue;
            }
            if (!parser.getAttributeLocalName(a).equals("isShared")) continue;
            isShared = Boolean.parseBoolean(parser.getAttributeValue(a));
        }
        return new Dimension(name, Integer.parseInt(length), isShared, isUnlimited, isVlen);
    }

    private Group readGroup(XMLStreamReader parser, Group parent) {
        String name = null;
        for (int a = 0; a < parser.getAttributeCount(); ++a) {
            if (!parser.getAttributeLocalName(a).equals("name")) continue;
            name = parser.getAttributeValue(a);
        }
        return new Group(this, parent, name);
    }

    private void readNetcdf(XMLStreamReader parser) {
        for (int a = 0; a < parser.getAttributeCount(); ++a) {
            if (parser.getAttributeLocalName(a).equals("id")) {
                this.setId(parser.getAttributeValue(a));
                continue;
            }
            if (!parser.getAttributeLocalName(a).equals("title")) continue;
            this.setTitle(parser.getAttributeValue(a));
        }
    }

    private Variable readVariable(XMLStreamReader parser) {
        String name = null;
        String dims = null;
        String typeName = null;
        for (int a = 0; a < parser.getAttributeCount(); ++a) {
            if (parser.getAttributeLocalName(a).equals("name")) {
                name = parser.getAttributeValue(a);
                continue;
            }
            if (parser.getAttributeLocalName(a).equals("shape")) {
                dims = parser.getAttributeValue(a);
                continue;
            }
            if (!parser.getAttributeLocalName(a).equals("type")) continue;
            typeName = parser.getAttributeValue(a);
        }
        DataType dtype = DataType.getType(typeName);
        return new Variable(this, null, null, name, dtype, dims);
    }

    private Array readValues(XMLStreamReader parser, DataType dtype) throws XMLStreamException {
        String startS = null;
        String incrementS = null;
        String nptsS = null;
        String separator = null;
        for (int a = 0; a < parser.getAttributeCount(); ++a) {
            if (parser.getAttributeLocalName(a).equals("start")) {
                startS = parser.getAttributeValue(a);
                continue;
            }
            if (parser.getAttributeLocalName(a).equals("increment")) {
                incrementS = parser.getAttributeValue(a);
                continue;
            }
            if (parser.getAttributeLocalName(a).equals("npts")) {
                nptsS = parser.getAttributeValue(a);
                continue;
            }
            if (!parser.getAttributeLocalName(a).equals("separator")) continue;
            separator = parser.getAttributeValue(a);
        }
        if (startS != null && incrementS != null && nptsS != null) {
            int start = Integer.parseInt(startS);
            int increment = Integer.parseInt(incrementS);
            int npts = Integer.parseInt(nptsS);
            return Array.makeArray(dtype, start, increment, npts);
        }
        String values = parser.getElementText();
        if (values != null) {
            return this.convertValues(dtype, values, separator);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Array readData(Variable v, Section section) throws IOException, InvalidRangeException {
        Array array;
        block7: {
            StringBuilder sbuff = new StringBuilder(this.remoteURI);
            sbuff.append("?");
            sbuff.append(v.getShortName());
            sbuff.append("(");
            sbuff.append(section.toString());
            sbuff.append(")");
            if (showRequest) {
                System.out.println("NetcdfRemote data request for variable: " + v.getName() + " section= " + section + " url=" + sbuff);
            }
            GetMethod method = null;
            try {
                String s;
                int readLen;
                method = new GetMethod(sbuff.toString());
                method.setFollowRedirects(true);
                int statusCode = httpClient.executeMethod((HttpMethod)method);
                if (statusCode == 404) {
                    throw new FileNotFoundException(method.getPath() + " " + method.getStatusLine());
                }
                if (statusCode >= 300) {
                    throw new IOException(method.getPath() + " " + method.getStatusLine());
                }
                int wantSize = (int)((long)v.getElementSize() * section.computeSize());
                byte[] result = new byte[wantSize];
                Header h = method.getResponseHeader("Content-Length");
                if (h != null && (readLen = Integer.parseInt(s = h.getValue())) != wantSize) {
                    throw new IOException("content-length= " + readLen + " not equal expected Size= " + wantSize);
                }
                InputStream is = method.getResponseBodyAsStream();
                int actualRead = this.copy(is, result, 0, wantSize);
                if (actualRead != wantSize) {
                    throw new IOException("actualRead=" + actualRead + " not equal expected Size= " + wantSize);
                }
                array = this.convert(result, v.getDataType(), section);
                Object var13_12 = null;
                if (method == null) break block7;
            }
            catch (Throwable throwable) {
                block8: {
                    Object var13_13 = null;
                    if (method == null) break block8;
                    method.releaseConnection();
                }
                throw throwable;
            }
            method.releaseConnection();
        }
        return array;
    }

    private int copy(InputStream in, byte[] buff, int offset, int want) throws IOException {
        int bytesRead;
        int done = 0;
        while (want > 0 && (bytesRead = in.read(buff, offset + done, want)) != -1) {
            done += bytesRead;
            want -= bytesRead;
        }
        return done;
    }

    private Array convert(byte[] result, DataType dt, Section section) {
        int[] shape = section.getShape();
        if (dt == DataType.BYTE) {
            return Array.factory(dt.getPrimitiveClassType(), shape, (Object)result);
        }
        ByteBuffer bb = ByteBuffer.wrap(result);
        int n = (int)section.computeSize();
        if (dt == DataType.SHORT) {
            short[] pa = new short[n];
            for (int i = 0; i < n; ++i) {
                pa[i] = bb.getShort();
            }
            return Array.factory(dt.getPrimitiveClassType(), shape, (Object)pa);
        }
        if (dt == DataType.INT) {
            int[] pa = new int[n];
            for (int i = 0; i < n; ++i) {
                pa[i] = bb.getInt();
            }
            return Array.factory(dt.getPrimitiveClassType(), shape, (Object)pa);
        }
        if (dt == DataType.LONG) {
            long[] pa = new long[n];
            for (int i = 0; i < n; ++i) {
                pa[i] = bb.getLong();
            }
            return Array.factory(dt.getPrimitiveClassType(), shape, (Object)pa);
        }
        if (dt == DataType.FLOAT) {
            float[] pa = new float[n];
            for (int i = 0; i < n; ++i) {
                pa[i] = bb.getFloat();
            }
            return Array.factory(dt.getPrimitiveClassType(), shape, (Object)pa);
        }
        if (dt == DataType.DOUBLE) {
            double[] pa = new double[n];
            for (int i = 0; i < n; ++i) {
                pa[i] = bb.getDouble();
            }
            return Array.factory(dt.getPrimitiveClassType(), shape, (Object)pa);
        }
        if (dt == DataType.CHAR) {
            char[] pa = new char[n];
            for (int i = 0; i < n; ++i) {
                pa[i] = (char)bb.get();
            }
            return Array.factory(dt.getPrimitiveClassType(), shape, (Object)pa);
        }
        throw new IllegalStateException("unimplmeneted datatype = " + (Object)((Object)dt));
    }

    public static void main(String[] args) throws IOException {
        new NetcdfRemote("http://localhost:8080/thredds/netcdf/stream/test/testData.nc", null);
    }
}

