/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.grib;

import java.io.IOException;
import java.util.List;
import ucar.grib.Index;
import ucar.grib.NotSupportedException;
import ucar.grib.TableLookup;
import ucar.grib.grib2.Grib2Data;
import ucar.grib.grib2.Grib2Input;
import ucar.grib.grib2.Grib2Lookup;
import ucar.grib.grib2.Grib2Record;
import ucar.nc2.iosp.grib.GribServiceProvider;
import ucar.nc2.iosp.grib.Index2NC;
import ucar.nc2.util.CancelTask;
import ucar.unidata.io.RandomAccessFile;

public class Grib2ServiceProvider
extends GribServiceProvider {
    private Grib2Data dataReader;

    public boolean isValidFile(RandomAccessFile raf) {
        try {
            raf.seek(0L);
            raf.order(0);
            Grib2Input g2i = new Grib2Input(raf);
            int edition = g2i.getEdition();
            return edition == 2;
        }
        catch (Exception e) {
            return false;
        }
    }

    protected void open(Index index, CancelTask cancelTask) throws IOException {
        long startTime = System.currentTimeMillis();
        if (GribServiceProvider.debugOpen) {
            System.out.println("GribServiceProvider open = " + this.ncfile.getLocation());
        }
        Grib2Record firstRecord = null;
        try {
            Grib2Input g2i = new Grib2Input(this.raf);
            long start2 = System.currentTimeMillis();
            this.raf.seek(0L);
            g2i.scan(false, true);
            List records = g2i.getRecords();
            firstRecord = (Grib2Record)records.get(0);
            if (debugTiming) {
                long took = System.currentTimeMillis() - start2;
                System.out.println("  read one record took=" + took + " msec ");
            }
        }
        catch (NotSupportedException noSupport) {
            System.err.println("NotSupportedException : " + (Object)((Object)noSupport));
        }
        Grib2Lookup lookup = new Grib2Lookup(firstRecord);
        Index2NC delegate = new Index2NC();
        delegate.open(index, (TableLookup)lookup, 2, this.ncfile, this.fmrcCoordSys, cancelTask);
        this.ncfile.finish();
        this.dataReader = new Grib2Data(this.raf);
        if (debugTiming) {
            long took = System.currentTimeMillis() - startTime;
            System.out.println(" open " + this.ncfile.getLocation() + " took=" + took + " msec ");
        }
    }

    protected float[] _readData(long GdsOffset, long PdsOffset, int decimalScale, boolean bmsExists) throws IOException {
        return this.dataReader.getData(GdsOffset, PdsOffset);
    }
}

