/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.standard;

import java.io.IOException;
import ucar.ma2.StructureDataIterator;
import ucar.nc2.ft.PointFeatureIterator;
import ucar.nc2.ft.point.PointCollectionImpl;
import ucar.nc2.ft.point.standard.Cursor;
import ucar.nc2.ft.point.standard.NestedTable;
import ucar.nc2.ft.point.standard.StandardPointFeatureIterator;
import ucar.nc2.units.DateUnit;

public class StandardPointCollectionImpl
extends PointCollectionImpl {
    private DateUnit timeUnit;
    private NestedTable ft;

    StandardPointCollectionImpl(NestedTable ft, DateUnit timeUnit) {
        super(ft.getName());
        this.ft = ft;
        this.timeUnit = timeUnit;
    }

    public PointFeatureIterator getPointFeatureIterator(int bufferSize) throws IOException {
        Cursor tableData = new Cursor(this.ft.getNumberOfLevels());
        boolean calcBB = this.boundingBox == null || this.dateRange == null;
        return new TableIterator(this.ft.getObsDataIterator(tableData, bufferSize), tableData, calcBB);
    }

    private class TableIterator
    extends StandardPointFeatureIterator {
        TableIterator(StructureDataIterator structIter, Cursor tableData, boolean calcBB) throws IOException {
            super(StandardPointCollectionImpl.this.ft, StandardPointCollectionImpl.this.timeUnit, structIter, tableData, calcBB);
        }

        public boolean hasNext() throws IOException {
            boolean r = super.hasNext();
            if (!r) {
                if (StandardPointCollectionImpl.this.npts < 0) {
                    StandardPointCollectionImpl.this.npts = this.getCount();
                }
                if (this.calcBB) {
                    if (StandardPointCollectionImpl.this.boundingBox == null) {
                        StandardPointCollectionImpl.this.boundingBox = this.getBoundingBox();
                    }
                    if (StandardPointCollectionImpl.this.dateRange == null) {
                        StandardPointCollectionImpl.this.dateRange = this.getDateRange(StandardPointCollectionImpl.this.timeUnit);
                    }
                }
            }
            return r;
        }
    }
}

