/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point;

import java.io.IOException;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataIterator;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.PointFeatureIterator;
import ucar.nc2.units.DateRange;
import ucar.nc2.units.DateUnit;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;

public abstract class PointIteratorImpl
implements PointFeatureIterator {
    private PointFeatureIterator.Filter filter;
    private StructureDataIterator structIter;
    private int count = 0;
    private PointFeature feature = null;
    protected boolean calcBB;
    private LatLonRect bb = null;
    private double minTime = Double.MAX_VALUE;
    private double maxTime = -1.7976931348623157E308;

    protected abstract PointFeature makeFeature(int var1, StructureData var2) throws IOException;

    protected PointIteratorImpl(PointFeatureIterator.Filter filter, boolean calcBB) throws IOException {
        this.filter = filter;
        this.calcBB = calcBB;
    }

    protected PointIteratorImpl(StructureDataIterator structIter, PointFeatureIterator.Filter filter, boolean calcBB) throws IOException {
        this.structIter = structIter;
        this.filter = filter;
        this.calcBB = calcBB;
    }

    public boolean hasNext() throws IOException {
        StructureData sdata;
        while ((sdata = this.nextStructureData()) != null) {
            this.feature = this.makeFeature(this.count, sdata);
            if (this.feature == null || this.feature.getLocation().isMissing() || this.filter != null && !this.filter.filter(this.feature)) continue;
            return true;
        }
        if (this.calcBB) {
            this.finishCalc();
        }
        this.feature = null;
        return false;
    }

    public PointFeature next() throws IOException {
        if (this.feature == null) {
            return null;
        }
        if (this.calcBB) {
            this.doCalc(this.feature);
        }
        ++this.count;
        return this.feature;
    }

    public void setBufferSize(int bytes) {
        this.structIter.setBufferSize(bytes);
    }

    public void cancel() {
    }

    protected StructureData nextStructureData() throws IOException {
        return this.structIter.hasNext() ? this.structIter.next() : null;
    }

    private void doCalc(PointFeature pf) {
        if (this.bb == null) {
            this.bb = new LatLonRect(pf.getLocation().getLatLon(), 0.001, 0.001);
        } else {
            this.bb.extend(pf.getLocation().getLatLon());
        }
        double obsTime = pf.getObservationTime();
        this.minTime = Math.min(this.minTime, obsTime);
        this.maxTime = Math.max(this.maxTime, obsTime);
    }

    private void finishCalc() {
        if (this.bb.crossDateline() && this.bb.getWidth() > 350.0) {
            double lat_min = this.bb.getLowerLeftPoint().getLatitude();
            double deltaLat = this.bb.getUpperLeftPoint().getLatitude() - lat_min;
            this.bb = new LatLonRect(new LatLonPointImpl(lat_min, -180.0), deltaLat, 360.0);
        }
    }

    public LatLonRect getBoundingBox() {
        return this.bb;
    }

    public DateRange getDateRange(DateUnit timeUnit) {
        return new DateRange(timeUnit.makeDate(this.minTime), timeUnit.makeDate(this.maxTime));
    }

    public int getCount() {
        return this.count;
    }
}

