/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.jconsole.java;

import eu.udig.jconsole.util.Keywords;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationPresenter;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;

public class JavaCompletionProcessor
implements IContentAssistProcessor {
    protected static String[] singleWordsProposals = null;
    protected static String[] methodWordsProposals = null;
    protected IContextInformationValidator fValidator = new Validator();

    public JavaCompletionProcessor() {
        ArrayList<String> all;
        if (singleWordsProposals == null) {
            all = new ArrayList<String>();
            all.addAll(Keywords.getValues(Keywords.GEOSCRIPT));
            all.addAll(Keywords.getValues(Keywords.KEYWORDS));
            all.addAll(Keywords.getValues(Keywords.TYPES));
            all.addAll(Keywords.getValues(Keywords.CONSTANTS));
            all.addAll(Keywords.getValues(Keywords.JGTMODULES));
            singleWordsProposals = all.toArray(new String[0]);
        }
        if (methodWordsProposals == null) {
            all = new ArrayList();
            List<String> methods = Keywords.getValues(Keywords.METHODS);
            List<String> jgtmethods = Keywords.getValues(Keywords.JGTMETHODS);
            all.addAll(methods);
            all.addAll(jgtmethods);
            methodWordsProposals = all.toArray(new String[0]);
        }
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int documentOffset) {
        ArrayList<CompletionProposal> tmp;
        String guessedModelWord = null;
        String guessedMethodWord = null;
        String readWord = null;
        try {
            String text = viewer.getDocument().get(0, documentOffset);
            String[] textSplit = text.split("\\s+");
            readWord = textSplit[textSplit.length - 1];
            String[] split = readWord.split("\\.");
            if (split.length > 0) {
                guessedModelWord = split[0];
                if (split.length != 1) {
                    guessedMethodWord = split[1];
                }
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        ArrayList<Object> props = new ArrayList<Object>();
        if (guessedMethodWord != null) {
            tmp = new ArrayList<CompletionProposal>();
            int i = 0;
            while (i < methodWordsProposals.length) {
                CompletionProposal completionProposal;
                int cursorPosition;
                int replacementLength;
                int replacementOffset;
                String replacementString;
                String wordProposal = methodWordsProposals[i];
                if (wordProposal.toLowerCase().startsWith(guessedMethodWord.toLowerCase())) {
                    replacementString = wordProposal;
                    replacementOffset = documentOffset - guessedMethodWord.length();
                    replacementLength = guessedMethodWord.length();
                    cursorPosition = wordProposal.length();
                    completionProposal = new CompletionProposal(replacementString, replacementOffset, replacementLength, cursorPosition);
                    props.add(completionProposal);
                } else if (wordProposal.toLowerCase().contains(guessedMethodWord.toLowerCase())) {
                    replacementString = wordProposal;
                    replacementOffset = documentOffset - guessedMethodWord.length();
                    replacementLength = guessedMethodWord.length();
                    cursorPosition = wordProposal.length();
                    completionProposal = new CompletionProposal(replacementString, replacementOffset, replacementLength, cursorPosition);
                    tmp.add(completionProposal);
                }
                ++i;
            }
            props.addAll(tmp);
        } else if (readWord.endsWith(".")) {
            int i = 0;
            while (i < methodWordsProposals.length) {
                String replacementString = methodWordsProposals[i];
                int replacementOffset = documentOffset;
                int replacementLength = 0;
                int cursorPosition = methodWordsProposals[i].length();
                CompletionProposal completionProposal = new CompletionProposal(replacementString, replacementOffset, replacementLength, cursorPosition);
                props.add(completionProposal);
                ++i;
            }
        } else {
            tmp = new ArrayList();
            int i = 0;
            while (i < singleWordsProposals.length) {
                CompletionProposal completionProposal;
                int cursorPosition;
                int replacementLength;
                int replacementOffset;
                String replacementString;
                String wordProposal = singleWordsProposals[i];
                if (guessedModelWord != null && wordProposal.toLowerCase().startsWith(guessedModelWord.toLowerCase())) {
                    replacementString = wordProposal;
                    replacementOffset = documentOffset - guessedModelWord.length();
                    replacementLength = guessedModelWord.length();
                    cursorPosition = wordProposal.length();
                    completionProposal = new CompletionProposal(replacementString, replacementOffset, replacementLength, cursorPosition);
                    props.add(completionProposal);
                } else if (wordProposal.toLowerCase().contains(guessedModelWord.toLowerCase())) {
                    replacementString = wordProposal;
                    replacementOffset = documentOffset - guessedModelWord.length();
                    replacementLength = guessedModelWord.length();
                    cursorPosition = wordProposal.length();
                    completionProposal = new CompletionProposal(replacementString, replacementOffset, replacementLength, cursorPosition);
                    tmp.add(completionProposal);
                }
                ++i;
            }
            props.addAll(tmp);
        }
        return props.toArray(new ICompletionProposal[props.size()]);
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int documentOffset) {
        IContextInformation[] result = new IContextInformation[]{};
        return result;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return new char[]{'.', '('};
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return new char[]{'#'};
    }

    public IContextInformationValidator getContextInformationValidator() {
        return this.fValidator;
    }

    public String getErrorMessage() {
        return null;
    }

    protected static class Validator
    implements IContextInformationValidator,
    IContextInformationPresenter {
        protected int fInstallOffset;

        protected Validator() {
        }

        public boolean isContextInformationValid(int offset) {
            return Math.abs(this.fInstallOffset - offset) < 5;
        }

        public void install(IContextInformation info, ITextViewer viewer, int offset) {
            this.fInstallOffset = offset;
        }

        public boolean updatePresentation(int documentPosition, TextPresentation presentation) {
            return false;
        }
    }
}

