/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.jconsole;

import eu.udig.jconsole.JavaDocumentSetupParticipant;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.texteditor.AbstractDocumentProvider;

public class JavaEditorDocumentProvider
extends AbstractDocumentProvider {
    private JavaDocumentSetupParticipant m_documentSetup = new JavaDocumentSetupParticipant();

    protected IDocument createDocument(Object element) throws CoreException {
        if (element instanceof IEditorInput) {
            Document document = new Document();
            if (this.setDocumentContent((IDocument)document, (IEditorInput)element)) {
                this.setupDocument((IDocument)document);
            }
            return document;
        }
        return null;
    }

    private boolean setDocumentContent(IDocument document, IEditorInput input) throws CoreException {
        FileReader reader;
        try {
            reader = input instanceof IPathEditorInput ? new FileReader(((IPathEditorInput)input).getPath().toFile()) : new FileReader(input.getName());
        }
        catch (FileNotFoundException fileNotFoundException) {
            return true;
        }
        try {
            this.setDocumentContent(document, reader);
            return true;
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.ui.examples.rcp.texteditor", 0, "ERROR reading file", (Throwable)e));
        }
    }

    private void setDocumentContent(IDocument document, Reader reader) throws IOException {
        BufferedReader in = new BufferedReader(reader);
        try {
            StringBuffer buffer = new StringBuffer(512);
            char[] readBuffer = new char[512];
            int n = in.read(readBuffer);
            while (n > 0) {
                buffer.append(readBuffer, 0, n);
                n = in.read(readBuffer);
            }
            document.set(buffer.toString());
        }
        finally {
            ((Reader)in).close();
        }
    }

    protected void setupDocument(IDocument document) {
        this.m_documentSetup.setup(document);
    }

    protected IAnnotationModel createAnnotationModel(Object element) throws CoreException {
        return null;
    }

    protected void doSaveDocument(IProgressMonitor monitor, Object element, IDocument document, boolean overwrite) throws CoreException {
        if (element instanceof IPathEditorInput) {
            IPathEditorInput pei = (IPathEditorInput)element;
            IPath path = pei.getPath();
            File file = path.toFile();
            try {
                file.createNewFile();
                if (file.exists()) {
                    if (!file.canWrite()) {
                        throw new CoreException((IStatus)new Status(4, "org.eclipse.ui.examples.rcp.texteditor", 0, "file is read-only", null));
                    }
                } else {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.ui.examples.rcp.texteditor", 0, "ERROR creating file", null));
                }
                FileWriter writer = new FileWriter(file);
                this.writeDocumentContent(document, writer, monitor);
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.ui.examples.rcp.texteditor", 0, "ERROR when saving file", (Throwable)e));
            }
        }
    }

    private void writeDocumentContent(IDocument document, Writer writer, IProgressMonitor monitor) throws IOException {
        BufferedWriter out = new BufferedWriter(writer);
        try {
            out.write(document.get());
        }
        finally {
            ((Writer)out).close();
        }
    }

    protected IRunnableContext getOperationRunner(IProgressMonitor monitor) {
        return null;
    }

    public boolean isModifiable(Object element) {
        if (element instanceof IPathEditorInput) {
            IPathEditorInput pei = (IPathEditorInput)element;
            File file = pei.getPath().toFile();
            return file.canWrite() || !file.exists();
        }
        return false;
    }

    public boolean isReadOnly(Object element) {
        return !this.isModifiable(element);
    }

    public boolean isStateValidated(Object element) {
        return true;
    }
}

