/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.printing.model.impl;

import java.awt.Graphics2D;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import net.refractions.udig.printing.model.Box;
import net.refractions.udig.printing.model.BoxPrinter;
import net.refractions.udig.printing.model.Connection;
import net.refractions.udig.printing.model.Element;
import net.refractions.udig.printing.model.ModelFactory;
import net.refractions.udig.printing.model.ModelPackage;
import net.refractions.udig.printing.model.Page;
import net.refractions.udig.printing.model.PrintingModelPlugin;
import net.refractions.udig.printing.model.impl.BoxImpl;
import net.refractions.udig.printing.model.impl.ConnectionImpl;
import net.refractions.udig.printing.model.impl.ElementImpl;
import net.refractions.udig.printing.model.impl.PageImpl;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.XMLMemento;

public class ModelFactoryImpl
extends EFactoryImpl
implements ModelFactory {
    private final String SPLIT = "_|||_";

    public static ModelFactory init() {
        try {
            ModelFactory theModelFactory = (ModelFactory)EPackage.Registry.INSTANCE.getEFactory("http:///net/refractions/udig/printing/model.ecore");
            if (theModelFactory != null) {
                return theModelFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new ModelFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createBox();
            }
            case 1: {
                return this.createConnection();
            }
            case 2: {
                return this.createElement();
            }
            case 3: {
                return this.createPage();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 4: {
                return this.createGraphics2DFromString(eDataType, initialValue);
            }
            case 5: {
                return this.createDimensionFromString(eDataType, initialValue);
            }
            case 6: {
                return this.createPointFromString(eDataType, initialValue);
            }
            case 7: {
                return this.createIProgressMonitorFromString(eDataType, initialValue);
            }
            case 8: {
                return this.createBoxPrinterFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 4: {
                return this.convertGraphics2DToString(eDataType, instanceValue);
            }
            case 5: {
                return this.convertDimensionToString(eDataType, instanceValue);
            }
            case 6: {
                return this.convertPointToString(eDataType, instanceValue);
            }
            case 7: {
                return this.convertIProgressMonitorToString(eDataType, instanceValue);
            }
            case 8: {
                return this.convertBoxPrinterToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    @Override
    public Box createBox() {
        BoxImpl box = new BoxImpl();
        return box;
    }

    @Override
    public Connection createConnection() {
        ConnectionImpl connection = new ConnectionImpl();
        return connection;
    }

    @Override
    public Element createElement() {
        ElementImpl element = new ElementImpl();
        return element;
    }

    @Override
    public Page createPage() {
        PageImpl page = new PageImpl();
        return page;
    }

    public Graphics2D createGraphics2DFromString(EDataType eDataType, String initialValue) {
        return (Graphics2D)super.createFromString(eDataType, initialValue);
    }

    public String convertGraphics2DToString(EDataType eDataType, Object instanceValue) {
        return super.convertToString(eDataType, instanceValue);
    }

    public Dimension createDimensionFromString(EDataType eDataType, String initialValue) {
        Dimension dim;
        String[] parts = initialValue.split(",");
        try {
            dim = new Dimension(Integer.parseInt(parts[0]), Integer.parseInt(parts[1]));
        }
        catch (Exception e) {
            PrintingModelPlugin.log("", e);
            dim = new Dimension(0, 0);
        }
        return dim;
    }

    public String convertDimensionToString(EDataType eDataType, Object instanceValue) {
        Dimension dim = (Dimension)instanceValue;
        return String.valueOf(dim.width) + "," + dim.height;
    }

    public Point createPointFromString(EDataType eDataType, String initialValue) {
        Point point;
        String[] parts = initialValue.split(",");
        try {
            point = new Point(Integer.parseInt(parts[0].trim()), Integer.parseInt(parts[1].trim()));
        }
        catch (Exception e) {
            PrintingModelPlugin.log("", e);
            point = new Point(0, 0);
        }
        return point;
    }

    public String convertPointToString(EDataType eDataType, Object instanceValue) {
        Point point = (Point)instanceValue;
        return String.valueOf(point.x) + "," + point.y;
    }

    public IProgressMonitor createIProgressMonitorFromString(EDataType eDataType, String initialValue) {
        return (IProgressMonitor)super.createFromString(eDataType, initialValue);
    }

    public String convertIProgressMonitorToString(EDataType eDataType, Object instanceValue) {
        return super.convertToString(eDataType, instanceValue);
    }

    public BoxPrinter createBoxPrinterFromString(EDataType eDataType, String initialValue) {
        IConfigurationElement current;
        XMLMemento memento;
        block12: {
            IExtension extension;
            String className;
            block11: {
                String[] split = initialValue.split("_\\|\\|\\|_");
                String extensionID = split[0].trim();
                className = split[1].trim();
                String mementoString = split[2].trim();
                if (mementoString.length() == 0) {
                    return null;
                }
                memento = XMLMemento.createReadRoot((Reader)new StringReader(mementoString));
                extension = Platform.getExtensionRegistry().getExtension("net.refractions.udig.printing.ui.boxprinter", extensionID);
                if (extension != null) break block11;
                PrintingModelPlugin.log("The method " + className + "#getExtensionID() returned: " + extensionID + " this is not the correct extension id.  Check the extension id.  \nHint: Read the " + "javadocs for the method", null);
                return null;
            }
            try {
                IConfigurationElement[] elements = extension.getConfigurationElements();
                current = null;
                int i = 0;
                while (current == null && i < elements.length) {
                    current = elements[i];
                    if (current.getName().equals("editActionGroup")) {
                        current = null;
                    } else {
                        String attribute = current.getAttribute("class");
                        if (attribute == null) {
                            PrintingModelPlugin.log("The attribute of the extension: " + current.getNamespaceIdentifier() + "." + current.getName(), null);
                            current = null;
                        } else if (!attribute.equals(className)) {
                            current = null;
                        }
                    }
                    ++i;
                }
                if (current != null) break block12;
                return null;
            }
            catch (Exception e) {
                PrintingModelPlugin.log("Error while creating a box printer from string.", e);
                return null;
            }
        }
        BoxPrinter printer = (BoxPrinter)current.createExecutableExtension("class");
        printer.load((IMemento)memento);
        return printer;
    }

    public String convertBoxPrinterToString(EDataType eDataType, Object instanceValue) {
        BoxPrinter printer = (BoxPrinter)instanceValue;
        XMLMemento memento = XMLMemento.createWriteRoot((String)"boxPrinter");
        printer.save((IMemento)memento);
        StringWriter writer = new StringWriter();
        writer.getBuffer().append(printer.getExtensionPointID());
        writer.getBuffer().append("_|||_");
        writer.getBuffer().append(printer.getClass().getName());
        writer.getBuffer().append("_|||_");
        try {
            memento.save((Writer)writer);
        }
        catch (IOException iOException) {
            return "<boxPrinter></boxPrinter>";
        }
        return writer.getBuffer().toString();
    }

    @Override
    public ModelPackage getModelPackage() {
        return (ModelPackage)this.getEPackage();
    }

    @Deprecated
    public static ModelPackage getPackage() {
        return ModelPackage.eINSTANCE;
    }
}

