/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.printing.model.impl;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import net.refractions.udig.catalog.CatalogPlugin;
import net.refractions.udig.catalog.ID;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.catalog.URLUtils;
import net.refractions.udig.core.Pair;
import net.refractions.udig.mapgraphic.MapGraphicChooserDialog;
import net.refractions.udig.mapgraphic.internal.MapGraphicRenderer;
import net.refractions.udig.mapgraphic.internal.MapGraphicResource;
import net.refractions.udig.mapgraphic.internal.MapGraphicService;
import net.refractions.udig.printing.model.AbstractBoxPrinter;
import net.refractions.udig.printing.model.Box;
import net.refractions.udig.printing.model.Page;
import net.refractions.udig.printing.model.impl.MapBoxPrinter;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.ILayerListener;
import net.refractions.udig.project.LayerEvent;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.project.internal.LayerDecorator;
import net.refractions.udig.project.internal.LayerFactory;
import net.refractions.udig.project.internal.Map;
import net.refractions.udig.project.internal.ProjectFactory;
import net.refractions.udig.project.internal.render.CompositeRenderContext;
import net.refractions.udig.project.internal.render.RenderContext;
import net.refractions.udig.project.internal.render.ViewportModel;
import net.refractions.udig.project.internal.render.impl.CompositeRenderContextImpl;
import net.refractions.udig.project.internal.render.impl.ScaleUtils;
import net.refractions.udig.project.render.IRenderContext;
import net.refractions.udig.project.ui.ApplicationGIS;
import net.refractions.udig.project.ui.BoundsStrategy;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.PlatformUI;
import org.geotools.geometry.jts.ReferencedEnvelope;

public class MapGraphicBoxPrinter
extends AbstractBoxPrinter {
    private static final int DEFAULTDPI = 90;
    private int usedDpi = 90;
    private float scaleFactor = Float.NaN;
    private static final Layer NULL = new LayerDecorator(null);
    private Layer layer;
    private String warning;
    private ILayerListener layerListener = new ILayerListener(){

        public void refresh(LayerEvent event) {
            MapGraphicBoxPrinter.this.setDirty(true);
        }
    };
    private boolean inPreviewMode;

    public MapGraphicBoxPrinter() {
        System.out.println();
    }

    public MapGraphicBoxPrinter(Page page) {
        if (page != null) {
            this.scaleFactor = (float)page.getSize().width / (float)page.getPaperSize().height;
        }
    }

    @Override
    public void draw(Graphics2D graphics, IProgressMonitor monitor) {
        super.draw(graphics, monitor);
        if (Float.isNaN(this.scaleFactor)) {
            List<Box> boxes = this.getBox().getPage().getBoxes();
            for (Box box : boxes) {
                Object adapter = box.getBoxPrinter().getAdapter(Map.class);
                if (adapter == null) continue;
                this.scaleFactor = (float)box.getSize().width / (float)box.getPaperSize().height;
                break;
            }
        }
        if (this.warning != null) {
            this.drawWarning(graphics, this.warning);
            return;
        }
        if (this.layer == null) {
            this.queryForMapGraphic();
        }
        if (this.layer == null) {
            this.drawWarning(graphics, "Loading...");
        } else if (this.layer == NULL) {
            this.drawWarning(graphics, "A Decorator needs to be selected");
        } else {
            this.drawGraphic(graphics, monitor);
        }
    }

    private void drawGraphic(Graphics2D graphics, IProgressMonitor monitor) {
        Pair<Map, Pair<Dimension, Double>> info = this.findMap();
        if (info == null) {
            this.drawWarning(graphics, "A map needs to be added to this page");
        }
        List layers = ((Map)info.getLeft()).getLayersInternal();
        org.eclipse.draw2d.geometry.Dimension size = this.getBox().getSize();
        Rectangle rect = new Rectangle(size.width - 1, size.height - 1);
        this.layer.getStyleBlackboard().put("net.refractions.udig.printing.ui.locationStyle", (Object)rect);
        layers.add(this.layer);
        MapGraphicRenderer renderer = new MapGraphicRenderer();
        CompositeRenderContext toUseForRendering = this.createRenderContext(info, this.layer);
        renderer.setContext((IRenderContext)toUseForRendering);
        renderer.render(graphics, monitor);
    }

    @Override
    public void createPreview(Graphics2D graphics, IProgressMonitor monitor) {
        this.inPreviewMode = true;
        this.draw(graphics, monitor);
        this.setDirty(false);
        this.inPreviewMode = false;
    }

    private CompositeRenderContext createRenderContext(Pair<Map, Pair<Dimension, Double>> info, Layer layer) {
        Map map = (Map)info.getLeft();
        Dimension size = (Dimension)((Pair)info.getRight()).getLeft();
        double scale = (Double)((Pair)info.getRight()).getRight();
        ViewportModel viewportModel = map.getViewportModelInternal();
        ReferencedEnvelope bounds = viewportModel.getBounds();
        BoundsStrategy boundsStrategy = new BoundsStrategy(scale);
        RenderContext context = null;
        if (this.inPreviewMode && !Float.isNaN(this.scaleFactor)) {
            float dpiFloat = 90.0f * this.scaleFactor;
            context = ApplicationGIS.configureMapForRendering((Map)map, (Dimension)size, (int)((int)dpiFloat), (BoundsStrategy)boundsStrategy, (ReferencedEnvelope)bounds);
        } else {
            context = ApplicationGIS.configureMapForRendering((Map)map, (Dimension)size, (int)90, (BoundsStrategy)boundsStrategy, (ReferencedEnvelope)bounds);
        }
        context.setLayerInternal(layer);
        context.setGeoResourceInternal(layer.getGeoResource());
        CompositeRenderContextImpl toUseForRendering = new CompositeRenderContextImpl();
        toUseForRendering.addContexts(Collections.singleton(context));
        toUseForRendering.setRenderManagerInternal(context.getRenderManagerInternal());
        toUseForRendering.setMapInternal(context.getMapInternal());
        return toUseForRendering;
    }

    private Pair<Map, Pair<Dimension, Double>> findMap() {
        List<Box> boxes = this.getBox().getPage().getBoxes();
        for (Box box : boxes) {
            if (!(box.getBoxPrinter() instanceof MapBoxPrinter)) continue;
            MapBoxPrinter mapBoxPrinter = (MapBoxPrinter)box.getBoxPrinter();
            Map map = mapBoxPrinter.getMap();
            Map copy = (Map)EcoreUtil.copy((EObject)map);
            Dimension size = new Dimension(box.getSize().width, box.getSize().height);
            ViewportModel viewportModel = map.getViewportModelInternal();
            ReferencedEnvelope bounds = viewportModel.getBounds();
            double scale = ScaleUtils.calculateScaleDenominator((ReferencedEnvelope)bounds, (Dimension)size, (int)90);
            Pair details = new Pair((Object)size, (Object)scale);
            return new Pair((Object)copy, (Object)details);
        }
        return null;
    }

    private void drawWarning(Graphics2D graphics, String message) {
        graphics.setColor(Color.BLACK);
        int height = graphics.getFontMetrics().getHeight();
        int base = (this.getBox().getSize().height - height) / 2 + height;
        graphics.drawString(message, 0, base);
    }

    @Override
    public void save(IMemento memento) {
        memento.putTextData(URLUtils.urlToString((URL)this.layer.getID(), (boolean)false));
    }

    @Override
    public void load(IMemento memento) {
        String url = memento.getTextData();
        try {
            IGeoResource resource = (IGeoResource)CatalogPlugin.getDefault().getLocalCatalog().getById(IGeoResource.class, new ID(new URL(MapGraphicService.SERVICE_URL, url)), (IProgressMonitor)new NullProgressMonitor());
            this.setMapGraphic((MapGraphicResource)resource);
        }
        catch (IOException iOException) {
            this.setMissingResourceWarning();
        }
    }

    private void setMissingResourceWarning() {
        this.warning = "The map graphic is missing from your installation, talk to the creator of this page and make sure you have the correct plugins.";
    }

    private void queryForMapGraphic() {
        final Display display = this.findDisplay();
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                MapGraphicChooserDialog dialog = new MapGraphicChooserDialog(display.getActiveShell(), false);
                dialog.open();
                if (dialog.getSelectedResources().isEmpty()) {
                    MapGraphicBoxPrinter.this.layer = NULL;
                } else {
                    IGeoResource resource = (IGeoResource)dialog.getSelectedResources().get(0);
                    MapGraphicBoxPrinter.this.setMapGraphic((MapGraphicResource)resource);
                }
                MapGraphicBoxPrinter.this.setDirty(true);
            }
        });
    }

    private Display findDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = PlatformUI.getWorkbench().getDisplay();
        }
        return display;
    }

    @Override
    public String getExtensionPointID() {
        return "net.refractions.udig.printing.ui.standardBoxes";
    }

    public void setMapGraphic(MapGraphicResource resource) {
        LayerFactory factory = ProjectFactory.eINSTANCE.createLayerFactory();
        try {
            if (this.layer != null) {
                this.layer.removeListener(this.layerListener);
            }
            this.layer = factory.createLayer((IGeoResource)resource);
            this.layer.addListener(this.layerListener);
        }
        catch (IOException iOException) {
            this.setMissingResourceWarning();
        }
        this.setDirty(true);
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isAssignableFrom(ILayer.class)) {
            return this.layer;
        }
        if (adapter.isAssignableFrom(IGeoResource.class)) {
            return this.getMapGraphic();
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public MapGraphicResource getMapGraphic() {
        try {
            if (this.layer != null) {
                return (MapGraphicResource)this.layer.getResource(MapGraphicResource.class, (IProgressMonitor)new NullProgressMonitor());
            }
            return null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void setStyleBlackboardKey(String key, Object value) {
        if (this.layer == null) {
            throw new IllegalStateException("Please set the map graphic before calling this method.");
        }
        this.layer.getStyleBlackboard().put(key, value);
    }

    public Layer getLayer() {
        return this.layer;
    }
}

