/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.printing.model.impl;

import com.vividsolutions.jts.geom.Envelope;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.List;
import net.refractions.udig.printing.model.AbstractBoxPrinter;
import net.refractions.udig.printing.model.PrintingModelPlugin;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.ILayerListener;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.IMapCompositionListener;
import net.refractions.udig.project.IMapListener;
import net.refractions.udig.project.IProject;
import net.refractions.udig.project.LayerEvent;
import net.refractions.udig.project.MapCompositionEvent;
import net.refractions.udig.project.MapEvent;
import net.refractions.udig.project.command.MapCommand;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.project.internal.Map;
import net.refractions.udig.project.internal.command.navigation.SetViewportBBoxCommand;
import net.refractions.udig.project.internal.render.ViewportModel;
import net.refractions.udig.project.render.IViewportModel;
import net.refractions.udig.project.render.IViewportModelListener;
import net.refractions.udig.project.render.RenderException;
import net.refractions.udig.project.render.ViewportModelEvent;
import net.refractions.udig.project.ui.ApplicationGIS;
import net.refractions.udig.project.ui.BoundsStrategy;
import net.refractions.udig.project.ui.SelectionStyle;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.ui.IMemento;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class MapBoxPrinter
extends AbstractBoxPrinter
implements IAdaptable {
    Map map;
    private double scaleDenom;
    private SelectionStyle selectionStyle;
    ILayerListener layerListener = new ILayerListener(){

        public void refresh(LayerEvent event) {
            MapBoxPrinter.this.setDirty(true);
        }
    };
    IMapCompositionListener mapCompositionListener = new IMapCompositionListener(){

        public void changed(MapCompositionEvent event) {
            MapBoxPrinter.this.setDirty(true);
            this.removeLayerListenersFromRemovedLayers(event);
            this.addLayerListenerToNewLayers(event);
        }

        private void removeLayerListenersFromRemovedLayers(MapCompositionEvent event) {
            if (event.getOldValue() != null) {
                if (event.getOldValue() instanceof ILayer) {
                    ILayer layer = (ILayer)event.getOldValue();
                    layer.removeListener(MapBoxPrinter.this.layerListener);
                }
                if (event.getOldValue() instanceof List) {
                    List layers = (List)event.getOldValue();
                    for (ILayer layer2 : layers) {
                        layer2.removeListener(MapBoxPrinter.this.layerListener);
                    }
                }
            }
        }

        private void addLayerListenerToNewLayers(MapCompositionEvent event) {
            if (event.getNewValue() != null) {
                if (event.getNewValue() instanceof ILayer) {
                    ILayer layer = (ILayer)event.getNewValue();
                    layer.addListener(MapBoxPrinter.this.layerListener);
                }
                if (event.getNewValue() instanceof List) {
                    List layers = (List)event.getNewValue();
                    for (ILayer layer2 : layers) {
                        layer2.addListener(MapBoxPrinter.this.layerListener);
                    }
                }
            }
        }
    };
    IViewportModelListener viewportListener = new IViewportModelListener(){

        public void changed(ViewportModelEvent event) {
            MapBoxPrinter.this.setDirty(true);
        }
    };
    IMapListener mapListener = new IMapListener(){

        public void changed(MapEvent event) {
            switch (event.getType()) {
                case VIEWPORT_MODEL: {
                    if (event.getNewValue() != null) {
                        ((ViewportModel)event.getNewValue()).addViewportModelListener(MapBoxPrinter.this.viewportListener);
                    }
                    if (event.getOldValue() == null) break;
                    ((ViewportModel)event.getOldValue()).removeViewportModelListener(MapBoxPrinter.this.viewportListener);
                    break;
                }
            }
        }
    };
    BufferedImage preview;
    State current;

    public MapBoxPrinter() {
        this.scaleDenom = -1.0;
        this.selectionStyle = SelectionStyle.EXCLUSIVE_ALL_SELECTION;
    }

    public MapBoxPrinter(SelectionStyle ss) {
        this.scaleDenom = -1.0;
        this.selectionStyle = ss;
    }

    public MapBoxPrinter(double scaleDenom, SelectionStyle selectionStyle) {
        this.selectionStyle = selectionStyle;
        this.scaleDenom = scaleDenom;
    }

    public Map getMap() {
        return this.map;
    }

    public void setMap(IMap map2) {
        List layers;
        Map oldMap = this.map;
        if (oldMap != null) {
            oldMap.removeMapCompositionListener(this.mapCompositionListener);
            oldMap.getViewportModel().removeViewportModelListener(this.viewportListener);
            oldMap.removeMapListener(this.mapListener);
            layers = oldMap.getLayersInternal();
            for (Layer layer : layers) {
                layer.removeListener(this.layerListener);
            }
        }
        this.map = (Map)map2;
        if (this.map != null) {
            this.map.addMapCompositionListener(this.mapCompositionListener);
            this.map.getViewportModel().addViewportModelListener(this.viewportListener);
            this.map.addMapListener(this.mapListener);
            layers = this.map.getLayersInternal();
            for (Layer layer : layers) {
                layer.addListener(this.layerListener);
            }
        }
    }

    @Override
    public void draw(Graphics2D graphics, IProgressMonitor monitor) {
        super.draw(graphics, monitor);
        try {
            org.eclipse.draw2d.geometry.Dimension size = this.getBox().getSize();
            graphics.setClip(1, 1, size.width - 2, size.height - 2);
            Dimension awtSize = new Dimension(size.width, size.height);
            IMap modifiedMap = null;
            if (this.scaleDenom == -1.0) {
                modifiedMap = ApplicationGIS.drawMap((ApplicationGIS.DrawMapParameter)new ApplicationGIS.DrawMapParameter(graphics, awtSize, (IMap)this.getMap(), null, 90, this.selectionStyle, monitor, true, true));
            } else {
                BoundsStrategy boundsStrategy = new BoundsStrategy(this.scaleDenom);
                modifiedMap = ApplicationGIS.drawMap((ApplicationGIS.DrawMapParameter)new ApplicationGIS.DrawMapParameter(graphics, awtSize, (IMap)this.getMap(), boundsStrategy, 90, this.selectionStyle, monitor, true, true));
            }
            if (!this.getMap().getViewportModel().getBounds().equals((Object)modifiedMap.getViewportModel().getBounds())) {
                SetViewportBBoxCommand cmdBBox = new SetViewportBBoxCommand(modifiedMap.getViewportModel().getBounds());
                this.getMap().sendCommandSync((MapCommand)cmdBBox);
            }
            graphics.setClip(0, 0, size.width, size.height);
        }
        catch (RenderException e) {
            PrintingModelPlugin.log(null, e);
        }
    }

    @Override
    public void createPreview(Graphics2D graphics, IProgressMonitor monitor) {
        block5: {
            org.eclipse.draw2d.geometry.Dimension size = this.getBox().getSize();
            try {
                if (this.map == null) break block5;
                this.preview = new BufferedImage(size.width, size.height, 2);
                Graphics2D g = this.preview.createGraphics();
                try {
                    ApplicationGIS.drawMap((ApplicationGIS.DrawMapParameter)new ApplicationGIS.DrawMapParameter(g, new Dimension(size.width, size.height), (IMap)this.map, monitor));
                }
                finally {
                    g.dispose();
                }
                this.current = new State(this.map.getViewportModel(), this.getBox().getSize());
                graphics.drawImage(this.preview, 0, 0, size.width, size.height, 0, 0, this.preview.getWidth(), this.preview.getHeight(), null);
            }
            catch (Exception e) {
                PrintingModelPlugin.log("", e);
                String message = "Error rendering Map:  " + e.getMessage();
                this.drawErrorMessage(graphics, message);
            }
        }
        this.setDirty(false);
    }

    private void drawErrorMessage(Graphics2D g, String message) {
        org.eclipse.draw2d.geometry.Dimension size = this.getBox().getSize();
        g.setColor(Color.YELLOW);
        Rectangle2D bounds = g.getFontMetrics().getStringBounds(message, g);
        g.fillRect((int)((double)(size.width / 2) - bounds.getWidth() / 2.0) - 2, (int)((double)(size.height / 2) - bounds.getHeight() / 2.0) + 2, (int)bounds.getWidth() + 4, (int)bounds.getHeight() + 4);
        g.setColor(Color.BLACK);
        g.drawString(message, (int)((double)(size.width / 2) - bounds.getWidth() / 2.0), (int)((double)(size.height / 2) + bounds.getHeight() / 2.0));
    }

    @Override
    public boolean isNewPreviewNeeded() {
        org.eclipse.draw2d.geometry.Dimension size = this.getBox().getSize();
        double aspectRatio = (double)size.height / (double)size.width;
        return super.isNewPreviewNeeded() || this.preview == null || this.current == null || !this.current.bounds.equals((Object)this.map.getViewportModel().getBounds()) || this.current.crs != this.map.getViewportModel().getCRS() || Math.abs(this.current.aspectRatio - aspectRatio) > 1.0E-5;
    }

    @Override
    public void save(IMemento memento) {
        System.out.println(this.map.getID());
        memento.putString("mapId", this.map.getID().toString());
        memento.putString("projectId", this.map.getProject().getID().toString());
    }

    @Override
    public void load(IMemento value) {
        URI mapId = URI.createURI((String)value.getString("mapId"));
        URI projectId = URI.createURI((String)value.getString("projectId"));
        List projects = ApplicationGIS.getProjects();
        block0: for (IProject project : projects) {
            if (!project.getID().equals((Object)projectId)) continue;
            List maps = project.getElements(IMap.class);
            for (IMap map : maps) {
                if (!map.getID().equals((Object)mapId)) continue;
                this.setMap(map);
                continue block0;
            }
        }
    }

    @Override
    public String getExtensionPointID() {
        return "net.refractions.udig.printing.ui.standardBoxes";
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isAssignableFrom(Map.class)) {
            return this.map;
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    static class State {
        private double aspectRatio;
        Envelope bounds;
        CoordinateReferenceSystem crs;

        public State(IViewportModel viewportModel, org.eclipse.draw2d.geometry.Dimension size) {
            this.bounds = viewportModel.getBounds();
            this.crs = viewportModel.getCRS();
            this.aspectRatio = (double)size.height / (double)size.width;
        }
    }
}

