/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.printing.model.impl;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArraySet;
import net.refractions.udig.printing.model.Box;
import net.refractions.udig.printing.model.BoxPrinter;
import net.refractions.udig.printing.model.Connection;
import net.refractions.udig.printing.model.ModelPackage;
import net.refractions.udig.printing.model.impl.ElementImpl;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Display;

public class BoxImpl
extends ElementImpl
implements Box {
    protected EList<Connection> sourceConnections;
    protected EList<Connection> targetConnections;
    protected static final BoxPrinter BOX_PRINTER_EDEFAULT = null;
    protected BoxPrinter boxPrinter = BOX_PRINTER_EDEFAULT;
    protected static final String ID_EDEFAULT = null;
    protected String iD = ID_EDEFAULT;
    CopyOnWriteArraySet<IPropertyChangeListener> listeners = new CopyOnWriteArraySet();

    @Override
    protected EClass eStaticClass() {
        return ModelPackage.Literals.BOX;
    }

    @Override
    public List<Connection> getSourceConnections() {
        if (this.sourceConnections == null) {
            this.sourceConnections = new EObjectResolvingEList(Connection.class, (InternalEObject)this, 3);
        }
        return this.sourceConnections;
    }

    @Override
    public List<Connection> getTargetConnections() {
        if (this.targetConnections == null) {
            this.targetConnections = new EObjectResolvingEList(Connection.class, (InternalEObject)this, 4);
        }
        return this.targetConnections;
    }

    @Override
    public BoxPrinter getBoxPrinter() {
        return this.boxPrinter;
    }

    @Override
    public void setBoxPrinter(BoxPrinter value) {
        value.setBox(this);
        this.setBoxPrinterGen(value);
    }

    public void setBoxPrinterGen(BoxPrinter newBoxPrinter) {
        BoxPrinter oldBoxPrinter = this.boxPrinter;
        this.boxPrinter = newBoxPrinter;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, (Object)oldBoxPrinter, (Object)this.boxPrinter));
        }
    }

    @Override
    public String getID() {
        return this.iD;
    }

    @Override
    public void setID(String newID) {
        String oldID = this.iD;
        this.iD = newID;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 6, (Object)oldID, (Object)this.iD));
        }
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 3: {
                return this.getSourceConnections();
            }
            case 4: {
                return this.getTargetConnections();
            }
            case 5: {
                return this.getBoxPrinter();
            }
            case 6: {
                return this.getID();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 3: {
                this.getSourceConnections().clear();
                this.getSourceConnections().addAll((Collection)newValue);
                return;
            }
            case 4: {
                this.getTargetConnections().clear();
                this.getTargetConnections().addAll((Collection)newValue);
                return;
            }
            case 5: {
                this.setBoxPrinter((BoxPrinter)newValue);
                return;
            }
            case 6: {
                this.setID((String)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 3: {
                this.getSourceConnections().clear();
                return;
            }
            case 4: {
                this.getTargetConnections().clear();
                return;
            }
            case 5: {
                this.setBoxPrinter(BOX_PRINTER_EDEFAULT);
                return;
            }
            case 6: {
                this.setID(ID_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 3: {
                return this.sourceConnections != null && !this.sourceConnections.isEmpty();
            }
            case 4: {
                return this.targetConnections != null && !this.targetConnections.isEmpty();
            }
            case 5: {
                return BOX_PRINTER_EDEFAULT == null ? this.boxPrinter != null : !BOX_PRINTER_EDEFAULT.equals(this.boxPrinter);
            }
            case 6: {
                return ID_EDEFAULT == null ? this.iD != null : !ID_EDEFAULT.equals(this.iD);
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (boxPrinter: ");
        result.append(this.boxPrinter);
        result.append(", iD: ");
        result.append(this.iD);
        result.append(')');
        return result.toString();
    }

    @Override
    public void add(Connection connection) {
        if (connection == null) {
            throw new IllegalArgumentException("Connection cannot be null");
        }
        if (connection.getTarget() == connection.getSource()) {
            throw new IllegalArgumentException("Connection source and target cannot be the same");
        }
        if (connection.getSource() == this) {
            this.getSourceConnections().add(connection);
        } else if (connection.getTarget() == this) {
            this.getTargetConnections().add(connection);
        }
    }

    @Override
    public void remove(Connection connection) {
        if (connection == null) {
            throw new IllegalArgumentException("Connection cannot be null");
        }
        if (connection.getSource() == this) {
            this.getSourceConnections().remove(connection);
        } else if (connection.getTarget() == this) {
            this.getTargetConnections().remove(connection);
        }
    }

    @Override
    public void notifyPropertyChange(final PropertyChangeEvent event) {
        Display display = Display.getCurrent();
        if (display == null) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    for (IPropertyChangeListener l : BoxImpl.this.listeners) {
                        l.propertyChange(event);
                    }
                }
            });
        } else {
            for (IPropertyChangeListener l : this.listeners) {
                l.propertyChange(event);
            }
        }
    }

    @Override
    public void addPropertyChangeListener(IPropertyChangeListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removePropertyChangeListener(IPropertyChangeListener l) {
        this.listeners.remove(l);
    }

    public Object getAdapter(Class adapter) {
        Object obj = Platform.getAdapterManager().getAdapter((Object)this, adapter);
        if (obj != null) {
            return obj;
        }
        BoxPrinter printer = this.getBoxPrinter();
        if (printer != null) {
            return printer.getAdapter(adapter);
        }
        return null;
    }
}

