/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.printing.model;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import net.refractions.udig.printing.model.Box;
import net.refractions.udig.printing.model.BoxPrinter;
import net.refractions.udig.printing.model.PropertyListener;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.IMemento;

public abstract class AbstractBoxPrinter
implements BoxPrinter {
    private Box box;
    private boolean dirty = false;
    private Color borderColor = null;
    private Stroke borderStroke = null;
    private Color fillColor = null;
    private PropertyListener listener = new PropertyListener(){

        @Override
        protected void locationChanged() {
            AbstractBoxPrinter.this.boxLocationChanged();
        }

        @Override
        protected void sizeChanged() {
            AbstractBoxPrinter.this.boxSizeChanged();
        }
    };

    @Override
    public void draw(Graphics2D graphics, IProgressMonitor monitor) {
        int boxWidth = this.getBox().getSize().width;
        int boxHeight = this.getBox().getSize().height;
        if (this.fillColor != null) {
            graphics.setColor(this.fillColor);
            graphics.fillRect(0, 0, boxWidth - 1, boxHeight - 1);
        }
        if (this.borderStroke != null && this.borderColor != null) {
            graphics.setColor(this.borderColor);
            graphics.setStroke(this.borderStroke);
            graphics.drawRect(0, 0, boxWidth - 1, boxHeight - 1);
        }
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
        this.setDirty(true);
    }

    public Stroke getBorderStroke() {
        return this.borderStroke;
    }

    public void setBorderStroke(Stroke borderStroke) {
        this.borderStroke = borderStroke;
        this.setDirty(true);
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public void setFillColor(Color fillColor) {
        this.fillColor = fillColor;
        this.setDirty(true);
    }

    protected void boxLocationChanged() {
        this.dirty = true;
    }

    protected void boxSizeChanged() {
        this.dirty = true;
    }

    @Override
    public void save(IMemento memento) {
    }

    @Override
    public void load(IMemento memento) {
    }

    @Override
    public void createPreview(Graphics2D graphics, IProgressMonitor monitor) {
        this.draw(graphics, monitor);
        this.dirty = false;
    }

    @Override
    public boolean isNewPreviewNeeded() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        boolean oldDirty = this.dirty;
        this.dirty = dirty;
        if (dirty && this.getBox() != null) {
            this.getBox().notifyPropertyChange(new PropertyChangeEvent((Object)this, "dirty", (Object)oldDirty, (Object)dirty));
        }
    }

    @Override
    public Box getBox() {
        return this.box;
    }

    @Override
    public void setBox(Box box2) {
        if (this.box != null) {
            this.box.eAdapters().remove((Object)this.listener);
        }
        this.box = box2;
        if (this.box != null) {
            this.box.eAdapters().add((Object)this.listener);
        }
    }

    public static float cm2point(float cm) {
        return AbstractBoxPrinter.inch2point(AbstractBoxPrinter.cm2inch(cm));
    }

    public static float cm2inch(float cm) {
        return cm / 2.54f;
    }

    public static float inch2point(float inch) {
        return inch * 72.0f;
    }

    public static float point2cm(float point) {
        return AbstractBoxPrinter.inch2cm(AbstractBoxPrinter.point2inch(point));
    }

    public static float inch2cm(float inch) {
        return inch * 2.54f;
    }

    public static float point2inch(float point) {
        return point / 72.0f;
    }
}

