/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tool.info.internal.display;

import java.io.IOException;
import net.refractions.udig.tool.info.InfoDisplay;
import net.refractions.udig.tool.info.InfoPlugin;
import net.refractions.udig.tool.info.LayerPointInfo;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationAdapter;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.StatusTextEvent;
import org.eclipse.swt.browser.StatusTextListener;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.browser.TitleListener;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ToolBar;

public class BrowserInfoDisplay
extends InfoDisplay {
    protected Browser browser;
    private Action backAction = new Action("Back"){

        public void run() {
            BrowserInfoDisplay.this.browser.back();
        }
    };
    private Action forwardAction = new Action("Forward"){

        public void run() {
            BrowserInfoDisplay.this.browser.forward();
        }
    };
    private Action stopAction = new Action("Stop"){

        public void run() {
            BrowserInfoDisplay.this.browser.stop();
        }
    };
    private Action refreshAction = new Action("Refresh"){

        public void run() {
            BrowserInfoDisplay.this.browser.refresh();
        }
    };
    protected static final boolean DEBUG = false;
    private ViewForm viewForm;

    @Override
    public Control getControl() {
        return this.viewForm;
    }

    @Override
    public void createDisplay(Composite parent) {
        this.viewForm = new ViewForm(parent, 0);
        ToolBar toolBar = new ToolBar((Composite)this.viewForm, 0x800040);
        this.viewForm.setTopCenter((Control)toolBar);
        this.browser = this.createBrowser((Composite)this.viewForm, toolBar);
        this.browser.setUrl("about:blank");
        this.viewForm.setContent((Control)this.browser);
    }

    @Override
    public void setInfo(LayerPointInfo info) {
        if (info == null || info.getRequestURL() == null) {
            this.browser.setVisible(false);
        } else {
            this.browser.setVisible(true);
            try {
                this.browser.setText((String)info.acquireValue());
            }
            catch (IOException e) {
                InfoPlugin.trace("Could not acquire info value", e);
            }
        }
    }

    private Browser createBrowser(Composite parent, ToolBar toolbar) {
        try {
            this.browser = new Browser(parent, 0);
        }
        catch (Exception e) {
            InfoPlugin.log("Could not create browser", e);
        }
        this.browser.addStatusTextListener(new StatusTextListener(){

            public void changed(StatusTextEvent event) {
            }
        });
        this.browser.addLocationListener((LocationListener)new LocationAdapter(){

            public void changed(LocationEvent event) {
                boolean cfr_ignored_0 = event.top;
            }
        });
        this.browser.addTitleListener(new TitleListener(){

            public void changed(TitleEvent event) {
            }
        });
        ToolBarManager tbmanager = new ToolBarManager(toolbar);
        tbmanager.add((IAction)this.backAction);
        tbmanager.add((IAction)this.forwardAction);
        tbmanager.add((IAction)this.stopAction);
        tbmanager.add((IAction)this.refreshAction);
        return this.browser;
    }
}

