/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tool.info.internal;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.core.internal.FeatureUtils;
import net.refractions.udig.project.AdaptableFeature;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.ILayerListener;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.IMapCompositionListener;
import net.refractions.udig.project.Interaction;
import net.refractions.udig.project.LayerEvent;
import net.refractions.udig.project.MapCompositionEvent;
import net.refractions.udig.project.internal.impl.LayerImpl;
import net.refractions.udig.project.ui.ApplicationGIS;
import net.refractions.udig.project.ui.internal.properties.FeaturePropertySource;
import net.refractions.udig.tool.info.CoveragePointInfo;
import net.refractions.udig.tool.info.InfoPlugin;
import net.refractions.udig.tool.info.LayerPointInfo;
import net.refractions.udig.tool.info.internal.CoverageDescribeLayer;
import net.refractions.udig.tool.info.internal.DataStoreDescribeLayer;
import net.refractions.udig.tool.info.internal.Messages;
import net.refractions.udig.tool.info.internal.WMSDescribeLayer;
import net.refractions.udig.tool.info.internal.display.BrowserInfoDisplay;
import net.refractions.udig.tool.info.internal.display.TextInfoDisplay;
import net.refractions.udig.ui.SearchPart;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.views.properties.PropertySheetPage;
import org.geotools.data.FeatureEvent;
import org.geotools.data.FeatureSource;
import org.geotools.data.ows.Layer;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.filter.text.ecql.ECQL;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.Id;
import org.opengis.filter.expression.Expression;

public class InfoView2
extends SearchPart {
    public static final String VIEW_ID = "net.refractions.udig.tool.info.infoView";
    private Text information;
    private TextInfoDisplay textDisplay;
    private BrowserInfoDisplay browserDisplay;
    private PropertySheetPage featureDisplay;
    private IMapCompositionListener mapListener;
    private ILayerListener layerListener;
    private List<ILayer> layerList;
    private Thread fatherThread = null;
    protected ImageRegistry registry;

    public InfoView2() {
        super(InfoPlugin.getDefault().getDialogSettings());
    }

    private void initiListeners() {
        this.mapListener = new IMapCompositionListener(){

            public void changed(MapCompositionEvent event) {
                InfoView2.this.updatedMapLayersActions(event);
            }
        };
        this.layerListener = new ILayerListener(){

            public void refresh(LayerEvent event) {
                InfoView2.this.updateLayerActions(event);
            }
        };
    }

    protected Composite createDetails(SashForm splitter) {
        this.initiListeners();
        this.fatherThread = Thread.currentThread();
        PageBook book = new PageBook((Composite)splitter, 0);
        splitter.setWeights(new int[]{10, 90});
        this.information = new Text((Composite)book, 64);
        this.information.setText(Messages.InfoView_instructions_text);
        book.showPage((Control)this.information);
        this.textDisplay = new TextInfoDisplay();
        this.textDisplay.createDisplay((Composite)book);
        this.browserDisplay = new BrowserInfoDisplay();
        this.browserDisplay.createDisplay((Composite)book);
        this.featureDisplay = new PropertySheetPage();
        this.featureDisplay.createControl((Composite)book);
        return book;
    }

    protected void fillActionBars() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        IToolBarManager toolBar = actionBars.getToolBarManager();
        IAction infoTool = ApplicationGIS.getToolManager().getToolAction("net.refractions.udig.tool.info.infoMode", "net.refractions.udig.tool.category.info");
        assert (infoTool != null);
        if (toolBar != null) {
            toolBar.add(infoTool);
        }
        super.fillActionBars();
    }

    protected PageBook getDetails() {
        return (PageBook)super.getDetails();
    }

    protected void showDetail(Object selection) {
        Object info;
        if (selection == null) {
            this.getDetails().showPage((Control)this.information);
            return;
        }
        if (selection instanceof SimpleFeature) {
            this.getDetails().showPage(this.featureDisplay.getControl());
            FeaturePropertySource source = new FeaturePropertySource((SimpleFeature)selection, false, false);
            StructuredSelection sel = new StructuredSelection((Object)source);
            this.featureDisplay.selectionChanged(null, (ISelection)sel);
        }
        if (selection instanceof LayerPointInfo) {
            info = (LayerPointInfo)selection;
            if (((LayerPointInfo)info).getMimeType() == null) {
                this.getDetails().showPage((Control)this.information);
            } else if (((LayerPointInfo)info).getMimeType().startsWith("application/vnd.ogc.gml")) {
                this.getDetails().showPage(this.featureDisplay.getControl());
                try {
                    SimpleFeature feature = (SimpleFeature)((LayerPointInfo)info).acquireValue();
                    FeaturePropertySource src = new FeaturePropertySource(feature);
                    StructuredSelection sel = new StructuredSelection((Object)src);
                    this.featureDisplay.selectionChanged(null, (ISelection)sel);
                }
                catch (IOException ex) {
                    InfoPlugin.log("GML value could not be acquired.", ex);
                }
            } else if (((LayerPointInfo)info).getRequestURL() != null && ((LayerPointInfo)info).getMimeType().startsWith("text/html")) {
                this.getDetails().showPage(this.browserDisplay.getControl());
                this.browserDisplay.setInfo((LayerPointInfo)info);
            } else if (((LayerPointInfo)info).getRequestURL() != null && ((LayerPointInfo)info).getMimeType().startsWith("text/xml")) {
                this.getDetails().showPage(this.browserDisplay.getControl());
                this.browserDisplay.setInfo((LayerPointInfo)info);
            } else if (((LayerPointInfo)info).getRequestURL() != null && ((LayerPointInfo)info).getMimeType().startsWith("application/vnd.ogc.se_xml")) {
                this.getDetails().showPage(this.browserDisplay.getControl());
                this.browserDisplay.setInfo((LayerPointInfo)info);
            } else if (((LayerPointInfo)info).getRequestURL() != null && ((LayerPointInfo)info).getMimeType().startsWith("text/plain")) {
                this.getDetails().showPage(this.browserDisplay.getControl());
                this.browserDisplay.setInfo((LayerPointInfo)info);
            } else {
                this.getDetails().showPage((Control)this.information);
            }
        }
        if (selection instanceof CoveragePointInfo) {
            info = (CoveragePointInfo)selection;
            this.information.setText(((CoveragePointInfo)info).getInfo());
            this.getDetails().showPage((Control)this.information);
        }
    }

    public void createPartControl(Composite aParent) {
        super.createPartControl(aParent);
        ApplicationGIS.getToolManager().registerActionsWithPart((IWorkbenchPart)this);
        this.registry = new ImageRegistry(aParent.getDisplay());
    }

    protected void searchImplementation(Object filter, IProgressMonitor monitor, SearchPart.ResultSet set) {
        InfoRequest request = (InfoRequest)filter;
        if (monitor != null) {
            monitor.beginTask(Messages.InfoView2_information_request, request.layers.size());
        }
        this.addMapListener();
        this.layerList = new LinkedList<ILayer>();
        int work = 0;
        int i = request.layers.size() - 1;
        while (i > -1) {
            ILayer layer = request.layers.get(i);
            monitor.subTask(layer.getName());
            monitor.worked(++work);
            List currentLayerList = ApplicationGIS.getActiveMap().getMapLayers();
            if (currentLayerList.contains(layer) && layer.isVisible() && layer.getInteraction(Interaction.INFO)) {
                this.addLayerListener(layer);
                this.layerList.add(layer);
                if (layer.hasResource(FeatureSource.class)) {
                    try {
                        List<SimpleFeature> more = DataStoreDescribeLayer.info2(layer, request.bbox, monitor);
                        if (!more.isEmpty()) {
                            set.addAll(more);
                        }
                    }
                    catch (Throwable t) {
                        InfoPlugin.log("Information request " + layer.getName() + " failed " + t, t);
                    }
                } else if (layer.hasResource(GridCoverage.class)) {
                    try {
                        CoveragePointInfo hit = CoverageDescribeLayer.info2(layer, request.bbox, monitor);
                        if (hit != null) {
                            set.add((Object)hit);
                        }
                    }
                    catch (Throwable t) {
                        InfoPlugin.log("Information request " + layer.getName() + " failed " + t, t);
                    }
                } else if (layer.hasResource(Layer.class)) {
                    try {
                        LayerPointInfo hit;
                        Layer wmsLayer = (Layer)layer.getResource(Layer.class, (IProgressMonitor)new NullProgressMonitor());
                        if (wmsLayer.isQueryable() && (hit = WMSDescribeLayer.info2(layer, request.bbox)) != null) {
                            set.add((Object)hit);
                        }
                    }
                    catch (Throwable t) {
                        InfoPlugin.log("Information request " + layer.getName() + " failed " + t, t);
                        t.printStackTrace();
                    }
                }
            }
            --i;
        }
    }

    protected IBaseLabelProvider createLabelProvider() {
        return new InfoViewLabelProvider();
    }

    protected StructuredViewer createViewer(Composite parent) {
        TreeViewer viewer = new TreeViewer(parent);
        return viewer;
    }

    protected ISelection getSelection(List<Object> results) {
        for (Object object : results) {
            Object info;
            ILayer layer = null;
            if (object instanceof LayerPointInfo) {
                info = (LayerPointInfo)object;
                layer = ((LayerPointInfo)info).getLayer();
            }
            if (object instanceof CoveragePointInfo) {
                info = (CoveragePointInfo)object;
                layer = ((CoveragePointInfo)info).getLayer();
            }
            if (object instanceof AdaptableFeature) {
                AdaptableFeature feature = (AdaptableFeature)object;
                layer = (ILayer)feature.getAdapter(ILayer.class);
            }
            if (layer != ApplicationGIS.getActiveMap().getEditManager().getSelectedLayer()) continue;
            return new StructuredSelection(object);
        }
        if (results.isEmpty()) {
            return new StructuredSelection();
        }
        return new StructuredSelection(results.get(0));
    }

    protected IStructuredContentProvider createContentProvider() {
        return new ITreeContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof List) {
                    return ((List)inputElement).toArray();
                }
                return null;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public Object[] getChildren(Object parentElement) {
                return null;
            }

            public Object getParent(Object element) {
                return null;
            }

            public boolean hasChildren(Object element) {
                return false;
            }
        };
    }

    private void updatedMapLayersActions(MapCompositionEvent event) {
        MapCompositionEvent.EventType eventType = event.getType();
        block0 : switch (eventType) {
            case REMOVED: 
            case MANY_REMOVED: {
                List currentLayerList = ApplicationGIS.getActiveMap().getMapLayers();
                for (ILayer layer : this.layerList) {
                    if (currentLayerList.contains(layer)) continue;
                    this.removeItemsFromTree();
                    break block0;
                }
                break;
            }
        }
    }

    private void updateLayerActions(LayerEvent event) {
        LayerEvent.EventType eventType = event.getType();
        switch (eventType) {
            case EDIT_EVENT: {
                FeatureEvent featureEvent = (FeatureEvent)event.getNewValue();
                if (featureEvent.getType() != FeatureEvent.Type.REMOVED) break;
                this.removeFeatureFromTree();
                break;
            }
        }
    }

    private void removeFeatureFromTree() {
        Display.findDisplay((Thread)this.fatherThread).asyncExec(new Runnable(){

            @Override
            public void run() {
                Tree tree = ((TreeViewer)InfoView2.this.viewer).getTree();
                TreeItem[] treeItems = tree.getItems();
                TreeItem removedItem = null;
                int i = 0;
                while (i < treeItems.length) {
                    SimpleFeature feature;
                    Filter id;
                    TreeItem item = treeItems[i];
                    if (item.getData() instanceof SimpleFeature && !this.isFeatureOnStore(id = InfoView2.this.createFidFiler((feature = (SimpleFeature)item.getData()).getID()))) {
                        removedItem = treeItems[i];
                        break;
                    }
                    ++i;
                }
                if (removedItem != null) {
                    InfoView2.this.getDetails().showPage((Control)InfoView2.this.information);
                    tree.deselectAll();
                    tree.getItem(tree.indexOf(removedItem)).dispose();
                }
            }

            private boolean isFeatureOnStore(Filter id) {
                block7: {
                    FeatureCollection collection = null;
                    FeatureIterator iter = null;
                    try {
                        collection = ((FeatureSource)((ILayer)InfoView2.this.layerList.get(0)).getResource(FeatureSource.class, null)).getFeatures(id);
                        iter = collection.features();
                        if (iter.hasNext()) {
                            collection.close(iter);
                            return true;
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        break block7;
                    }
                    finally {
                        collection.close(iter);
                    }
                    collection.close(iter);
                }
                return false;
            }
        });
    }

    private Filter createFidFiler(String id) {
        FilterFactory filterFactory = CommonFactoryFinder.getFilterFactory((Hints)GeoTools.getDefaultHints());
        Id filterId = filterFactory.id(FeatureUtils.stringToId((FilterFactory)filterFactory, (String)id));
        return filterId;
    }

    private void removeItemsFromTree() {
        Display.findDisplay((Thread)this.fatherThread).asyncExec(new Runnable(){

            @Override
            public void run() {
                InfoView2.this.getDetails().showPage((Control)InfoView2.this.information);
                Tree tree = ((TreeViewer)InfoView2.this.viewer).getTree();
                if (tree != null && !tree.isDisposed()) {
                    tree.removeAll();
                }
            }
        });
    }

    private void addMapListener() {
        IMap map = ApplicationGIS.getActiveMap();
        map.addMapCompositionListener(this.mapListener);
    }

    private void addLayerListener(ILayer layer) {
        layer.addListener(this.layerListener);
    }

    public void dispose() {
        if (this.registry != null) {
            this.registry.dispose();
            this.registry = null;
        }
        super.dispose();
    }

    public static class InfoRequest {
        public ReferencedEnvelope bbox;
        public List<ILayer> layers;
    }

    private class InfoViewLabelProvider
    extends LabelProvider
    implements IColorProvider {
        private static final String FEATURE_LABEL = "FEATURE_LABEL";

        private InfoViewLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof AdaptableFeature) {
                AdaptableFeature feature = (AdaptableFeature)element;
                return this.getFeatureLabel(feature);
            }
            if (element instanceof LayerPointInfo) {
                LayerPointInfo info = (LayerPointInfo)element;
                return info.getLayer().getName();
            }
            if (element instanceof CoveragePointInfo) {
                CoveragePointInfo info = (CoveragePointInfo)element;
                return info.getLayer().getName();
            }
            return super.getText(element);
        }

        private String getFeatureLabel(AdaptableFeature feature) {
            ILayer layer = (ILayer)feature.getAdapter(ILayer.class);
            IGeoResource resource = layer.getGeoResource();
            return this.getFeatureLabel(resource, (SimpleFeature)feature);
        }

        private String getFeatureLabel(IGeoResource resource, SimpleFeature feature) {
            String labelExpression = (String)resource.getPersistentProperties().get(FEATURE_LABEL);
            if (labelExpression != null) {
                try {
                    Expression exp = ECQL.toExpression((String)labelExpression);
                    return (String)exp.evaluate((Object)feature);
                }
                catch (CQLException e) {
                    e.printStackTrace();
                }
            }
            return feature.getID();
        }

        public Color getBackground(Object element) {
            if (element instanceof AdaptableFeature) {
                AdaptableFeature feature = (AdaptableFeature)element;
                LayerImpl layer = (LayerImpl)feature.getAdapter(ILayer.class);
                IColorProvider colorProvider = (IColorProvider)layer.getAdapter(IColorProvider.class);
                if (colorProvider == null) {
                    return null;
                }
                return colorProvider.getBackground((Object)layer);
            }
            return null;
        }

        public Color getForeground(Object element) {
            if (element instanceof AdaptableFeature) {
                AdaptableFeature feature = (AdaptableFeature)element;
                LayerImpl layer = (LayerImpl)feature.getAdapter(ILayer.class);
                IColorProvider colorProvider = (IColorProvider)layer.getAdapter(IColorProvider.class);
                if (colorProvider == null) {
                    return null;
                }
                return colorProvider.getForeground((Object)layer);
            }
            return null;
        }

        public Image getImage(Object element) {
            String key;
            Image image;
            Object info;
            ILayer layer = null;
            if (element instanceof AdaptableFeature) {
                AdaptableFeature feature = (AdaptableFeature)element;
                layer = (ILayer)feature.getAdapter(ILayer.class);
            }
            if (element instanceof LayerPointInfo) {
                info = (LayerPointInfo)element;
                layer = ((LayerPointInfo)info).getLayer();
            }
            if (element instanceof CoveragePointInfo) {
                info = (CoveragePointInfo)element;
                layer = ((CoveragePointInfo)info).getLayer();
            }
            if ((image = InfoView2.this.registry.get(key = layer.getID().toExternalForm())) == null) {
                ImageDescriptor icon = (ImageDescriptor)layer.getProperties().get("generated icon");
                if (icon == null) {
                    icon = layer.getIcon();
                }
                if (icon == null) {
                    IGeoResource resource = layer.getGeoResource();
                    try {
                        icon = resource.getInfo(null).getImageDescriptor();
                    }
                    catch (IOException iOException) {}
                }
                if (icon != null) {
                    InfoView2.this.registry.put(key, icon);
                    image = InfoView2.this.registry.get(key);
                }
            }
            return image;
        }
    }
}

