/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tool.info.internal;

import com.vividsolutions.jts.geom.Coordinate;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.text.DecimalFormat;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.tool.info.CoveragePointInfo;
import org.eclipse.core.runtime.IProgressMonitor;
import org.geotools.coverage.grid.GridCoordinates2D;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.InvalidGridGeometryException;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.geometry.Envelope2D;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.parameter.Parameter;
import org.geotools.referencing.CRS;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class CoverageDescribeLayer {
    public static CoveragePointInfo info2(ILayer layer, ReferencedEnvelope bbox, IProgressMonitor monitor) throws IOException, InvalidGridGeometryException, TransformException {
        Coordinate envelopeCenterOrig = bbox.centre();
        CoordinateReferenceSystem sourceCRS = bbox.getCoordinateReferenceSystem();
        DecimalFormat formatter = new DecimalFormat("0.####");
        IGeoResource geoResource = layer.getGeoResource();
        GridCoverage2D coverage = null;
        GridGeometry2D gridGeometry = null;
        Coordinate evaluateCoord = null;
        boolean isOnGrid = false;
        boolean hasProblem = false;
        Point2D.Double p = null;
        if (geoResource.canResolve(AbstractGridCoverage2DReader.class)) {
            AbstractGridCoverage2DReader reader = (AbstractGridCoverage2DReader)geoResource.resolve(AbstractGridCoverage2DReader.class, monitor);
            GeneralEnvelope originalEnvelope = reader.getOriginalEnvelope();
            CoordinateReferenceSystem targetCrs = reader.getCrs();
            if (targetCrs != null) {
                evaluateCoord = CoverageDescribeLayer.transform(sourceCRS, targetCrs, envelopeCenterOrig);
            } else {
                evaluateCoord = envelopeCenterOrig;
                targetCrs = sourceCRS;
            }
            p = new Point2D.Double(evaluateCoord.x, evaluateCoord.y);
            if (originalEnvelope.contains((DirectPosition)new DirectPosition2D((Point2D)p))) {
                double delta = 1.0E-7;
                GeneralParameterValue[] parameterValues = CoverageDescribeLayer.createGridGeometryGeneralParameter(1, 1, evaluateCoord.y + delta, evaluateCoord.y - delta, evaluateCoord.x + delta, evaluateCoord.x - delta, targetCrs);
                coverage = reader.read(parameterValues);
                gridGeometry = new GridGeometry2D(reader.getOriginalGridRange(), (Envelope)reader.getOriginalEnvelope());
                isOnGrid = true;
            }
        } else if (geoResource.canResolve(GridCoverage.class)) {
            coverage = (GridCoverage2D)geoResource.resolve(GridCoverage.class, monitor);
            CoordinateReferenceSystem targetCrs = coverage.getCoordinateReferenceSystem();
            gridGeometry = coverage.getGridGeometry();
            evaluateCoord = CoverageDescribeLayer.transform(sourceCRS, targetCrs, envelopeCenterOrig);
            p = new Point2D.Double(evaluateCoord.x, evaluateCoord.y);
            Envelope2D envelope2d = coverage.getEnvelope2D();
            if (envelope2d.contains((Point2D)p)) {
                isOnGrid = true;
            }
        } else {
            hasProblem = true;
        }
        final StringBuilder sb = new StringBuilder();
        if (hasProblem) {
            sb.append("The coverage information could not be read.");
        } else if (isOnGrid) {
            int bands = coverage.getSampleDimensions().length;
            double[] evaluated = new double[bands];
            try {
                coverage.evaluate((Point2D)p, evaluated);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            GridCoordinates2D gridCoord = gridGeometry.worldToGrid((DirectPosition)new DirectPosition2D((Point2D)p));
            sb.append("Coverage info:\n\n");
            int length = evaluated.length;
            if (length > 1) {
                int i = 0;
                while (i < evaluated.length) {
                    sb.append("Band ").append(i);
                    sb.append(" = ").append(evaluated[i]).append("\n");
                    ++i;
                }
            } else if (length == 1) {
                sb.append("\tValue");
                sb.append(" = ").append(evaluated[0]).append("\n\n");
            }
            sb.append("\tin coordinates (easting, northing):\n");
            sb.append("\t").append(formatter.format(envelopeCenterOrig.x));
            sb.append(", ");
            sb.append(formatter.format(envelopeCenterOrig.y));
            sb.append("\n\n");
            sb.append("\tand grid coordinates (col, row):\n");
            sb.append("\t").append(gridCoord.x);
            sb.append(", ");
            sb.append(gridCoord.y);
            sb.append("\n");
        } else {
            sb.append("Selected point is outside of coverage region.");
        }
        CoveragePointInfo info = new CoveragePointInfo(layer){

            @Override
            public String getInfo() {
                return sb.toString();
            }
        };
        return info;
    }

    private static Coordinate transform(CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, Coordinate envelopeCenterOrig) throws TransformException {
        Coordinate evaluateCoord = envelopeCenterOrig;
        if (!CRS.equalsIgnoreMetadata((Object)sourceCRS, (Object)targetCRS)) {
            try {
                MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)targetCRS);
                evaluateCoord = JTS.transform((Coordinate)envelopeCenterOrig, null, (MathTransform)transform);
                return evaluateCoord;
            }
            catch (FactoryException factoryException) {
                return null;
            }
        }
        return evaluateCoord;
    }

    public static GeneralParameterValue[] createGridGeometryGeneralParameter(int width, int height, double north, double south, double east, double west, CoordinateReferenceSystem crs) {
        ReferencedEnvelope env;
        GeneralParameterValue[] readParams = new GeneralParameterValue[1];
        Parameter readGG = new Parameter((ParameterDescriptor)AbstractGridFormat.READ_GRIDGEOMETRY2D);
        GridEnvelope2D gridEnvelope = new GridEnvelope2D(0, 0, width, height);
        if (crs != null) {
            env = new ReferencedEnvelope(west, east, south, north, crs);
        } else {
            DirectPosition2D minDp = new DirectPosition2D(west, south);
            DirectPosition2D maxDp = new DirectPosition2D(east, north);
            env = new Envelope2D(minDp, maxDp);
        }
        readGG.setValue((Object)new GridGeometry2D((GridEnvelope)gridEnvelope, (Envelope)env));
        readParams[0] = readGG;
        return readParams;
    }
}

