/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tool.info;

import java.awt.Rectangle;
import java.awt.Shape;
import net.refractions.udig.project.command.Command;
import net.refractions.udig.project.ui.ApplicationGIS;
import net.refractions.udig.project.ui.commands.SelectionBoxCommand;
import net.refractions.udig.project.ui.render.displayAdapter.MapMouseEvent;
import net.refractions.udig.project.ui.tool.AbstractModalTool;
import net.refractions.udig.project.ui.tool.ModalTool;
import net.refractions.udig.tool.info.InfoPlugin;
import net.refractions.udig.tool.info.internal.InfoView2;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.geotools.geometry.jts.ReferencedEnvelope;

public class InfoTool
extends AbstractModalTool
implements ModalTool {
    public static final String ID = "net.refractions.udig.tool.info.infoMode";
    public static final String CATEGORY_ID = "net.refractions.udig.tool.category.info";
    SelectionBoxCommand draw = new SelectionBoxCommand();
    private Rectangle previous;

    public InfoTool() {
        super(3);
    }

    public void mousePressed(MapMouseEvent e) {
        this.draw.setValid(true);
        this.context.sendASyncCommand((Command)this.draw);
        this.feedback(e);
    }

    public void mouseDragged(MapMouseEvent e) {
        this.feedback(e);
    }

    public void feedback(MapMouseEvent e) {
        Rectangle square = new Rectangle(e.x - 3, e.y - 3, 5, 5);
        this.draw.setShape((Shape)square);
        if (this.previous != null) {
            this.context.getViewportPane().repaint(this.previous.x - 4, this.previous.y - 4, this.previous.width + 8, this.previous.height + 8);
        }
        this.previous = square;
        this.context.getViewportPane().repaint(square.x - 4, square.y - 4, square.width + 8, square.height + 8);
    }

    public void mouseReleased(MapMouseEvent e) {
        try {
            try {
                ReferencedEnvelope bbox = this.context.getBoundingBox(e.getPoint(), 5);
                final InfoView2.InfoRequest request = new InfoView2.InfoRequest();
                request.bbox = bbox;
                request.layers = this.context.getMapLayers();
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        IWorkbenchPage page;
                        InfoView2 infoView = (InfoView2)ApplicationGIS.getView((boolean)true, (String)"net.refractions.udig.tool.info.infoView");
                        if (infoView != null && infoView.getSite().getSelectionProvider() != null) {
                            infoView.getSite().getSelectionProvider().setSelection((ISelection)new StructuredSelection());
                        }
                        if (!(page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage()).isPartVisible((IWorkbenchPart)infoView)) {
                            page.bringToTop((IWorkbenchPart)infoView);
                        }
                        infoView = (InfoView2)ApplicationGIS.getView((boolean)false, (String)"net.refractions.udig.tool.info.infoView");
                        infoView.search(request);
                    }
                });
            }
            catch (Throwable e1) {
                InfoPlugin.log("Could not display information", e1);
                this.draw.setValid(false);
                this.context.getViewportPane().repaint();
            }
        }
        finally {
            this.draw.setValid(false);
            this.context.getViewportPane().repaint();
        }
    }

    public void dispose() {
        super.dispose();
    }
}

