/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.document.ui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.miginfocom.swt.MigLayout;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.catalog.document.IAttachmentSource;
import net.refractions.udig.catalog.document.IDocument;
import net.refractions.udig.catalog.document.IDocumentSource;
import net.refractions.udig.catalog.document.IHotlinkSource;
import net.refractions.udig.catalog.internal.shp.ShpGeoResourceImpl;
import net.refractions.udig.document.source.BasicHotlinkDescriptorParser;
import net.refractions.udig.document.source.ShpDocPropertyParser;
import net.refractions.udig.document.ui.DocUtils;
import net.refractions.udig.tool.info.InfoPlugin;
import net.refractions.udig.tool.info.internal.Messages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.IconAndMessageDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;
import org.geotools.data.simple.SimpleFeatureSource;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;

public class DocumentPropertyPage
extends PropertyPage
implements IWorkbenchPropertyPage {
    private static final IHotlinkSource.HotlinkDescriptor[] EMPTY = new IHotlinkSource.HotlinkDescriptor[0];
    private Button resourceDocumentsFlag;
    private Button featureDocumentsFlag;
    private Button featureHotlinksFlag;
    private TableViewer hotlinkViewer;
    private Button addHotlink;
    private Button editHotlink;
    private Button removeButton;
    private List<IHotlinkSource.HotlinkDescriptor> hotlinkList;
    private BasicHotlinkDescriptorParser hotlinkParser;
    private ShpDocPropertyParser propParser;
    public static final String ACTION_PARAM = "{0}";

    protected Control createContents(Composite parent) {
        Composite page = new Composite(parent, 16);
        page.setLayout((Layout)new MigLayout("insets 0, wrap 1, fill"));
        page.setLayoutData((Object)new GridData(1808));
        Group resourceGrp = new Group(page, 4);
        resourceGrp.setText(Messages.DocumentPropertyPage_resourceGrpTitle);
        resourceGrp.setLayoutData((Object)"w 100%!");
        resourceGrp.setLayout((Layout)new MigLayout());
        this.resourceDocumentsFlag = new Button((Composite)resourceGrp, 32);
        this.resourceDocumentsFlag.setText(Messages.DocumentPropertyPage_resourceEnable);
        this.resourceDocumentsFlag.setLayoutData((Object)"growx");
        Group featureGrp = new Group(page, 4);
        featureGrp.setText(Messages.DocumentPropertyPage_featureGrpTitle);
        featureGrp.setLayoutData((Object)"pushy, growy, w 100%!");
        featureGrp.setLayout((Layout)new MigLayout("wrap 2, insets 5", "[90%]5[10%]", ""));
        this.featureDocumentsFlag = new Button((Composite)featureGrp, 32);
        this.featureDocumentsFlag.setText(Messages.DocumentPropertyPage_featureEnable);
        this.featureDocumentsFlag.setLayoutData((Object)"span 2");
        this.featureHotlinksFlag = new Button((Composite)featureGrp, 32);
        this.featureHotlinksFlag.setText(Messages.DocumentPropertyPage_hotlinkEnable);
        this.featureHotlinksFlag.setLayoutData((Object)"span 2");
        this.featureHotlinksFlag.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean isEnabled = DocumentPropertyPage.this.featureHotlinksFlag.getSelection();
                DocumentPropertyPage.this.setTableAndButtonsEnablements(isEnabled);
                DocumentPropertyPage.this.hotlinkViewer.setInput(isEnabled ? DocumentPropertyPage.this.hotlinkList : EMPTY);
                DocumentPropertyPage.this.hotlinkViewer.refresh();
            }
        });
        this.createHotlinksTable((Composite)featureGrp);
        this.createHotlinksButtons((Composite)featureGrp);
        this.setPageInputAndEnablements();
        return page;
    }

    private void createHotlinksTable(Composite parent) {
        Composite tableComposite = new Composite(parent, 0);
        TableColumnLayout columnLayout = new TableColumnLayout();
        tableComposite.setLayout((Layout)columnLayout);
        tableComposite.setLayoutData((Object)"pushy, grow, wmax 85%");
        this.hotlinkViewer = new TableViewer(tableComposite, 68356);
        this.hotlinkViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        TableViewerColumn column = new TableViewerColumn(this.hotlinkViewer, 0);
        column.getColumn().setText("");
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return "";
            }

            public Image getImage(Object element) {
                IHotlinkSource.HotlinkDescriptor descriptor = (IHotlinkSource.HotlinkDescriptor)element;
                switch (descriptor.getType()) {
                    case FILE: {
                        return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
                    }
                    case WEB: {
                        return InfoPlugin.getDefault().getImageRegistry().get("icons/obj16/link_doc_obj.png");
                    }
                    case ACTION: {
                        return InfoPlugin.getDefault().getImageRegistry().get("icons/obj16/action_doc_obj.png");
                    }
                }
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ELEMENTS");
            }
        });
        columnLayout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnWeightData(8, 0, false));
        column = new TableViewerColumn(this.hotlinkViewer, 0);
        column.getColumn().setText(Messages.Document_Label_Column);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                IHotlinkSource.HotlinkDescriptor descriptor = (IHotlinkSource.HotlinkDescriptor)element;
                return descriptor.getLabel();
            }
        });
        columnLayout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnWeightData(25, 0, true));
        column = new TableViewerColumn(this.hotlinkViewer, 0);
        column.getColumn().setText(Messages.Document_Attribute_Column);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                IHotlinkSource.HotlinkDescriptor descriptor = (IHotlinkSource.HotlinkDescriptor)element;
                return descriptor.getAttributeName();
            }
        });
        columnLayout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnWeightData(25, 0, true));
        column = new TableViewerColumn(this.hotlinkViewer, 0);
        column.getColumn().setText(Messages.Document_Hotlink_Column);
        column.getColumn().setAlignment(0x1000000);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                IHotlinkSource.HotlinkDescriptor descriptor = (IHotlinkSource.HotlinkDescriptor)element;
                return DocUtils.toCamelCase(descriptor.getType().toString());
            }
        });
        columnLayout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnWeightData(15, 0, true));
        column = new TableViewerColumn(this.hotlinkViewer, 0);
        column.getColumn().setText(Messages.Document_Action_Column);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                IHotlinkSource.HotlinkDescriptor descriptor = (IHotlinkSource.HotlinkDescriptor)element;
                if (descriptor.getConfig() == null) {
                    return Messages.DocumentPropertyPage_Open;
                }
                return descriptor.getConfig();
            }
        });
        columnLayout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnWeightData(30, 0, true));
        this.hotlinkViewer.getTable().setHeaderVisible(true);
        this.hotlinkViewer.getTable().setLinesVisible(true);
        this.hotlinkViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection sel = event.getSelection();
                DocumentPropertyPage.this.editHotlink.setEnabled(!sel.isEmpty());
                DocumentPropertyPage.this.removeButton.setEnabled(!sel.isEmpty());
            }
        });
        this.hotlinkViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                StructuredSelection selection = (StructuredSelection)DocumentPropertyPage.this.hotlinkViewer.getSelection();
                IHotlinkSource.HotlinkDescriptor descriptor = (IHotlinkSource.HotlinkDescriptor)selection.getFirstElement();
                DocumentPropertyPage.this.editDescriptor(descriptor);
            }
        });
    }

    private void createHotlinksButtons(Composite parent) {
        Composite buttonComposite = new Composite(parent, 0);
        buttonComposite.setLayout((Layout)new MigLayout("fillx, insets 0, wrap 1", "[fill]", "[][]push[]"));
        buttonComposite.setLayoutData((Object)"grow");
        this.addHotlink = new Button(buttonComposite, 0x1000000);
        this.addHotlink.setText(Messages.Document_Add);
        this.addHotlink.setLayoutData((Object)"grow");
        this.addHotlink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ISelection sel = DocumentPropertyPage.this.hotlinkViewer.getSelection();
                if (!sel.isEmpty() && sel instanceof StructuredSelection) {
                    StructuredSelection selection = (StructuredSelection)sel;
                    IHotlinkSource.HotlinkDescriptor descriptor = (IHotlinkSource.HotlinkDescriptor)selection.getFirstElement();
                    int index = DocumentPropertyPage.this.hotlinkList.indexOf(descriptor);
                    DocumentPropertyPage.this.addDescriptor(index);
                } else {
                    DocumentPropertyPage.this.addDescriptor(-1);
                }
            }
        });
        this.editHotlink = new Button(buttonComposite, 0x1000000);
        this.editHotlink.setText(Messages.Document_Edit);
        this.editHotlink.setLayoutData((Object)"");
        this.editHotlink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ISelection sel = DocumentPropertyPage.this.hotlinkViewer.getSelection();
                if (!sel.isEmpty() && sel instanceof StructuredSelection) {
                    StructuredSelection selection = (StructuredSelection)sel;
                    IHotlinkSource.HotlinkDescriptor descriptor = (IHotlinkSource.HotlinkDescriptor)selection.getFirstElement();
                    DocumentPropertyPage.this.editDescriptor(descriptor);
                }
            }
        });
        this.removeButton = new Button(buttonComposite, 0x1000000);
        this.removeButton.setText(Messages.Document_Remove);
        this.removeButton.setLayoutData((Object)"");
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ISelection sel = DocumentPropertyPage.this.hotlinkViewer.getSelection();
                if (!sel.isEmpty() && sel instanceof StructuredSelection) {
                    StructuredSelection selection = (StructuredSelection)sel;
                    IHotlinkSource.HotlinkDescriptor descriptor = (IHotlinkSource.HotlinkDescriptor)selection.getFirstElement();
                    DocumentPropertyPage.this.removeDescriptor(descriptor);
                }
            }
        });
    }

    private void setPageInputAndEnablements() {
        NullProgressMonitor monitor = new NullProgressMonitor();
        IGeoResource resource = (IGeoResource)this.getElement().getAdapter(IGeoResource.class);
        this.setShpPropertyParser(resource);
        this.setResourcePropsEnablements(resource, (IProgressMonitor)monitor);
        this.setFeaturePropsEnablements(resource, (IProgressMonitor)monitor);
        this.setHotlinkDescriptorParser(resource);
        this.setHotlinkPropsEnablements(resource, (IProgressMonitor)monitor);
    }

    private void setShpPropertyParser(IGeoResource resource) {
        if (resource.canResolve(ShpGeoResourceImpl.class)) {
            this.propParser = new ShpDocPropertyParser(resource.getIdentifier());
        }
    }

    private void setResourcePropsEnablements(IGeoResource resource, IProgressMonitor monitor) {
        this.resourceDocumentsFlag.setSelection(false);
        this.resourceDocumentsFlag.setEnabled(false);
        if (resource.canResolve(IDocumentSource.class)) {
            try {
                IDocumentSource source = (IDocumentSource)resource.resolve(IDocumentSource.class, monitor);
                this.resourceDocumentsFlag.setSelection(source.isEnabled());
                this.resourceDocumentsFlag.setEnabled(source.isEnabledEditable());
            }
            catch (IOException iOException) {}
        }
    }

    private void setFeaturePropsEnablements(IGeoResource resource, IProgressMonitor monitor) {
        this.featureDocumentsFlag.setSelection(false);
        this.featureDocumentsFlag.setEnabled(false);
        if (resource.canResolve(IAttachmentSource.class)) {
            try {
                IAttachmentSource source = (IAttachmentSource)resource.resolve(IAttachmentSource.class, monitor);
                this.featureDocumentsFlag.setSelection(source.isEnabled());
                this.featureDocumentsFlag.setEnabled(source.isEnabledEditable());
            }
            catch (IOException iOException) {}
        }
    }

    private void setHotlinkDescriptorParser(IGeoResource resource) {
        if (resource.canResolve(IHotlinkSource.class)) {
            this.hotlinkParser = new BasicHotlinkDescriptorParser(resource);
        }
    }

    private void setHotlinkPropsEnablements(IGeoResource resource, IProgressMonitor monitor) {
        this.featureHotlinksFlag.setSelection(false);
        this.featureHotlinksFlag.setEnabled(false);
        this.setTableAndButtonsEnablements(false);
        if (resource.canResolve(IHotlinkSource.class)) {
            try {
                IHotlinkSource source = (IHotlinkSource)resource.resolve(IHotlinkSource.class, monitor);
                boolean isEnabled = source.isEnabled();
                boolean isEditable = source.isEnabledEditable();
                this.featureHotlinksFlag.setSelection(isEnabled);
                this.featureHotlinksFlag.setEnabled(isEditable);
                this.setTableAndButtonsEnablements(isEnabled && isEditable);
                if (isEditable) {
                    this.hotlinkList = new ArrayList<IHotlinkSource.HotlinkDescriptor>();
                    this.hotlinkList.addAll(this.hotlinkParser.getDescriptors());
                    this.hotlinkViewer.setInput(this.hotlinkList);
                }
            }
            catch (IOException iOException) {}
        }
    }

    private void setTableAndButtonsEnablements(boolean isEnabled) {
        this.hotlinkViewer.getControl().setEnabled(isEnabled);
        boolean hasSelection = isEnabled && !this.hotlinkViewer.getSelection().isEmpty();
        this.addHotlink.setEnabled(isEnabled);
        this.editHotlink.setEnabled(hasSelection);
        this.removeButton.setEnabled(hasSelection);
    }

    public boolean performOk() {
        this.savePersistentProperties();
        this.savePropertiesFile();
        return super.performOk();
    }

    protected void performDefaults() {
        if (this.resourceDocumentsFlag.isEnabled()) {
            this.resourceDocumentsFlag.setSelection(this.propParser.getShapefileFlag());
        }
        if (this.featureDocumentsFlag.isEnabled()) {
            this.featureDocumentsFlag.setSelection(this.propParser.getFeatureDocsFlag());
        }
        if (this.featureHotlinksFlag.isEnabled()) {
            this.featureHotlinksFlag.setSelection(this.hotlinkParser.isEnabled());
            this.hotlinkList.clear();
            this.hotlinkList.addAll(this.hotlinkParser.getDescriptors());
            this.hotlinkViewer.refresh();
        }
        super.performDefaults();
    }

    private void savePersistentProperties() {
        boolean isEditAllowed = this.featureHotlinksFlag.isEnabled();
        if (isEditAllowed && this.hotlinkParser != null) {
            boolean isHotlinksEnabled = this.featureHotlinksFlag.getSelection();
            this.hotlinkParser.setEnabled(isHotlinksEnabled);
            if (isHotlinksEnabled) {
                if (this.hotlinkViewer.getInput() == EMPTY) {
                    this.hotlinkParser.setDescriptors(new ArrayList<IHotlinkSource.HotlinkDescriptor>());
                } else {
                    this.hotlinkParser.setDescriptors(this.hotlinkList);
                }
            } else {
                this.hotlinkParser.clearDescriptors();
            }
        }
    }

    private void savePropertiesFile() {
        boolean isResourceEditAllowed = this.resourceDocumentsFlag.isEnabled();
        boolean isFeatureEditAllowed = this.featureDocumentsFlag.isEnabled();
        if ((isResourceEditAllowed || isFeatureEditAllowed) && this.propParser != null) {
            if (!this.propParser.hasProperties()) {
                this.propParser.createPropertiesFile();
            }
            if (isResourceEditAllowed) {
                this.propParser.setShapefileFlag(this.resourceDocumentsFlag.getSelection());
            }
            if (isFeatureEditAllowed) {
                this.propParser.setFeatureDocsFlag(this.featureDocumentsFlag.getSelection());
            }
            this.propParser.writeProperties();
        }
    }

    public boolean performCancel() {
        return super.performCancel();
    }

    protected void removeDescriptor(IHotlinkSource.HotlinkDescriptor descriptor) {
        this.hotlinkList.remove(descriptor);
        this.hotlinkViewer.refresh();
    }

    protected void editDescriptor(IHotlinkSource.HotlinkDescriptor descriptor) {
        final int index = this.hotlinkViewer.getTable().getSelectionIndex();
        Shell shell = this.getShell();
        IHotlinkSource.HotlinkDescriptor copy = new IHotlinkSource.HotlinkDescriptor(descriptor);
        final HotlinkDescriptorDialog prompt = new HotlinkDescriptorDialog(shell, copy);
        prompt.openInJob(new Runnable(){

            @Override
            public void run() {
                IHotlinkSource.HotlinkDescriptor edited = prompt.getDescriptor();
                if (edited != null && !edited.isEmpty()) {
                    DocumentPropertyPage.this.hotlinkList.set(index, edited);
                    DocumentPropertyPage.this.hotlinkViewer.refresh();
                    DocumentPropertyPage.this.hotlinkViewer.setSelection((ISelection)new StructuredSelection((Object)edited));
                }
            }
        });
    }

    protected void addDescriptor(final int index) {
        Shell shell = this.getShell();
        final HotlinkDescriptorDialog prompt = new HotlinkDescriptorDialog(shell);
        prompt.openInJob(new Runnable(){

            @Override
            public void run() {
                IHotlinkSource.HotlinkDescriptor created = prompt.getDescriptor();
                if (created != null && !created.isEmpty()) {
                    if (index == -1) {
                        DocumentPropertyPage.this.hotlinkList.add(created);
                    } else {
                        int insert = index + 0;
                        if (insert < DocumentPropertyPage.this.hotlinkList.size()) {
                            DocumentPropertyPage.this.hotlinkList.add(insert, created);
                        } else {
                            DocumentPropertyPage.this.hotlinkList.add(created);
                        }
                    }
                    DocumentPropertyPage.this.hotlinkViewer.refresh();
                    DocumentPropertyPage.this.hotlinkViewer.setSelection((ISelection)new StructuredSelection((Object)created));
                }
            }
        });
    }

    class HotlinkDescriptorDialog
    extends IconAndMessageDialog {
        IHotlinkSource.HotlinkDescriptor descriptor;
        private SimpleFeatureType schema;
        private ComboViewer attributeViewer;
        private ComboViewer typeViewer;
        private Text actionText;
        private Label actionLabel;
        private Text labelText;
        private Text descriptionText;
        private StructuredSelection typeSelection;
        private boolean isAddMode;

        protected HotlinkDescriptorDialog(Shell parentShell) {
            super(parentShell);
            this.isAddMode = true;
            this.isAddMode = true;
            this.descriptor = new IHotlinkSource.HotlinkDescriptor();
        }

        protected HotlinkDescriptorDialog(Shell parentShell, IHotlinkSource.HotlinkDescriptor descriptor) {
            super(parentShell);
            this.isAddMode = true;
            this.isAddMode = false;
            this.descriptor = descriptor;
        }

        protected boolean isResizable() {
            return true;
        }

        protected Image getImage() {
            return this.getInfoImage();
        }

        public void setSchema(SimpleFeatureType schema) {
            this.schema = schema;
        }

        public IHotlinkSource.HotlinkDescriptor getDescriptor() {
            return this.descriptor;
        }

        public void openInJob(final Runnable okayRunnable) {
            Job job = new Job("Prompt Hotlink Descriptor"){

                protected IStatus run(IProgressMonitor monitor) {
                    IGeoResource resource = (IGeoResource)DocumentPropertyPage.this.getElement().getAdapter(IGeoResource.class);
                    SimpleFeatureType schema = null;
                    if (resource.canResolve(SimpleFeatureType.class)) {
                        try {
                            schema = (SimpleFeatureType)resource.resolve(SimpleFeatureType.class, monitor);
                        }
                        catch (IOException iOException) {}
                    }
                    if (resource.canResolve(SimpleFeatureSource.class)) {
                        try {
                            SimpleFeatureSource featureSource = (SimpleFeatureSource)resource.resolve(SimpleFeatureSource.class, monitor);
                            schema = featureSource != null ? (SimpleFeatureType)featureSource.getSchema() : null;
                        }
                        catch (IOException iOException) {}
                    }
                    HotlinkDescriptorDialog.this.setSchema(schema);
                    Display display = DocumentPropertyPage.this.getControl().getDisplay();
                    display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            HotlinkDescriptorDialog.this.setBlockOnOpen(true);
                            int code = HotlinkDescriptorDialog.this.open();
                            if (code == 0 && okayRunnable != null) {
                                okayRunnable.run();
                            }
                        }
                    });
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        }

        List<String> getSchemaCandidates() {
            ArrayList<String> list = new ArrayList<String>();
            if (this.schema != null) {
                for (AttributeDescriptor attribute : this.schema.getAttributeDescriptors()) {
                    if (!String.class.isAssignableFrom(attribute.getType().getBinding())) continue;
                    list.add(attribute.getLocalName());
                }
            }
            return list;
        }

        protected void configureShell(Shell shell) {
            shell.setText(Messages.DocumentPropertyPage_title);
            shell.setImage(this.getQuestionImage());
            this.resizeDialog(shell);
            super.configureShell(shell);
        }

        protected void resizeDialog(Shell shell) {
            Display display = PlatformUI.getWorkbench().getDisplay();
            Point size = new Shell(display).computeSize(-1, -1);
            Rectangle screen = display.getMonitors()[0].getBounds();
            int xPos = (screen.width - size.x) / 2 - 230;
            int yPos = (screen.height - size.y) / 2 - 190;
            shell.setBounds(xPos, yPos, 460, 380);
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = new Composite(parent, 0);
            MigLayout layout = new MigLayout("insets 0, wrap 2, fillx", "[20%, right]8[80%]", "[]15[][][]");
            composite.setLayout((Layout)layout);
            composite.setLayoutData((Object)new GridData(1808));
            String header = Messages.DocumentPropertyPage_editHotlinkHeader;
            if (this.isAddMode) {
                header = Messages.DocumentPropertyPage_addHotlinkHeader;
            }
            this.message = header;
            this.getShell().setText(header);
            this.createMessageArea(composite);
            this.imageLabel.setLayoutData((Object)"cell 0 0, alignx right");
            this.messageLabel.setLayoutData((Object)"cell 1 0 2 1, aligny center");
            FontData[] fontData = this.messageLabel.getFont().getFontData();
            int i = 0;
            while (i < fontData.length) {
                fontData[i].setHeight(14);
                ++i;
            }
            this.messageLabel.setFont(new Font(null, fontData));
            Label labelLbl = new Label(composite, 0);
            labelLbl.setText(Messages.DocumentPropertyPage_Label);
            labelLbl.setLayoutData((Object)"");
            this.labelText = new Text(composite, 2052);
            this.labelText.setLayoutData((Object)"growx");
            this.labelText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    HotlinkDescriptorDialog.this.refreshButtons();
                }
            });
            Label descriptionLbl = new Label(composite, 0);
            descriptionLbl.setText(Messages.DocumentPropertyPage_description);
            descriptionLbl.setLayoutData((Object)"");
            this.descriptionText = new Text(composite, 2626);
            this.descriptionText.setLayoutData((Object)"growx, h 60!");
            this.descriptionText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    HotlinkDescriptorDialog.this.refreshButtons();
                }
            });
            Label label = new Label(composite, 4);
            label.setText(Messages.DocumentPropertyPage_Attribute);
            label.setLayoutData((Object)"");
            this.attributeViewer = new ComboViewer(composite);
            this.attributeViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
            this.attributeViewer.getControl().setLayoutData((Object)"");
            List<String> attributeNames = this.getSchemaCandidates();
            this.attributeViewer.setInput(attributeNames);
            this.attributeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    StructuredSelection selection = (StructuredSelection)event.getSelection();
                    boolean hasAttribute = !selection.isEmpty();
                    Button okBtn = HotlinkDescriptorDialog.this.getButton(0);
                    if (okBtn != null) {
                        okBtn.setEnabled(hasAttribute);
                    }
                    if (HotlinkDescriptorDialog.this.labelText.getText().isEmpty()) {
                        HotlinkDescriptorDialog.this.labelText.setText(HotlinkDescriptorDialog.this.getLabelFromAttribute());
                    }
                    HotlinkDescriptorDialog.this.refreshButtons();
                }
            });
            label = new Label(composite, 4);
            label.setText(Messages.DocumentPropertyPage_Hotlink);
            label.setLayoutData((Object)"");
            this.typeViewer = new ComboViewer(composite, 12);
            this.typeViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
            this.typeViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

                public String getText(Object element) {
                    if (element instanceof IDocument.ContentType) {
                        IDocument.ContentType type = (IDocument.ContentType)element;
                        return DocUtils.toCamelCase(type.name());
                    }
                    return super.getText(element);
                }
            });
            this.typeViewer.setInput((Object)IDocument.ContentType.values());
            this.typeViewer.getControl().setLayoutData((Object)"");
            this.typeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    ISelection selection = event.getSelection();
                    if (!selection.isEmpty() && selection instanceof StructuredSelection) {
                        IDocument.ContentType currentType;
                        StructuredSelection strucSelection = (StructuredSelection)selection;
                        IDocument.ContentType type = (IDocument.ContentType)strucSelection.getFirstElement();
                        if (HotlinkDescriptorDialog.this.typeSelection != null && !HotlinkDescriptorDialog.this.typeSelection.isEmpty() && (currentType = (IDocument.ContentType)HotlinkDescriptorDialog.this.typeSelection.getFirstElement()) == type) {
                            return;
                        }
                        HotlinkDescriptorDialog.this.setActionText(type, HotlinkDescriptorDialog.this.descriptor.getConfig());
                        HotlinkDescriptorDialog.this.actionText.setFocus();
                        HotlinkDescriptorDialog.this.typeSelection = strucSelection;
                        HotlinkDescriptorDialog.this.refreshButtons();
                    }
                }
            });
            this.actionLabel = new Label(composite, 4);
            this.actionLabel.setText(Messages.DocumentPropertyPage_Action);
            this.actionLabel.setLayoutData((Object)"");
            this.actionText = new Text(composite, 2626);
            this.actionText.setLayoutData((Object)"growx, h 60!");
            this.actionText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    HotlinkDescriptorDialog.this.refreshButtons();
                }
            });
            HotlinkDescriptorDialog.applyDialogFont((Control)composite);
            return composite;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            super.createButtonsForButtonBar(parent);
            this.refreshButtons();
        }

        private void refreshButtons() {
            this.getButton(0).setEnabled(this.isValidForm());
        }

        protected Control createContents(Composite parent) {
            Control control = super.createContents(parent);
            if (this.descriptor.isEmpty()) {
                IDocument.ContentType defaultType = IDocument.ContentType.FILE;
                this.typeViewer.setSelection((ISelection)new StructuredSelection((Object)defaultType), true);
                this.setActionText(defaultType, null);
            } else {
                String attributeName;
                List<String> attributeNames;
                String descriptionStr;
                String labelStr = this.descriptor.getLabel();
                if (labelStr != null) {
                    this.labelText.setText(labelStr);
                }
                if ((descriptionStr = this.descriptor.getDescription()) != null) {
                    this.descriptionText.setText(descriptionStr);
                }
                if ((attributeNames = this.getSchemaCandidates()).contains(attributeName = this.descriptor.getAttributeName())) {
                    this.attributeViewer.setSelection((ISelection)new StructuredSelection((Object)attributeName));
                }
                this.typeViewer.setSelection((ISelection)new StructuredSelection((Object)this.descriptor.getType()), true);
                this.setActionText(this.descriptor.getType(), this.descriptor.getConfig());
            }
            this.labelText.setFocus();
            return control;
        }

        protected void okPressed() {
            if (this.isValidHotlink()) {
                String attributeName = this.attributeViewer.getCombo().getText();
                String label = this.labelText.getText();
                if (label == null || label.isEmpty()) {
                    label = this.getLabelFromAttribute();
                }
                String description = this.descriptionText.getText();
                StructuredSelection selection = (StructuredSelection)this.typeViewer.getSelection();
                IDocument.ContentType type = (IDocument.ContentType)selection.getFirstElement();
                String actionConfig = this.actionText.getText();
                this.descriptor = new IHotlinkSource.HotlinkDescriptor(label, description, attributeName, type, actionConfig);
                super.okPressed();
            }
        }

        private boolean isValidForm() {
            String label = this.labelText.getText().trim();
            if (label == null || label.length() == 0) {
                return false;
            }
            ISelection attribute = this.attributeViewer.getSelection();
            if (attribute.isEmpty()) {
                return false;
            }
            ISelection type = this.typeViewer.getSelection();
            if (type.isEmpty()) {
                return false;
            }
            String action = this.actionText.getText().trim();
            return action != null && action.length() != 0;
        }

        private boolean isValidHotlink() {
            if (!this.isValidForm()) {
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.DocumentPropertyPage_title, (String)Messages.DocumentPropertyPage_errRequired);
                return false;
            }
            StructuredSelection selection = (StructuredSelection)this.typeViewer.getSelection();
            IDocument.ContentType type = (IDocument.ContentType)selection.getFirstElement();
            String attributeName = this.attributeViewer.getCombo().getText();
            for (IHotlinkSource.HotlinkDescriptor hotlink : DocumentPropertyPage.this.hotlinkList) {
                if (!this.descriptor.isEmpty() && hotlink.toString().equals(this.descriptor.toString()) || !attributeName.equals(hotlink.getAttributeName())) continue;
                IDocument.ContentType currentType = hotlink.getType();
                if (IDocument.ContentType.ACTION == currentType && IDocument.ContentType.ACTION == type) {
                    return true;
                }
                this.attributeViewer.getControl().setFocus();
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.DocumentPropertyPage_title, (String)Messages.DocumentPropertyPage_errExists);
                return false;
            }
            return true;
        }

        protected void cancelPressed() {
            this.descriptor = null;
            super.cancelPressed();
        }

        private void setActionText(IDocument.ContentType type, String config) {
            switch (type) {
                case ACTION: {
                    this.actionText.setEditable(true);
                    this.actionText.setText(config == null ? "" : config);
                    break;
                }
                default: {
                    this.actionText.setEditable(false);
                    this.actionText.setText(Messages.DocumentPropertyPage_Open);
                }
            }
        }

        private String getLabelFromAttribute() {
            boolean hasAttribute;
            StructuredSelection selection = (StructuredSelection)this.attributeViewer.getSelection();
            boolean bl = hasAttribute = !selection.isEmpty();
            if (hasAttribute) {
                String attribute = (String)selection.getFirstElement();
                return DocUtils.toCamelCase(attribute);
            }
            return "";
        }
    }
}

