/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.document.ui;

import java.io.File;
import net.refractions.udig.catalog.document.IDocument;
import net.refractions.udig.document.ui.DocUtils;
import net.refractions.udig.tool.info.InfoPlugin;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.program.Program;
import org.eclipse.ui.PlatformUI;

public class DocumentImageProvider
extends CompositeImageDescriptor {
    private ImageData activeImgData = null;
    private ImageData topOverlayImgData = null;
    private ImageData bottomOverlayImgData = null;
    private Point size = new Point(20, 16);
    private static final int DEFAULT_WIDTH = 20;
    private static final int DEFAULT_HEIGHT = 16;

    protected void drawCompositeImage(int width, int height) {
        int xPos;
        this.drawImage(this.activeImgData, 0, 0);
        if (this.topOverlayImgData != null) {
            xPos = this.getSize().x - this.topOverlayImgData.width;
            this.drawImage(this.topOverlayImgData, xPos, 0);
        }
        if (this.bottomOverlayImgData != null) {
            xPos = this.getSize().x - this.bottomOverlayImgData.width + 1;
            int yPos = this.getSize().y - this.bottomOverlayImgData.height + 1;
            this.drawImage(this.bottomOverlayImgData, xPos, yPos);
        }
    }

    protected Point getSize() {
        return this.size;
    }

    private ImageData getFileImageData(File file) {
        Program program;
        String extension;
        if (file != null && (extension = DocUtils.getExtension(file)) != null && (program = Program.findProgram((String)extension)) != null) {
            return program.getImageData();
        }
        return null;
    }

    private ImageData getDefaultImageData(IDocument.ContentType contentType) {
        ImageDescriptor descriptor = null;
        switch (contentType) {
            case FILE: {
                descriptor = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FILE");
                break;
            }
            case WEB: {
                descriptor = InfoPlugin.getDefault().getImageRegistry().getDescriptor("icons/obj16/link_doc_obj.png");
                break;
            }
            case ACTION: {
                descriptor = InfoPlugin.getDefault().getImageRegistry().getDescriptor("icons/obj16/action_doc_obj.png");
                break;
            }
            default: {
                descriptor = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_ELEMENTS");
            }
        }
        if (descriptor != null) {
            return descriptor.getImageData();
        }
        return null;
    }

    private ImageData getAttachmentOverlay() {
        return InfoPlugin.getDefault().getImageRegistry().getDescriptor("icons/ovr16/attach_ovr.png").getImageData();
    }

    private ImageData getHotlinkOverlay() {
        return InfoPlugin.getDefault().getImageRegistry().getDescriptor("icons/ovr16/hotlink_ovr.png").getImageData();
    }

    private ImageData getTemplateOverlay() {
        return InfoPlugin.getDefault().getImageRegistry().getDescriptor("icons/ovr16/template_ovr.png").getImageData();
    }

    private Image createDocumentImage(IDocument.Type type, IDocument.ContentType contentType, File file, boolean isTemplate) {
        this.activeImgData = null;
        if (IDocument.ContentType.FILE == contentType) {
            this.activeImgData = this.getFileImageData(file);
        }
        if (this.activeImgData == null) {
            this.activeImgData = this.getDefaultImageData(contentType);
        }
        this.topOverlayImgData = null;
        if (IDocument.Type.ATTACHMENT == type) {
            this.topOverlayImgData = this.getAttachmentOverlay();
        }
        if (IDocument.Type.HOTLINK == type) {
            this.topOverlayImgData = this.getHotlinkOverlay();
        }
        this.bottomOverlayImgData = null;
        if (isTemplate) {
            this.bottomOverlayImgData = this.getTemplateOverlay();
        }
        return this.createImage();
    }

    public Image createDocumentImage(IDocument doc) {
        IDocument.Type type = doc.getType();
        IDocument.ContentType contentType = doc.getContentType();
        File file = null;
        if (IDocument.ContentType.FILE == contentType) {
            file = (File)doc.getContent();
        }
        return this.createDocumentImage(type, contentType, file, doc.isTemplate());
    }

    public Image createFolderImage() {
        this.activeImgData = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FOLDER").getImageData();
        this.topOverlayImgData = null;
        this.bottomOverlayImgData = null;
        return this.createImage();
    }

    public Image createDefaultImage() {
        this.activeImgData = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_ELEMENTS").getImageData();
        this.topOverlayImgData = null;
        this.bottomOverlayImgData = null;
        return this.createImage();
    }
}

