/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.document.ui;

import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import net.refractions.udig.catalog.document.IDocument;

public final class DocUtils {
    private static final String UNASSIGNED = "Unassigned";
    private static final String DOCUMENT_FORMAT = "%s (%s)";
    private static final String LABEL_DESC_FORMAT = "%s - %s";
    private static final String NEW_FILE_FORMAT = "New File.%s";
    private static final String SAVE_AS_FORMAT = "%s-Copy.%s";
    private static final String FILENAME_FORMAT = "%s.%s";
    private static final String F_NAME = "F_NAME";
    private static final String F_EXT = "F_EXT";

    public static String getDocStr(IDocument doc) {
        String docInfoStr = doc.getContentName();
        if (docInfoStr == null || docInfoStr.isEmpty()) {
            docInfoStr = UNASSIGNED;
        }
        return DocUtils.getDocStr(docInfoStr, doc.getLabel());
    }

    public static String getDocStr(IDocument.ContentType type, String info, String label) {
        String docInfoStr = DocUtils.getDocInfoStr(type, info);
        return DocUtils.getDocStr(docInfoStr, label);
    }

    private static String getDocStr(String docInfoStr, String label) {
        if (label == null || label.length() == 0) {
            return docInfoStr;
        }
        return String.format(DOCUMENT_FORMAT, docInfoStr, label);
    }

    private static String getDocInfoStr(IDocument.ContentType type, String infoStr) {
        String infoDisplayValue = UNASSIGNED;
        if (infoStr != null) {
            switch (type) {
                case FILE: {
                    infoDisplayValue = DocUtils.getFileDocInfoStr(infoStr);
                    break;
                }
                case WEB: {
                    infoDisplayValue = DocUtils.getWebDocInfoStr(infoStr);
                    break;
                }
                case ACTION: {
                    infoDisplayValue = infoStr;
                    break;
                }
            }
        }
        return infoDisplayValue;
    }

    private static String getDocInfoStr(IDocument.ContentType type, Object infoValue) {
        String infoDisplayValue = UNASSIGNED;
        if (infoValue != null) {
            switch (type) {
                case FILE: {
                    infoDisplayValue = DocUtils.getFileDocInfoStr((File)infoValue);
                    break;
                }
                case WEB: {
                    infoDisplayValue = DocUtils.getWebDocInfoStr((URL)infoValue);
                    break;
                }
                case ACTION: {
                    infoDisplayValue = infoValue.toString();
                    break;
                }
            }
        }
        return infoDisplayValue;
    }

    private static String getWebDocInfoStr(String urlPath) {
        return urlPath;
    }

    private static String getWebDocInfoStr(URL url) {
        return url.toString();
    }

    private static String getFileDocInfoStr(String filePath) {
        File file = new File(filePath);
        if (file.exists()) {
            return DocUtils.getFileDocInfoStr(file);
        }
        return null;
    }

    private static String getFileDocInfoStr(File file) {
        return file.getName();
    }

    public static String toCamelCase(String text) {
        String[] words;
        int count = 0;
        StringBuilder sb = new StringBuilder();
        String[] stringArray = words = text.replace('_', ' ').split(" ");
        int n = words.length;
        int n2 = 0;
        while (n2 < n) {
            String word = stringArray[n2];
            ++count;
            if (word.length() == 1) {
                sb.append(word.toUpperCase());
            } else if (word.length() > 1) {
                sb.append(String.valueOf(word.substring(0, 1).toUpperCase()) + word.substring(1).toLowerCase());
            }
            if (count < words.length) {
                sb.append(" ");
            }
            ++n2;
        }
        return sb.toString();
    }

    public static String getLabelAndDescDisplay(String label, String description) {
        if (description != null && description.trim().length() > 0) {
            return String.format(LABEL_DESC_FORMAT, label, description);
        }
        return label;
    }

    public static String getSaveAsFilename(File file) {
        Map<String, String> parts = DocUtils.getNameParts(file);
        return String.format(SAVE_AS_FORMAT, parts.get(F_NAME), parts.get(F_EXT));
    }

    public static String cleanFilename(String newfilePath, File oldFile) {
        File newFile = new File(newfilePath);
        Map<String, String> oldParts = DocUtils.getNameParts(oldFile);
        Map<String, String> newParts = DocUtils.getNameParts(newFile);
        if (newParts.get(F_EXT) == null) {
            File newFileDir = newFile.getParentFile();
            String cleanFilename = String.format(FILENAME_FORMAT, newParts.get(F_NAME), oldParts.get(F_EXT));
            File cleanNewFile = new File(newFileDir, cleanFilename);
            return cleanNewFile.getAbsolutePath();
        }
        return newfilePath;
    }

    public static String getFromTemplateFilename(File templateFile, Properties templateProps) {
        Map<String, String> parts = DocUtils.getNameParts(templateFile);
        return String.format(NEW_FILE_FORMAT, DocUtils.getFromTemplateExt(parts, templateProps));
    }

    public static String cleanFromTemplateFilename(String newfilePath, File templateFile, Properties templateProps) {
        Map<String, String> parts = DocUtils.getNameParts(templateFile);
        File tempTemplateFile = new File(String.format(FILENAME_FORMAT, parts.get(F_NAME), DocUtils.getFromTemplateExt(parts, templateProps)));
        return DocUtils.cleanFilename(newfilePath, tempTemplateFile);
    }

    private static String getFromTemplateExt(Map<String, String> parts, Properties templateProps) {
        String templateExt = parts.get(F_EXT).toLowerCase();
        String fileExt = templateProps.getProperty(templateExt, templateExt);
        return fileExt;
    }

    private static Map<String, String> getNameParts(File file) {
        String filename = file.getName();
        return DocUtils.getNameParts(filename);
    }

    private static Map<String, String> getNameParts(String filename) {
        HashMap<String, String> parts = new HashMap<String, String>();
        int index = filename.lastIndexOf(46);
        if (index == -1) {
            parts.put(F_NAME, filename);
        } else {
            parts.put(F_NAME, filename.substring(0, index));
            parts.put(F_EXT, filename.substring(index + 1));
        }
        return parts;
    }

    public static String getName(File file) {
        return DocUtils.getNameParts(file).get(F_NAME);
    }

    public static String getExtension(File file) {
        return DocUtils.getNameParts(file).get(F_EXT);
    }
}

