/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.document.ui;

import net.refractions.udig.catalog.document.IAbstractDocumentSource;
import net.refractions.udig.catalog.document.IAttachmentSource;
import net.refractions.udig.catalog.document.IDocumentSource;
import net.refractions.udig.catalog.document.IHotlinkSource;

public final class DocSourceUtils {
    public static boolean canAttach(IAbstractDocumentSource source) {
        if (DocSourceUtils.isValidSource(source)) {
            if (source instanceof IDocumentSource) {
                IDocumentSource layerDocSource = (IDocumentSource)source;
                return layerDocSource.canAttach();
            }
            if (source instanceof IAttachmentSource) {
                IAttachmentSource featureDocSource = (IAttachmentSource)source;
                return featureDocSource.canAttach();
            }
        }
        return false;
    }

    public static boolean canLink(IAbstractDocumentSource source) {
        return DocSourceUtils.canLinkFile(source) || DocSourceUtils.canLinkWeb(source);
    }

    public static boolean canLinkFile(IAbstractDocumentSource source) {
        if (DocSourceUtils.isValidSource(source)) {
            if (source instanceof IDocumentSource) {
                IDocumentSource layerDocSource = (IDocumentSource)source;
                return layerDocSource.canLinkFile();
            }
            if (source instanceof IAttachmentSource) {
                IAttachmentSource featureDocSource = (IAttachmentSource)source;
                return featureDocSource.canLinkFile();
            }
        }
        return false;
    }

    public static boolean canLinkWeb(IAbstractDocumentSource source) {
        if (DocSourceUtils.isValidSource(source)) {
            if (source instanceof IDocumentSource) {
                IDocumentSource layerDocSource = (IDocumentSource)source;
                return layerDocSource.canLinkWeb();
            }
            if (source instanceof IAttachmentSource) {
                IAttachmentSource featureDocSource = (IAttachmentSource)source;
                return featureDocSource.canLinkWeb();
            }
        }
        return false;
    }

    public static boolean canUpdate(IAbstractDocumentSource source) {
        if (DocSourceUtils.isValidSource(source)) {
            if (source instanceof IDocumentSource) {
                IDocumentSource layerDocSource = (IDocumentSource)source;
                return layerDocSource.canUpdate();
            }
            if (source instanceof IAttachmentSource) {
                IAttachmentSource featureDocSource = (IAttachmentSource)source;
                return featureDocSource.canUpdate();
            }
            if (source instanceof IHotlinkSource) {
                IHotlinkSource hotlinkSource = (IHotlinkSource)source;
                return hotlinkSource.canSetHotlink();
            }
        }
        return false;
    }

    public static boolean canRemove(IAbstractDocumentSource source) {
        if (DocSourceUtils.isValidSource(source)) {
            if (source instanceof IDocumentSource) {
                IDocumentSource layerDocSource = (IDocumentSource)source;
                return layerDocSource.canRemove();
            }
            if (source instanceof IAttachmentSource) {
                IAttachmentSource featureDocSource = (IAttachmentSource)source;
                return featureDocSource.canRemove();
            }
            if (source instanceof IHotlinkSource) {
                IHotlinkSource hotlinkSource = (IHotlinkSource)source;
                return hotlinkSource.canClearHotlink();
            }
        }
        return false;
    }

    private static boolean isValidSource(IAbstractDocumentSource source) {
        return source != null && source.isEnabled();
    }
}

