/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.document.source;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.commons.io.FileUtils;

public final class ShpDocUtils {
    public static String getAbsolutePath(URL url, String relativePath) {
        if (relativePath != null && relativePath.trim().length() > 0) {
            try {
                File parentFile = new File(new URI(url.toString()));
                File childFile = new File(parentFile.getParent(), relativePath);
                return childFile.getAbsolutePath();
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static String getRelativePath(URL url, String absolutePath) {
        if (absolutePath != null && absolutePath.trim().length() > 0) {
            try {
                File parentFile = new File(new URI(url.toString()));
                File parentDir = parentFile.getParentFile();
                File childFile = new File(absolutePath);
                return parentDir.toURI().relativize(childFile.toURI()).getPath();
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static boolean deleteFile(Object fileObj) {
        if (fileObj instanceof File) {
            return ShpDocUtils.deleteFile((File)fileObj);
        }
        return false;
    }

    public static boolean deleteFile(File file) {
        if (file != null && file.exists()) {
            return file.delete();
        }
        return false;
    }

    public static File copyFile(String oldFilePath, File newFileDir) {
        return ShpDocUtils.copyFile(new File(oldFilePath), newFileDir);
    }

    public static File copyFile(File oldFile, File newFileDir) {
        try {
            File newFile;
            if (!newFileDir.exists()) {
                newFileDir.mkdir();
            }
            if (!(newFile = new File(newFileDir, oldFile.getName())).exists()) {
                FileUtils.copyFileToDirectory((File)oldFile, (File)newFileDir);
                newFile.setReadOnly();
            }
            return newFile;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

