/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.browser.ui;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedList;
import net.refractions.udig.browser.BrowserPlugin;
import net.refractions.udig.browser.ExternalCatalogueImportPage;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class URLImportPage
extends WizardPage
implements ModifyListener,
ExternalCatalogueImportPage {
    private static String URL_WIZARD = "URL_WIZARD";
    private static String URL_RECENT = "URL_RECENT";
    private static int RECENT_COUNT = 10;
    private URL url;
    private Combo urlCombo;
    private Label urlLabel;
    private IDialogSettings settings = BrowserPlugin.getDefault().getDialogSettings().getSection(URL_WIZARD);
    private ImageDescriptor icon;
    private LocationListener listen;
    private String emptyOption = "http://";
    private String viewName;

    public URLImportPage() {
        super("External Catalog by URL");
        if (this.settings == null) {
            this.settings = BrowserPlugin.getDefault().getDialogSettings().addNewSection(URL_WIZARD);
        }
    }

    @Override
    public String getID() {
        return "net.refractions.udig.browser.URL";
    }

    @Override
    public URL getURL() {
        return this.url;
    }

    public void modifyText(ModifyEvent e) {
        if (this.isPageComplete()) {
            this.setErrorMessage(null);
            this.getWizard().getContainer().updateButtons();
        } else {
            this.setErrorMessage("Invalid URL");
        }
    }

    public boolean canFlipToNextPage() {
        return false;
    }

    public boolean isPageComplete() {
        try {
            String urlString = this.urlCombo.getText();
            this.url = new URL(urlString);
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
        this.updateSettings();
        return true;
    }

    private void updateSettings() {
        LinkedList<String> list = new LinkedList<String>();
        String[] recents = this.urlCombo.getItems();
        String selected = this.urlCombo.getText();
        if (selected == null || selected.length() == 0) {
            this.settings.put(URL_RECENT, recents);
            return;
        }
        list.add(selected);
        int count = 1;
        String[] stringArray = recents;
        int n = recents.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            if (!string.equals(selected) && !string.equals(this.emptyOption)) {
                list.add(string);
                ++count;
            }
            if (count > RECENT_COUNT) break;
            ++n2;
        }
        this.settings.put(URL_RECENT, list.toArray(new String[0]));
    }

    public void createControl(Composite parent) {
        String[] recent = this.settings.getArray(URL_RECENT);
        if (recent == null) {
            recent = new String[]{this.emptyOption};
        }
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        GridData data = new GridData(768);
        composite.setLayout((Layout)layout);
        this.urlLabel = new Label(composite, 0);
        this.urlLabel.setText("Enter the URL of the catalog to connect to:");
        this.urlLabel.setLayoutData((Object)data);
        this.urlCombo = new Combo(composite, 4);
        this.urlCombo.setLayoutData((Object)data);
        this.urlCombo.addModifyListener((ModifyListener)this);
        this.urlCombo.setItems(recent);
        this.urlCombo.select(0);
        composite.setTabList(new Control[]{this.urlCombo});
        composite.setFocus();
        this.setControl((Control)composite);
    }

    @Override
    public void setIconDescriptor(ImageDescriptor descIcon) {
        this.icon = descIcon;
    }

    @Override
    public ImageDescriptor getIconDescriptor() {
        return this.icon;
    }

    @Override
    public LocationListener getListener() {
        return this.listen;
    }

    @Override
    public void setListener(LocationListener listen) {
        this.listen = listen;
    }

    @Override
    public void setViewName(String viewName) {
        this.viewName = viewName;
    }

    @Override
    public String getViewName() {
        return this.viewName;
    }
}

