/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.browser.ui;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.refractions.udig.browser.BrowserPlugin;
import net.refractions.udig.browser.ExternalCatalogueImportDescriptor;
import net.refractions.udig.browser.ExternalCatalogueImportPage;
import net.refractions.udig.browser.ExternalCatalogueImportPageDescriptor;
import net.refractions.udig.browser.ExternalCatalogueImportURLDescriptor;
import net.refractions.udig.catalog.ui.IDataWizard;
import net.refractions.udig.core.internal.ExtensionPointProcessor;
import net.refractions.udig.core.internal.ExtensionPointUtil;
import net.refractions.udig.internal.ui.UiPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jface.wizard.WizardSelectionPage;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class BrowserSelectionPage
extends WizardSelectionPage
implements ISelectionChangedListener {
    private static String BROWSER_SELECTION = "BROWSER_SELECTION";
    private static String SELECTED_BROWSER = "SELECTED_BROWSER";
    private IDialogSettings settings = BrowserPlugin.getDefault().getDialogSettings().getSection(BROWSER_SELECTION);
    private List<ExternalCatalogueImportDescriptor> descriptors;
    private WizardViewer viewer;
    private ExternalCatalogueImportDescriptor selectedDescriptor;
    private Map<ExternalCatalogueImportDescriptor, ExternalCatalogueImportPage> pageCache;

    public BrowserSelectionPage() {
        this("Select a Catalog");
    }

    public BrowserSelectionPage(String pageName) {
        super(pageName);
        if (this.settings == null) {
            this.settings = BrowserPlugin.getDefault().getDialogSettings().addNewSection(BROWSER_SELECTION);
        }
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete();
    }

    public boolean isPageComplete() {
        return this.selectedDescriptor != null && this.selectedDescriptor instanceof ExternalCatalogueImportPageDescriptor;
    }

    private Map<ExternalCatalogueImportDescriptor, ExternalCatalogueImportPage> getPageCache() {
        if (this.pageCache == null) {
            this.pageCache = new HashMap<ExternalCatalogueImportDescriptor, ExternalCatalogueImportPage>();
        }
        return this.pageCache;
    }

    public URL getUrl() {
        if (this.selectedDescriptor != null && this.selectedDescriptor instanceof ExternalCatalogueImportURLDescriptor) {
            return ((ExternalCatalogueImportURLDescriptor)this.selectedDescriptor).getUrl();
        }
        return null;
    }

    public IWizardPage getNextPage() {
        ExternalCatalogueImportDescriptor id = this.selectedDescriptor;
        if (!(id instanceof ExternalCatalogueImportPageDescriptor)) {
            return null;
        }
        ExternalCatalogueImportPageDescriptor d = (ExternalCatalogueImportPageDescriptor)id;
        if (d != null) {
            try {
                IDataWizard wizard = (IDataWizard)this.getWizard();
                ExternalCatalogueImportPage page = this.getPageCache().get(d);
                if (page == null) {
                    page = d.createImportPage();
                    this.getPageCache().put(d, page);
                }
                wizard.init((WizardPage)page);
                return page;
            }
            catch (CoreException e) {
                String msg = "Could not instantiate import wizard page";
                System.out.println(msg);
                e.printStackTrace();
            }
        }
        return null;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        IStructuredSelection selected = (IStructuredSelection)event.getSelection();
        if (selected == null || selected.isEmpty()) {
            return;
        }
        this.selectedDescriptor = (ExternalCatalogueImportDescriptor)selected.getFirstElement();
        this.settings.put(SELECTED_BROWSER, this.selectedDescriptor.getLabel());
        this.setDescription(this.selectedDescriptor.getDescription());
        this.setImageDescriptor(this.selectedDescriptor.getDescriptionImage());
        this.getWizard().getContainer().updateButtons();
    }

    public void createControl(Composite parent) {
        this.viewer = new WizardViewer(parent, 4);
        List<ExternalCatalogueImportDescriptor> list = this.getDescriptors();
        this.viewer.setInput(list.toArray());
        String browser = this.settings.get(SELECTED_BROWSER);
        if (browser != null && browser.length() != 0) {
            final LinkedList<ExternalCatalogueImportDescriptor> selection = new LinkedList<ExternalCatalogueImportDescriptor>();
            for (ExternalCatalogueImportDescriptor desc : list) {
                if (!desc.getLabel().equals(browser)) continue;
                selection.add(desc);
                this.viewer.setSelection((ISelection)new IStructuredSelection(){

                    public Object getFirstElement() {
                        return selection.get(0);
                    }

                    public Iterator iterator() {
                        return selection.iterator();
                    }

                    public int size() {
                        return 1;
                    }

                    public Object[] toArray() {
                        return selection.toArray();
                    }

                    public List toList() {
                        return selection;
                    }

                    public boolean isEmpty() {
                        return false;
                    }
                });
            }
        }
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IWizardPage next = BrowserSelectionPage.this.getNextPage();
                BrowserSelectionPage.this.getWizard().getContainer().showPage(next);
            }
        });
        this.viewer.addSelectionChangedListener(this);
        this.setControl(this.viewer.getControl());
    }

    protected List<ExternalCatalogueImportDescriptor> getDescriptors() {
        if (this.descriptors == null) {
            ExternalCatalogueImportPageProcessor p = new ExternalCatalogueImportPageProcessor();
            String xpid = "net.refractions.udig.browser.externalCatalogWizard";
            ExtensionPointUtil.process((Plugin)BrowserPlugin.getDefault(), (String)xpid, (ExtensionPointProcessor)p);
            this.descriptors = p.descriptors;
            ExternalCatalogueImportURLProcessor up = new ExternalCatalogueImportURLProcessor();
            ExtensionPointUtil.process((Plugin)BrowserPlugin.getDefault(), (String)xpid, (ExtensionPointProcessor)up);
            this.descriptors.addAll(up.descriptors);
        }
        if (this.descriptors != null) {
            try {
                Collections.sort(this.descriptors, new Comparator(){

                    public int compare(Object o1, Object o2) {
                        String s1 = ((ExternalCatalogueImportDescriptor)o1).getLabel();
                        String s2 = ((ExternalCatalogueImportDescriptor)o2).getLabel();
                        return s1.compareTo(s2);
                    }
                });
            }
            catch (NullPointerException ex) {
                ex.printStackTrace();
            }
        }
        return this.descriptors;
    }

    public String getTitle() {
        if (this.selectedDescriptor != null) {
            return this.selectedDescriptor.getLabel();
        }
        return super.getTitle();
    }

    public boolean canFinish() {
        if (this.selectedDescriptor != null) {
            return this.selectedDescriptor instanceof ExternalCatalogueImportURLDescriptor;
        }
        return false;
    }

    public ImageDescriptor getIconDescriptor() {
        if (this.selectedDescriptor != null) {
            return this.selectedDescriptor.getIcon();
        }
        return null;
    }

    public LocationListener getListener() {
        return this.selectedDescriptor.getListener();
    }

    public String getViewName() {
        return this.selectedDescriptor.getViewName();
    }

    private static class ExternalCatalogueImportPageProcessor
    implements ExtensionPointProcessor {
        List<ExternalCatalogueImportDescriptor> descriptors = new LinkedList<ExternalCatalogueImportDescriptor>();

        private ExternalCatalogueImportPageProcessor() {
        }

        public void process(IExtension extension, IConfigurationElement element) throws Exception {
            IConfigurationElement[] childs = element.getChildren("externalCataloguePage");
            if (childs.length > 0) {
                ExternalCatalogueImportPageDescriptor d = new ExternalCatalogueImportPageDescriptor(element);
                this.descriptors.add(d);
            }
        }
    }

    private static class ExternalCatalogueImportURLProcessor
    implements ExtensionPointProcessor {
        List<ExternalCatalogueImportDescriptor> descriptors = new LinkedList<ExternalCatalogueImportDescriptor>();

        private ExternalCatalogueImportURLProcessor() {
        }

        public void process(IExtension extension, IConfigurationElement element) throws Exception {
            IConfigurationElement[] childs = element.getChildren("externalCatalogueURL");
            if (childs.length == 0) {
                return;
            }
            URL url = null;
            try {
                url = new URL(childs[0].getAttribute("url"));
            }
            catch (MalformedURLException malformedURLException) {
                return;
            }
            ExternalCatalogueImportURLDescriptor d = new ExternalCatalogueImportURLDescriptor(url);
            d.setLabel(element.getAttribute("name"));
            d.setID(element.getAttribute("id"));
            d.setDescription(element.getAttribute("description"));
            d.setListener(element.getAttribute("listener"));
            d.setViewName(element.getAttribute("viewName"));
            String ns = element.getNamespace();
            String banner = element.getAttribute("image");
            if (banner != null) {
                d.setDescriptionImage(AbstractUIPlugin.imageDescriptorFromPlugin((String)ns, (String)banner));
            }
            if ((banner = element.getAttribute("icon")) != null) {
                d.setIcon(AbstractUIPlugin.imageDescriptorFromPlugin((String)ns, (String)banner));
            }
            this.descriptors.add(d);
        }
    }

    private static class WizardViewer
    extends TableViewer {
        public WizardViewer(Composite parent, int style) {
            super(parent, style);
            this.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
            this.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

                public String getText(Object object) {
                    ExternalCatalogueImportDescriptor descriptor = (ExternalCatalogueImportDescriptor)object;
                    return descriptor.getLabel();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Image getImage(Object object) {
                    ExternalCatalogueImportDescriptor descriptor = (ExternalCatalogueImportDescriptor)object;
                    String id = descriptor.getID();
                    ImageRegistry registry = UiPlugin.getDefault().getImageRegistry();
                    ImageDescriptor image = descriptor.getIcon();
                    ImageRegistry imageRegistry = registry;
                    synchronized (imageRegistry) {
                        if (registry.get(id) == null && image != null) {
                            registry.put(id, image);
                        }
                        return registry.get(id);
                    }
                }
            });
        }
    }
}

