/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.browser.ui;

import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.regex.Pattern;
import net.refractions.udig.browser.BrowserPlugin;
import net.refractions.udig.browser.internal.Messages;
import net.refractions.udig.browser.ui.LocationEntry;
import net.refractions.udig.catalog.ui.FileConnectionFactory;
import net.refractions.udig.internal.ui.UDIGDropHandler;
import net.refractions.udig.project.ui.internal.ApplicationGISInternal;
import net.refractions.udig.project.ui.internal.MapEditorPart;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.CloseWindowListener;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.OpenWindowListener;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.browser.TitleListener;
import org.eclipse.swt.browser.VisibilityWindowListener;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Adapter;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;

public class BrowserContainerView
extends ViewPart {
    public static final String VIEW_ID = "net.refractions.udig.browser.ui.browserContainerView";
    private static String BROWSER_TYPE = "net.refractions.udig.browser.TYPE";
    private static String BROWSER_NAME = "BROWSER_NAME";
    private static String BROWSER_URL = "BROWSER_URL";
    private static String BROWSER_LISTENER = "BROWSER_LISTENER";
    private static String BROWSER_ALERT_URL = "BROWSER_ALERT_URL";
    private CTabFolder tabFolder;
    private static int count = 1;
    private LocationListener locListen;
    private URL lastAlertURL;
    private String forwardIconEnabled = "icons/elcl16/forward_nav.gif";
    private String forwardIconDisabled = "icons/dlcl16/forward_nav.gif";
    private String backwardIconEnabled = "icons/elcl16/backward_nav.gif";
    private String backwardIconDisabled = "icons/dlcl16/backward_nav.gif";
    private String refreshIconEnabled = "icons/elcl16/refresh_co.gif";
    private IAction forward;
    private IAction backward;
    private ChangeListener changeListener;
    private Map<Browser, CTabItem> tabMap = new HashMap<Browser, CTabItem>();
    private Map<Browser, String> listenerMap = new HashMap<Browser, String>();
    private List<BrowserData> browserData;
    private LocationEntry locationEntry;
    private IAction refresh;

    public void createPartControl(Composite parent) {
        FormLayout layout = new FormLayout();
        parent.setLayout((Layout)layout);
        this.locationEntry = new LocationEntry(this);
        Control control = this.locationEntry.createControl(parent);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        control.setLayoutData((Object)data);
        this.tabFolder = new CTabFolder(parent, 2240);
        this.tabFolder.addSelectionListener((SelectionListener)this.getChangeListener());
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(control, 0);
        data.bottom = new FormAttachment(100, 0);
        this.tabFolder.setLayoutData((Object)data);
        IViewSite site = this.getViewSite();
        IActionBars bars = site.getActionBars();
        IToolBarManager toolbarMgr = bars.getToolBarManager();
        toolbarMgr.add(this.getBackwardAction());
        toolbarMgr.add(this.getForwardAction());
        toolbarMgr.add(this.getRefreshAction());
        toolbarMgr.add(this.locationEntry.getButton());
        if (this.browserData != null) {
            for (BrowserData bd : this.browserData) {
                this.addTab(bd.getName(), bd.getUrl(), bd.getListener());
            }
            this.browserData = null;
        } else {
            this.addTab(Messages.BrowserContainerView_tabTitle, "http://udig.refractions.net/confluence/display/DATA", (Image)null, this.getListener());
        }
    }

    public void setFocus() {
        this.tabFolder.getSelection().getControl().setFocus();
    }

    public IAction getForwardAction() {
        if (this.forward == null) {
            this.forward = new Action(){

                public void run() {
                    CTabItem tab = BrowserContainerView.this.tabFolder.getSelection();
                    if (tab == null) {
                        return;
                    }
                    Control cont = tab.getControl();
                    if (cont instanceof Browser) {
                        ((Browser)cont).forward();
                    }
                }
            };
            this.forward.setEnabled(false);
            this.forward.setText(Messages.BrowserContainerView_forward_text);
            this.forward.setImageDescriptor(BrowserPlugin.getImageDescriptor(this.forwardIconEnabled));
            this.forward.setDisabledImageDescriptor(BrowserPlugin.getImageDescriptor(this.forwardIconDisabled));
            this.forward.setToolTipText(Messages.BrowserContainerView_forward_tooltip);
        }
        return this.forward;
    }

    public IAction getBackwardAction() {
        if (this.backward == null) {
            this.backward = new Action(){

                public void run() {
                    CTabItem tab = BrowserContainerView.this.tabFolder.getSelection();
                    if (tab == null) {
                        return;
                    }
                    Control cont = tab.getControl();
                    if (cont instanceof Browser) {
                        ((Browser)cont).back();
                    }
                }
            };
            this.backward.setEnabled(false);
            this.backward.setText(Messages.BrowserContainerView_back_text);
            this.backward.setImageDescriptor(BrowserPlugin.getImageDescriptor(this.backwardIconEnabled));
            this.backward.setDisabledImageDescriptor(BrowserPlugin.getImageDescriptor(this.backwardIconDisabled));
            this.backward.setToolTipText(Messages.BrowserContainerView_back_tooltip);
        }
        return this.backward;
    }

    public IAction getRefreshAction() {
        if (this.refresh == null) {
            this.refresh = new Action(){

                public void run() {
                    CTabItem tab = BrowserContainerView.this.tabFolder.getSelection();
                    if (tab == null) {
                        return;
                    }
                    Control cont = tab.getControl();
                    if (cont instanceof Browser) {
                        ((Browser)cont).refresh();
                    }
                }
            };
            this.refresh.setEnabled(true);
            this.refresh.setText(Messages.BrowserContainerView_refresh);
            this.refresh.setImageDescriptor(BrowserPlugin.getImageDescriptor(this.refreshIconEnabled));
            this.refresh.setImageDescriptor(BrowserPlugin.getImageDescriptor(this.refreshIconEnabled));
            this.refresh.setToolTipText(Messages.BrowserContainerView_refresh);
        }
        return this.refresh;
    }

    public void setName(String name) {
        this.setPartName(name);
    }

    public LocationListener getListener() {
        if (this.locListen == null) {
            this.locListen = new LocationListener(){

                public void changing(LocationEvent event) {
                    String url = event.location;
                    if (url.toLowerCase().indexOf("=getcapabilities") != -1 || url.toLowerCase().indexOf("jdbc:postgis://") != -1 || url.toLowerCase().indexOf("postgis:jdbc://") != -1 || this.recognizedFile(url)) {
                        event.doit = false;
                        UDIGDropHandler dropHandler = new UDIGDropHandler();
                        MapEditorPart editor = ApplicationGISInternal.getActiveEditor();
                        dropHandler.setTarget((Object)editor);
                        dropHandler.performDrop((Object)url, null);
                    }
                }

                private boolean recognizedFile(String url) {
                    if (url.toLowerCase().indexOf("file://") != -1) {
                        return new FileConnectionFactory().canProcess((Object)url);
                    }
                    Pattern PATTERN = Pattern.compile("[^:/]+://?.+");
                    if (PATTERN.matcher(url).matches()) {
                        return new FileConnectionFactory().canProcess((Object)url);
                    }
                    return false;
                }

                public void changed(LocationEvent event) {
                }
            };
        }
        return this.locListen;
    }

    public ChangeListener getChangeListener() {
        if (this.changeListener == null) {
            this.changeListener = new ChangeListener();
        }
        return this.changeListener;
    }

    public void addTab(String name, String url, LocationListener listen) {
        this.addTab(name, url, (Image)null, listen);
    }

    public void addTab(String name, String url, ImageDescriptor desc, LocationListener listen) {
        if (desc != null) {
            this.addTab(name, url, desc.createImage(), listen);
        } else {
            this.addTab(name, url, (Image)null, listen);
        }
    }

    public void addTab(String name, URL url, ImageDescriptor desc, LocationListener listen) {
        this.addTab(name, url.toString(), desc, listen);
    }

    public void addTab(String name, String url, Image image, LocationListener listen) {
        CTabItem item = new CTabItem(this.tabFolder, 0);
        if (name != null) {
            item.setText(name);
        } else {
            item.setText(MessageFormat.format(Messages.BrowserContainerView_pageCount, count++));
        }
        Browser browser = this.createBrowser(item, listen);
        browser.setUrl(url);
        if (image != null) {
            item.setImage(image);
        }
        this.tabFolder.setSelection(item);
        this.tabFolder.layout();
    }

    public void addTab(URL url, LocationListener listen) {
        this.addTab(null, url, listen);
    }

    public void addTab(URL url, Image image, LocationListener listen) {
        this.addTab(null, url.toString(), image, listen);
    }

    public void addTab(String name, URL url, LocationListener listen) {
        this.addTab(name, url.toString(), listen);
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        if (memento != null) {
            IMemento[] array = memento.getChildren(BROWSER_TYPE);
            this.browserData = new ArrayList<BrowserData>(array.length);
            IMemento[] iMementoArray = array;
            int n = array.length;
            int n2 = 0;
            while (n2 < n) {
                IMemento mem = iMementoArray[n2];
                this.browserData.add(new BrowserData(mem));
                ++n2;
            }
            String urlString = memento.getString(BROWSER_ALERT_URL);
            if (urlString != null) {
                try {
                    this.lastAlertURL = new URL(urlString);
                }
                catch (MalformedURLException malformedURLException) {}
            }
        }
    }

    public void saveState(IMemento memento) {
        Control[] controls;
        super.saveState(memento);
        if (this.lastAlertURL != null) {
            memento.putString(BROWSER_ALERT_URL, this.lastAlertURL.toString());
        }
        Control[] controlArray = controls = this.tabFolder.getChildren();
        int n = controls.length;
        int n2 = 0;
        while (n2 < n) {
            Browser browser;
            Control control = controlArray[n2];
            if (control instanceof Browser && !(browser = (Browser)control).isDisposed()) {
                CTabItem item = this.tabMap.get(browser);
                String listener = this.listenerMap.get(browser);
                if (item != null && !item.isDisposed()) {
                    IMemento child = memento.createChild(BROWSER_TYPE);
                    child.putString(BROWSER_NAME, item.getText());
                    child.putString(BROWSER_URL, browser.getUrl());
                    child.putString(BROWSER_LISTENER, listener);
                }
            }
            ++n2;
        }
    }

    private Browser createBrowser(CTabItem item, LocationListener listen) {
        Browser browser = new Browser((Composite)this.tabFolder, 0);
        if (listen != null) {
            browser.addLocationListener(listen);
            this.listenerMap.put(browser, listen.getClass().getCanonicalName());
        } else {
            browser.addLocationListener(this.getListener());
            this.listenerMap.put(browser, "DEFAULT");
        }
        browser.addLocationListener((LocationListener)this.getChangeListener());
        browser.addVisibilityWindowListener((VisibilityWindowListener)this.getChangeListener());
        browser.addOpenWindowListener((OpenWindowListener)this.getChangeListener());
        browser.addTitleListener((TitleListener)this.getChangeListener());
        item.setControl((Control)browser);
        this.tabMap.put(browser, item);
        IProgressMonitor monitor = this.getViewSite().getActionBars().getStatusLineManager().getProgressMonitor();
        browser.addProgressListener((ProgressListener)new BrowserProgressListener(monitor, item, this.tabFolder));
        return browser;
    }

    public void addTab(String url, LocationListener listen) {
        this.addTab(null, url, listen);
    }

    public void setCurrentURL(String text) {
        CTabItem item = this.tabFolder.getSelection();
        if (item == null) {
            this.addTab(Messages.BrowserContainerView_tabTitle, text, (Image)null, this.getListener());
        } else {
            Browser b = (Browser)item.getControl();
            b.setUrl(text);
        }
    }

    private static class BrowserData {
        private String name;
        private String url;
        private String listener;

        BrowserData(String name1, String url1, String listener1) {
            this.name = name1;
            this.url = url1;
            this.listener = listener1;
        }

        BrowserData(IMemento m) {
            this(m.getString(BROWSER_NAME), m.getString(BROWSER_URL), m.getString(BROWSER_LISTENER));
        }

        public String getName() {
            return this.name;
        }

        public String getUrl() {
            return this.url;
        }

        public LocationListener getListener() {
            if (this.listener == null || this.listener.equals("DEFAULT")) {
                return null;
            }
            try {
                return (LocationListener)Class.forName(this.listener).newInstance();
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (ClassNotFoundException classNotFoundException) {}
            return null;
        }
    }

    private final class BrowserProgressListener
    implements ProgressListener {
        private final IProgressMonitor monitor;
        private CTabItem item;
        int current = -1;
        Timer timer = new Timer();
        Timeout timeout = null;

        public BrowserProgressListener(final IProgressMonitor monitor, final CTabItem item, CTabFolder tabFolder) {
            this.monitor = monitor;
            this.item = item;
            tabFolder.addCTabFolder2Listener((CTabFolder2Listener)new CTabFolder2Adapter(){

                public void close(CTabFolderEvent event) {
                    if (event.item == item) {
                        monitor.done();
                    }
                }
            });
            item.addListener(12, new Listener(){

                public void handleEvent(Event event) {
                    monitor.done();
                }
            });
        }

        public void changed(ProgressEvent event) {
            if (this.timeout != null) {
                this.timeout.cancel();
            }
            this.timeout = new Timeout();
            this.timer.schedule((TimerTask)this.timeout, 20000L);
            if (this.current > 0) {
                this.monitor.worked(Math.max(0, event.current - this.current));
                if (event.current >= event.total) {
                    this.completed(event);
                }
            } else {
                String msg = MessageFormat.format(Messages.BrowserContainerView_loadingMessage, this.item.getText());
                this.monitor.beginTask(msg, event.total);
                this.monitor.worked(event.current);
                this.current = event.current;
            }
        }

        public void completed(ProgressEvent event) {
            if (this.timeout != null) {
                this.timeout.cancel();
            }
            this.monitor.done();
            this.current = -1;
        }

        class Timeout
        extends TimerTask {
            Timeout() {
            }

            @Override
            public void run() {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        BrowserProgressListener.this.monitor.done();
                    }
                });
            }
        }
    }

    private class ChangeListener
    implements LocationListener,
    VisibilityWindowListener,
    SelectionListener,
    OpenWindowListener,
    CloseWindowListener,
    TitleListener {
        private ChangeListener() {
        }

        public void changing(LocationEvent event) {
            BrowserContainerView.this.locationEntry.setText(event.location);
        }

        public void changed(LocationEvent event) {
            this.setEnability();
        }

        public void hide(WindowEvent event) {
            this.setEnability();
        }

        public void show(WindowEvent event) {
            this.setEnability();
        }

        private void setEnability() {
            CTabItem tab = BrowserContainerView.this.tabFolder.getSelection();
            if (tab == null) {
                BrowserContainerView.this.getForwardAction().setEnabled(false);
                BrowserContainerView.this.getBackwardAction().setEnabled(false);
                BrowserContainerView.this.getRefreshAction().setEnabled(false);
            } else {
                Control cont = tab.getControl();
                if (cont instanceof Browser) {
                    BrowserContainerView.this.getForwardAction().setEnabled(((Browser)cont).isForwardEnabled());
                    BrowserContainerView.this.getBackwardAction().setEnabled(((Browser)cont).isBackEnabled());
                    BrowserContainerView.this.getRefreshAction().setEnabled(true);
                }
            }
        }

        public void widgetSelected(SelectionEvent e) {
            this.setEnability();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.setEnability();
        }

        public void open(WindowEvent event) {
            CTabItem item = new CTabItem(BrowserContainerView.this.tabFolder, 0);
            Browser browser = BrowserContainerView.this.createBrowser(item, null);
            Object[] objectArray = new Object[1];
            int n = count;
            count = n + 1;
            objectArray[0] = n;
            item.setText(MessageFormat.format(Messages.BrowserContainerView_pageCount, objectArray));
            BrowserContainerView.this.tabFolder.setSelection(item);
            event.browser = browser;
        }

        public void changed(TitleEvent event) {
            String title = event.title;
            if (title != null && title.length() != 0 && title.indexOf("http://") == -1) {
                CTabItem item = (CTabItem)BrowserContainerView.this.tabMap.get(event.getSource());
                item.setText(title);
            }
        }

        public void close(WindowEvent event) {
            Browser browser = event.browser;
            BrowserContainerView.this.tabMap.remove(browser);
            BrowserContainerView.this.listenerMap.remove(browser);
        }
    }
}

