/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs.v1_0_0;

import java.util.List;
import org.xml.sax.SAXException;

public class TransactionResult {
    public static final int NO_STATUS = 0;
    public static final int SUCCESS = 1;
    public static final int FAILED = 2;
    public static final int PARTIAL = 4;
    private List<String> insertResult;
    private int status;
    private SAXException error;

    public TransactionResult(int status, List<String> insertResult, SAXException error) {
        this.status = status;
        this.insertResult = insertResult;
        this.error = error;
    }

    public TransactionResult(int status, List<String> insertResult, String locator, String message) {
        this.status = status;
        this.insertResult = insertResult;
        this.error = new SAXException(message + ":" + (locator == null ? "" : locator));
    }

    public static int parseStatus(String s) {
        if ("SUCCESS".equalsIgnoreCase(s)) {
            return 1;
        }
        if ("FAILED".equalsIgnoreCase(s)) {
            return 2;
        }
        if ("PARTIAL".equalsIgnoreCase(s)) {
            return 4;
        }
        return 0;
    }

    public static String printStatus(int i) {
        switch (i) {
            case 1: {
                return "SUCCESS";
            }
            case 2: {
                return "FAILED";
            }
            case 4: {
                return "PARTIAL";
            }
        }
        return "";
    }

    public SAXException getError() {
        return this.error;
    }

    public List<String> getInsertResult() {
        return this.insertResult;
    }

    public int getStatus() {
        return this.status;
    }
}

