/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.internal.worldimage;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.refractions.udig.catalog.URLUtils;
import net.refractions.udig.catalog.internal.worldimage.WorldImageGeoResourceImpl;
import net.refractions.udig.catalog.rasterings.AbstractRasterGeoResource;
import net.refractions.udig.catalog.rasterings.AbstractRasterService;
import net.refractions.udig.catalog.rasterings.AbstractRasterServiceInfo;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.geotools.coverage.grid.io.GridFormatFactorySpi;
import org.geotools.gce.image.WorldImageFormatFactory;

public class WorldImageServiceImpl
extends AbstractRasterService {
    private AbstractRasterGeoResource resource;

    public WorldImageServiceImpl(URL id2, WorldImageFormatFactory factory) {
        super(id2, "world+image", (GridFormatFactorySpi)factory);
    }

    public synchronized AbstractRasterGeoResource getGeoResource(IProgressMonitor monitor) {
        if (this.resource == null) {
            URL prjURL = null;
            File baseFile = URLUtils.urlToFile((URL)this.getIdentifier());
            File[] found = URLUtils.findRelatedFiles((File)baseFile, (String[])new String[]{".prj"});
            if (found.length > 0) {
                try {
                    prjURL = found[0].toURI().toURL();
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
            }
            this.resource = new WorldImageGeoResourceImpl(this, this.getHandle(), prjURL);
        }
        return this.resource;
    }

    public List<AbstractRasterGeoResource> resources(IProgressMonitor monitor) throws IOException {
        ArrayList<AbstractRasterGeoResource> list = new ArrayList<AbstractRasterGeoResource>();
        list.add(this.getGeoResource(monitor));
        return list;
    }

    protected AbstractRasterServiceInfo createInfo(IProgressMonitor monitor) throws IOException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask("world image", 2);
        try {
            monitor.worked(1);
            AbstractRasterServiceInfo abstractRasterServiceInfo = new AbstractRasterServiceInfo((AbstractRasterService)this, new String[]{"WorldImage", "world image", ".gif", ".jpg", ".jpeg", ".tif", ".tiff", ".png"});
            return abstractRasterServiceInfo;
        }
        finally {
            monitor.done();
        }
    }

    public Map<String, Serializable> getConnectionParams() {
        HashMap<String, Serializable> params = new HashMap<String, Serializable>();
        params.put("URL", this.getIdentifier());
        return params;
    }
}

