/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.internal.worldimage;

import java.io.File;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.catalog.ServiceExtension2;
import net.refractions.udig.catalog.URLUtils;
import net.refractions.udig.catalog.internal.worldimage.WorldImageServiceImpl;
import net.refractions.udig.catalog.worldimage.internal.Messages;
import org.geotools.gce.image.WorldImageFormat;
import org.geotools.gce.image.WorldImageFormatFactory;

public class WorldImageServiceExtension
implements ServiceExtension2 {
    public static final String URL_PARAM = "URL";
    public static final String TYPE = "world+image";
    private static WorldImageFormatFactory factory;

    public IService createService(URL id, Map<String, Serializable> params) {
        URL id2 = this.getID(params);
        if (!this.canProcess(id2)) {
            return null;
        }
        WorldImageServiceImpl service = new WorldImageServiceImpl(id2, WorldImageServiceExtension.getFactory());
        return service;
    }

    private URL getID(Map<String, Serializable> params) {
        if (params.containsKey(URL_PARAM)) {
            Serializable param = params.get(URL_PARAM);
            if (param instanceof String) {
                try {
                    return new URL((String)((Object)param));
                }
                catch (MalformedURLException malformedURLException) {
                    return null;
                }
            }
            if (param instanceof URL) {
                return (URL)param;
            }
            return null;
        }
        return null;
    }

    public static WorldImageFormatFactory getFactory() {
        if (factory == null) {
            factory = new WorldImageFormatFactory();
        }
        return factory;
    }

    private boolean canProcess(URL id) {
        return this.reasonForFailure(id) == null;
    }

    public Map<String, Serializable> createParams(URL url) {
        if (!this.canProcess(url)) {
            return null;
        }
        if (url != null) {
            HashMap<String, Serializable> params = new HashMap<String, Serializable>();
            params.put(URL_PARAM, url);
            return params;
        }
        return null;
    }

    public String reasonForFailure(Map<String, Serializable> params) {
        return this.reasonForFailure(this.getID(params));
    }

    public String reasonForFailure(URL id) {
        if (id == null) {
            return Messages.WorldImageServiceExtension_noID;
        }
        File file = URLUtils.urlToFile((URL)id);
        if (file == null) {
            return "Not a file";
        }
        String path = file.getAbsolutePath();
        String fileExt = path.substring(path.lastIndexOf(46) + 1).toLowerCase();
        if (fileExt.compareToIgnoreCase("BMP") != 0 && fileExt.compareToIgnoreCase("PNG") != 0 && fileExt.compareToIgnoreCase("GIF") != 0 && fileExt.compareToIgnoreCase("JPG") != 0 && fileExt.compareToIgnoreCase("JPEG") != 0 && fileExt.compareToIgnoreCase("TIF") != 0 && fileExt.compareToIgnoreCase("TIFF") != 0) {
            return String.valueOf(Messages.WorldImageServiceExtension_badFileExtension) + fileExt;
        }
        HashSet<String> endings = new HashSet<String>(WorldImageFormat.getWorldExtension((String)fileExt));
        endings.add(".wld");
        endings.add(String.valueOf(fileExt) + "w");
        File[] found = URLUtils.findRelatedFiles((File)file, (String[])endings.toArray(new String[0]));
        if (found.length == 0) {
            return Messages.WorldImageServiceExtension_needsFile;
        }
        if (!id.getProtocol().equals("file")) {
            return Messages.WorldImageServiceExtension_mustBeFIle;
        }
        try {
            URLUtils.urlToFile((URL)id);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return String.valueOf(Messages.WorldImageServiceExtension_IllegalFilePart1) + id.getFile() + Messages.WorldImageServiceExtension_IllegalFilePart2;
        }
        return null;
    }
}

