/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.internal.worldimage;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.text.MessageFormat;
import java.util.Hashtable;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.catalog.rasterings.AbstractRasterGeoResource;
import net.refractions.udig.catalog.rasterings.GridCoverageLoader;
import net.refractions.udig.catalog.rasterings.RasteringsPlugin;
import net.refractions.udig.catalog.worldimage.internal.Messages;
import net.refractions.udig.internal.ui.UiPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.geotools.coverage.grid.GeneralGridGeometry;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.ViewType;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class InMemoryCoverageLoader
extends GridCoverageLoader {
    private static final GridCoverage EMPTY_COVERAGE;
    private volatile SoftReference<GridCoverage> coverage = new SoftReference<Object>(null);
    private String fileName;

    static {
        ReferencedEnvelope envelope = new ReferencedEnvelope(0.0, 1.0E-5, 0.0, 1.0E-5, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        BufferedImage image = new BufferedImage(1, 1, 10);
        Graphics2D createGraphics = image.createGraphics();
        createGraphics.drawRect(0, 0, 1, 1);
        createGraphics.dispose();
        EMPTY_COVERAGE = new GridCoverageFactory().create((CharSequence)"placeholder", (RenderedImage)image, (Envelope)envelope);
    }

    public InMemoryCoverageLoader(AbstractRasterGeoResource resource, String fileName) throws IOException {
        super((IGeoResource)resource);
        this.fileName = fileName;
    }

    public synchronized GridCoverage load(GeneralGridGeometry geom, IProgressMonitor monitor) throws IOException {
        if (this.coverage.get() == null) {
            try {
                AbstractGridCoverage2DReader reader = (AbstractGridCoverage2DReader)this.resource.resolve(AbstractGridCoverage2DReader.class, monitor);
                GridEnvelope range = reader.getOriginalGridRange();
                GeneralEnvelope env = reader.getOriginalEnvelope();
                GridGeometry2D all = new GridGeometry2D(range, (Envelope)env);
                GridCoverage2D coverage2d = (GridCoverage2D)super.load((GeneralGridGeometry)all, monitor);
                RenderedImage image = coverage2d.view(ViewType.RENDERED).getRenderedImage();
                RasteringsPlugin.log((String)("WARNING.  Loading image fully into memory.  It is about " + this.size(image) + " MB in size decompressed"), null);
                BufferedImage bi = new BufferedImage(image.getColorModel(), (WritableRaster)image.getData(), false, new Hashtable());
                GridCoverageFactory fac = new GridCoverageFactory();
                GridCoverage2D c = fac.create((CharSequence)this.fileName, (RenderedImage)bi, (Envelope)env);
                this.coverage = new SoftReference<GridCoverage2D>(c);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                this.updateMemoryLevel();
            }
            catch (Exception exception) {
                this.updateMemoryLevel();
            }
        }
        return this.coverage.get();
    }

    private void updateMemoryLevel() throws IOException {
        int originalHeap = UiPlugin.getMaxHeapSize();
        int heap = originalHeap < 700 ? 1024 : (originalHeap < 1500 ? 2048 : originalHeap * 2);
        String os = Platform.getOS();
        if (heap > 1024 && os == "win32") {
            heap = 1024;
        }
        final int finalHeap = heap;
        this.coverage = new SoftReference<GridCoverage>(EMPTY_COVERAGE);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                String title = Messages.InMemoryCoverageLoader_msgTitle;
                String desc = MessageFormat.format(Messages.InMemoryCoverageLoader_message, InMemoryCoverageLoader.this.resource.getIdentifier(), finalHeap);
                String[] buttons = new String[]{Messages.InMemoryCoverageLoader_restart_button, Messages.InMemoryCoverageLoader_close_button};
                MessageDialog dialog = new MessageDialog(shell, title, null, desc, 3, buttons, 0){

                    protected void buttonPressed(int buttonId) {
                        if (buttonId == 0) {
                            try {
                                UiPlugin.setMaxHeapSize((String)String.valueOf(finalHeap));
                                PlatformUI.getWorkbench().restart();
                            }
                            catch (IOException e) {
                                throw (RuntimeException)new RuntimeException().initCause(e);
                            }
                        }
                        super.buttonPressed(buttonId);
                    }
                };
                dialog.open();
            }
        });
    }

    private double size(RenderedImage bi) {
        double bitPerPixel = 0.0;
        int[] nArray = bi.getColorModel().getComponentSize();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int elem = nArray[n2];
            bitPerPixel += (double)elem;
            ++n2;
        }
        double width = bi.getWidth();
        double height = bi.getHeight();
        double pixelNum = width * height;
        double bitsNum = pixelNum * bitPerPixel;
        double bytesNum = bitsNum / 8.0;
        double megNum = bytesNum / 1024.0;
        return megNum;
    }
}

