/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.rasterings;

import net.refractions.udig.catalog.ID;
import net.refractions.udig.catalog.IServiceInfo;
import net.refractions.udig.catalog.rasterings.AbstractRasterService;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.referencing.crs.DefaultEngineeringCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class AbstractRasterServiceInfo
extends IServiceInfo {
    private final AbstractRasterService service;
    private static double UNCACHED = -1.0;
    private double completeness = UNCACHED;

    public AbstractRasterServiceInfo(AbstractRasterService service, String ... keywords) {
        this.service = service;
        this.keywords = keywords;
    }

    public String getTitle() {
        ID id = this.service.getID();
        String title = id.isFile() ? id.toFile().getAbsolutePath() : id.toString();
        return title;
    }

    public String getShortTitle() {
        return this.service.getID().toFile().getName();
    }

    public String getDescription() {
        return this.service.getIdentifier().toString();
    }

    public double getMetric() {
        if (this.completeness != UNCACHED) {
            return this.completeness;
        }
        int numberOfAvailableInfoFields = 0;
        AbstractGridCoverage2DReader reader = null;
        try {
            GeneralEnvelope env;
            NullProgressMonitor monitor = new NullProgressMonitor();
            monitor.setTaskName("Checking availability of metadata for " + this.service.getTitle());
            reader = this.service.getReader((IProgressMonitor)monitor);
            CoordinateReferenceSystem CRS = reader.getCrs();
            if (!(CRS instanceof DefaultEngineeringCRS)) {
                ++numberOfAvailableInfoFields;
            }
            if (!((env = reader.getOriginalEnvelope()).isEmpty() || env.isNull() || env.isInfinite())) {
                ++numberOfAvailableInfoFields;
            }
            this.completeness = 2.0 / (double)numberOfAvailableInfoFields;
        }
        finally {
            reader.dispose();
        }
        return this.completeness;
    }
}

