/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.rasterings;

import java.awt.Rectangle;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.locks.Lock;
import net.refractions.udig.catalog.ID;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.catalog.IGeoResourceInfo;
import net.refractions.udig.catalog.IResolve;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.catalog.URLUtils;
import net.refractions.udig.catalog.rasterings.AbstractRasterGeoResourceInfo;
import net.refractions.udig.catalog.rasterings.AbstractRasterService;
import net.refractions.udig.catalog.rasterings.GridCoverageLoader;
import net.refractions.udig.catalog.rasterings.RasteringsPlugin;
import net.refractions.udig.catalog.rasterings.internal.Messages;
import net.refractions.udig.ui.ProgressManager;
import net.refractions.udig.ui.UDIGDisplaySafeLock;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.parameter.DefaultParameterDescriptor;
import org.geotools.parameter.DefaultParameterDescriptorGroup;
import org.geotools.parameter.ParameterGroup;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.styling.SLDParser;
import org.geotools.styling.Style;
import org.geotools.styling.StyleFactory;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.coverage.grid.GridGeometry;
import org.opengis.geometry.Envelope;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public abstract class AbstractRasterGeoResource
extends IGeoResource {
    private volatile SoftReference<GridCoverage> coverage;
    private ParameterGroup readParams;
    protected String fileName;
    private Throwable msg;
    protected Lock lock = new UDIGDisplaySafeLock();
    protected final ID id;

    public AbstractRasterGeoResource(AbstractRasterService service, String name) {
        this.service = service;
        if (name == null) {
            URL url = service.getIdentifier();
            File file = URLUtils.urlToFile((URL)url);
            int slash = (name = file.getAbsolutePath()).lastIndexOf(47);
            name = name.substring((slash == -1 && slash < name.length() - 1 ? 0 : name.lastIndexOf(47)) + 1, name.lastIndexOf(46) == -1 ? name.length() : name.lastIndexOf(46));
        }
        this.fileName = name;
        this.id = new ID(service.getID(), this.fileName);
    }

    public IResolve.Status getStatus() {
        return this.service.getStatus();
    }

    public Throwable getMessage() {
        if (this.msg != null) {
            return this.msg;
        }
        return this.service.getMessage();
    }

    public synchronized ParameterGroup getReadParameters() {
        if (this.readParams == null) {
            DefaultParameterDescriptor<GridGeometry> gridGeometryDescriptor = this.getWorldGridGeomDescriptor();
            HashMap<String, String> info1 = new HashMap<String, String>();
            info1.put("name", "Raster");
            info1.put("description", "A raster file accompanied by a spatial data file");
            info1.put("vendor", "Geotools");
            info1.put("docURL", "http://www.geotools.org/WorldImageReader+formats");
            info1.put("version", "1.0");
            this.readParams = new ParameterGroup((ParameterDescriptorGroup)new DefaultParameterDescriptorGroup(info1, new GeneralParameterDescriptor[]{gridGeometryDescriptor}));
        }
        return this.readParams;
    }

    public final synchronized Object findResource() throws IOException {
        this.lock.lock();
        try {
            if (this.coverage == null || this.coverage.get() == null) {
                try {
                    GridCoverage gridCoverage = this.loadCoverage();
                    this.coverage = new SoftReference<GridCoverage>(gridCoverage);
                }
                catch (Throwable t) {
                    this.msg = t;
                    RasteringsPlugin.log("error reading coverage", t);
                    this.lock.unlock();
                    return null;
                }
            }
            GridCoverage gridCoverage = this.coverage.get();
            return gridCoverage;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected GridCoverage loadCoverage() throws IOException {
        AbstractGridCoverage2DReader reader = this.service((IProgressMonitor)new NullProgressMonitor()).getReader(null);
        ParameterGroup pvg = this.getReadParameters();
        List list = pvg.values();
        GeneralParameterValue[] values = list.toArray(new GeneralParameterValue[0]);
        GridCoverage2D gridCoverage = reader.read(values);
        return gridCoverage;
    }

    public ID getID() {
        return this.id;
    }

    public URL getIdentifier() {
        return this.getID().toURL();
    }

    public <T> T resolve(Class<T> adaptee, IProgressMonitor monitor) throws IOException {
        if (monitor == null) {
            monitor = ProgressManager.instance().get(new Object[0]);
        }
        try {
            Style style;
            if (monitor != null) {
                monitor.beginTask(Messages.AbstractRasterGeoResource_resolve, 3);
            }
            if (adaptee == null) {
                return null;
            }
            if (adaptee.isAssignableFrom(GridCoverageLoader.class)) {
                T t = adaptee.cast(new GridCoverageLoader(this));
                return t;
            }
            if (adaptee.isAssignableFrom(AbstractGridCoverage2DReader.class)) {
                AbstractGridCoverage2DReader reader = this.service(monitor).getReader(monitor);
                T t = adaptee.cast(reader);
                return t;
            }
            if (adaptee.isAssignableFrom(GridCoverage.class)) {
                T t = adaptee.cast(this.findResource());
                return t;
            }
            if (adaptee.isAssignableFrom(GridCoverage2D.class)) {
                T t = adaptee.cast(this.findResource());
                return t;
            }
            if (adaptee.isAssignableFrom(IGeoResourceInfo.class)) {
                if (monitor != null) {
                    monitor.done();
                }
                T t = adaptee.cast((Object)this.createInfo(monitor));
                return t;
            }
            if (adaptee.isAssignableFrom(ParameterGroup.class)) {
                if (monitor != null) {
                    monitor.done();
                }
                T t = adaptee.cast(this.getReadParameters());
                return t;
            }
            if (adaptee.isAssignableFrom(Style.class) && (style = this.style(monitor)) != null) {
                T t = adaptee.cast(this.style(monitor));
                return t;
            }
            Object object = super.resolve(adaptee, monitor);
            return (T)object;
        }
        finally {
            monitor.done();
        }
    }

    public Style style(IProgressMonitor monitor) {
        URL url = this.service.getIdentifier();
        File file = URLUtils.urlToFile((URL)url);
        String mapFile = file.getAbsolutePath();
        StyleFactory styleFactory = CommonFactoryFinder.getStyleFactory((Hints)GeoTools.getDefaultHints());
        int lastdot = mapFile.lastIndexOf(46);
        String sld = String.valueOf(mapFile.substring(0, lastdot)) + ".sld";
        File f = new File(sld);
        if (!f.exists()) {
            sld = String.valueOf(mapFile.substring(0, lastdot)) + ".SLD";
            f = new File(sld);
        }
        if (f.exists()) {
            SLDParser parser = new SLDParser(styleFactory);
            try {
                parser.setInput(f);
            }
            catch (FileNotFoundException fileNotFoundException) {
                return null;
            }
            Style[] styles = parser.readXML();
            if (styles.length > 0 && styles[0] != null) {
                return styles[0];
            }
        }
        return null;
    }

    public <T> boolean canResolve(Class<T> adaptee) {
        if (adaptee == null) {
            return false;
        }
        return adaptee.isAssignableFrom(IGeoResourceInfo.class) || adaptee.isAssignableFrom(IService.class) || adaptee.isAssignableFrom(GridCoverage.class) || adaptee.isAssignableFrom(AbstractGridCoverage2DReader.class) || adaptee.isAssignableFrom(GridCoverageLoader.class) || adaptee.isAssignableFrom(Style.class) || super.canResolve(adaptee);
    }

    public AbstractRasterGeoResourceInfo getInfo(IProgressMonitor monitor) throws IOException {
        return (AbstractRasterGeoResourceInfo)super.getInfo(monitor);
    }

    protected abstract AbstractRasterGeoResourceInfo createInfo(IProgressMonitor var1) throws IOException;

    protected DefaultParameterDescriptor<GridGeometry> getWorldGridGeomDescriptor() {
        GridEnvelope2D gridRange = new GridEnvelope2D(new Rectangle(0, 0, 100, 100));
        ReferencedEnvelope env = new ReferencedEnvelope(-180.0, 180.0, -90.0, 90.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        GridGeometry2D world = new GridGeometry2D((GridEnvelope)gridRange, (Envelope)env);
        DefaultParameterDescriptor gridGeometryDescriptor = new DefaultParameterDescriptor(AbstractGridFormat.READ_GRIDGEOMETRY2D.getName().toString(), GridGeometry.class, null, (Object)world);
        return gridGeometryDescriptor;
    }

    public AbstractRasterService service(IProgressMonitor monitor) throws IOException {
        return (AbstractRasterService)super.service(monitor);
    }
}

