/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile.ng.files;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Arrays;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.DataUtilities;
import org.geotools.data.shapefile.ng.files.FileWriter;
import org.geotools.data.shapefile.ng.files.ShpFileType;
import org.geotools.data.shapefile.ng.files.ShpFiles;
import org.geotools.util.logging.Logging;

public final class StorageFile
implements Comparable<StorageFile>,
FileWriter {
    static final Logger LOGGER = Logging.getLogger((String)"org.geotools.data.shapefile");
    private final ShpFiles shpFiles;
    private final File tempFile;
    private final ShpFileType type;

    public StorageFile(ShpFiles shpFiles, File tempFile, ShpFileType type) {
        this.shpFiles = shpFiles;
        this.tempFile = tempFile;
        this.type = type;
    }

    public File getFile() {
        return this.tempFile;
    }

    public FileChannel getWriteChannel() throws IOException {
        return new RandomAccessFile(this.tempFile, "rw").getChannel();
    }

    public void replaceOriginal() throws IOException {
        StorageFile.replaceOriginals(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void replaceOriginals(StorageFile ... storageFiles) throws IOException {
        block14: {
            block12: {
                block13: {
                    files = new TreeSet<StorageFile>(Arrays.asList(storageFiles));
                    currentShpFiles = null;
                    shpURL = null;
                    locker = null;
                    try lbl-1000:
                    // 6 sources

                    {
                        for (StorageFile storageFile : files) {
                            if (currentShpFiles != storageFile.shpFiles) {
                                StorageFile.unlock(currentShpFiles, shpURL, locker);
                                locker = storageFile;
                                currentShpFiles = storageFile.shpFiles;
                                shpURL = currentShpFiles.acquireWrite(ShpFileType.SHP, storageFile);
                            }
                            storage = storageFile.getFile();
                            url = storageFile.getSrcURLForWrite();
                            dest = DataUtilities.urlToFile(url);
                            if (!storage.equals(dest)) break block12;
                            storageFile.unlockWriteURL(url);
                            if (storage.exists()) {
                                storage.delete();
                            }
                            break block13;
                        }
                        break block14;
                    }
                    catch (Throwable var11_11) {
                        StorageFile.unlock(currentShpFiles, shpURL, locker);
                        throw var11_11;
                    }
                }
                StorageFile.unlock(currentShpFiles, shpURL, locker);
                return;
            }
            ** try [egrp 3[TRYBLOCK] [1 : 145->293)] { 
lbl32:
            // 1 sources

            if (dest.exists() && !dest.delete()) {
                StorageFile.LOGGER.severe("Unable to delete the file: " + dest + " when attempting to replace with temporary copy.");
                if (storageFile.shpFiles.numberOfLocks() > 0) {
                    StorageFile.LOGGER.severe("The problem is almost certainly caused by the fact that there are still locks being held on the shapefiles.  Probably a reader or writer was left unclosed");
                    storageFile.shpFiles.logCurrentLockers(Level.SEVERE);
                }
            }
            if (!storage.exists() || storage.renameTo(dest)) ** GOTO lbl-1000
            StorageFile.LOGGER.finer("Unable to rename temporary file to the file: " + dest + " when attempting to replace with temporary copy");
            StorageFile.copyFile(storage, url, dest);
            if (storage.delete()) ** GOTO lbl-1000
            storage.deleteOnExit();
            ** GOTO lbl-1000
lbl43:
            // 1 sources

            finally {
                storageFile.unlockWriteURL(url);
                if (!storage.exists()) ** GOTO lbl-1000
                storage.delete();
                ** GOTO lbl-1000
            }
        }
        StorageFile.unlock(currentShpFiles, shpURL, locker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFile(File storage, URL url, File dest) throws FileNotFoundException, IOException {
        FileChannel in = null;
        AbstractInterruptibleChannel out = null;
        try {
            in = new FileInputStream(storage).getChannel();
            out = new FileOutputStream(dest).getChannel();
            int maxCount = 67076096;
            long size = in.size();
            for (long position = 0L; position < size; position += in.transferTo(position, maxCount, (WritableByteChannel)((Object)out))) {
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
        }
    }

    private URL getSrcURLForWrite() {
        return this.shpFiles.acquireWrite(this.type, this);
    }

    private void unlockWriteURL(URL url) {
        this.shpFiles.unlockWrite(url, (FileWriter)this);
    }

    private static void unlock(ShpFiles currentShpFiles, URL shpURL, StorageFile locker) {
        if (currentShpFiles == null) {
            return;
        }
        currentShpFiles.unlockWrite(shpURL, (FileWriter)locker);
    }

    @Override
    public int compareTo(StorageFile o) {
        if (this == o) {
            return 0;
        }
        return this.getFile().compareTo(o.getFile());
    }

    public String toString() {
        return this.id();
    }

    @Override
    public String id() {
        return this.getClass().getSimpleName() + ": " + this.tempFile.getName();
    }
}

