/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile.ng;

import com.vividsolutions.jts.geom.Envelope;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataUtilities;
import org.geotools.data.shapefile.ng.IdentifierComparator;
import org.geotools.data.shapefile.ng.ShapeFileIndexer;
import org.geotools.data.shapefile.ng.ShapefileDataStore;
import org.geotools.data.shapefile.ng.ShapefileDataStoreFactory;
import org.geotools.data.shapefile.ng.fid.FidIndexer;
import org.geotools.data.shapefile.ng.fid.IndexedFidReader;
import org.geotools.data.shapefile.ng.files.FileReader;
import org.geotools.data.shapefile.ng.files.FileWriter;
import org.geotools.data.shapefile.ng.files.ShpFileType;
import org.geotools.data.shapefile.ng.files.ShpFiles;
import org.geotools.data.shapefile.ng.index.CachedQuadTree;
import org.geotools.data.shapefile.ng.index.CloseableIterator;
import org.geotools.data.shapefile.ng.index.Data;
import org.geotools.data.shapefile.ng.index.DataDefinition;
import org.geotools.data.shapefile.ng.index.TreeException;
import org.geotools.data.shapefile.ng.index.quadtree.QuadTree;
import org.geotools.data.shapefile.ng.index.quadtree.StoreException;
import org.geotools.data.shapefile.ng.index.quadtree.fs.FileSystemIndexStore;
import org.geotools.data.shapefile.ng.shp.IndexFile;
import org.geotools.util.NullProgressListener;
import org.geotools.util.logging.Logging;
import org.opengis.filter.Id;
import org.opengis.filter.identity.Identifier;

class IndexManager {
    static final Logger LOGGER = Logging.getLogger(IndexManager.class);
    static final int DEFAULT_MAX_QIX_CACHE_SIZE;
    ShpFiles shpFiles;
    int maxQixCacheSize = DEFAULT_MAX_QIX_CACHE_SIZE;
    CachedQuadTree cachedTree;
    ShapefileDataStore store;
    FileWriter writer = new FileWriter(){

        @Override
        public String id() {
            return "ShapefileDataStore-" + IndexManager.this.store.getTypeName().getLocalPart();
        }
    };

    public IndexManager(ShpFiles shpFiles, ShapefileDataStore store) {
        this.shpFiles = shpFiles;
        this.store = store;
    }

    public boolean createSpatialIndex(boolean force) {
        try {
            if (this.shpFiles.isLocal() && (this.isIndexStale(ShpFileType.QIX) || force)) {
                ShapefileDataStoreFactory.LOGGER.fine("Creating spatial index for " + this.shpFiles.get(ShpFileType.SHP));
                ShapeFileIndexer indexer = new ShapeFileIndexer();
                indexer.setShapeFileName(this.shpFiles);
                indexer.index(false, new NullProgressListener());
                return true;
            }
        }
        catch (Throwable t) {
            ShapefileDataStoreFactory.LOGGER.log(Level.SEVERE, t.getLocalizedMessage(), t);
        }
        return false;
    }

    boolean hasFidIndex(boolean createIfMissing) {
        if (this.isIndexUseable(ShpFileType.FIX)) {
            return true;
        }
        if (this.shpFiles.isLocal() && (this.shpFiles.exists(ShpFileType.FIX) || createIfMissing)) {
            return this.createFidIndex();
        }
        return false;
    }

    public boolean createFidIndex() {
        try {
            FidIndexer.generate(this.shpFiles);
            return true;
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to create fid index");
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isIndexUseable(ShpFileType indexType) {
        if (this.shpFiles.isLocal()) {
            if (this.isIndexStale(indexType) || !this.shpFiles.exists(indexType)) {
                return false;
            }
        } else {
            ReadableByteChannel read = null;
            try {
                read = this.shpFiles.getReadChannel(indexType, this.writer);
            }
            catch (IOException e) {
                boolean bl = false;
                return bl;
            }
            finally {
                if (read != null) {
                    try {
                        read.close();
                    }
                    catch (IOException e) {
                        ShapefileDataStoreFactory.LOGGER.log(Level.WARNING, "could not close stream", e);
                    }
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isIndexStale(ShpFileType indexType) {
        if (!this.shpFiles.isLocal()) {
            throw new IllegalStateException("This method only applies if the files are local and the file can be created");
        }
        URL indexURL = this.shpFiles.acquireRead(indexType, this.writer);
        URL shpURL = this.shpFiles.acquireRead(ShpFileType.SHP, this.writer);
        try {
            long shpLastModified;
            if (indexURL == null) {
                boolean bl = true;
                return bl;
            }
            if (!this.shpFiles.exists(ShpFileType.SHX) || !this.shpFiles.exists(ShpFileType.SHP)) {
                boolean bl = false;
                return bl;
            }
            File indexFile = DataUtilities.urlToFile(indexURL);
            File shpFile = DataUtilities.urlToFile(shpURL);
            long indexLastModified = indexFile.lastModified();
            boolean shpChangedMoreRecently = indexLastModified < (shpLastModified = shpFile.lastModified());
            boolean bl = !indexFile.exists() || shpChangedMoreRecently;
            return bl;
        }
        finally {
            if (shpURL != null) {
                this.shpFiles.unlockRead(shpURL, (FileReader)this.writer);
            }
            if (indexURL != null) {
                this.shpFiles.unlockRead(indexURL, (FileReader)this.writer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    List<Data> queryFidIndex(Id fidFilter) throws IOException {
        TreeSet<Identifier> idsSet = new TreeSet<Identifier>(new IdentifierComparator(this.store.getTypeName().getLocalPart()));
        idsSet.addAll(fidFilter.getIdentifiers());
        IndexedFidReader reader = new IndexedFidReader(this.shpFiles);
        ArrayList<Data> records = new ArrayList<Data>(idsSet.size());
        try {
            IndexFile shx = this.store.shpManager.openIndexFile();
            try {
                DataDefinition def = new DataDefinition("US-ASCII");
                def.addField(Integer.class);
                def.addField(Long.class);
                for (Identifier identifier : idsSet) {
                    String fid = identifier.toString();
                    long recno = reader.findFid(fid);
                    if (recno == -1L) {
                        if (!LOGGER.isLoggable(Level.FINEST)) continue;
                        LOGGER.finest("fid " + fid + " not found in index, continuing with next queried fid...");
                        continue;
                    }
                    try {
                        Data data = new Data(def);
                        data.addValue(new Integer((int)recno + 1));
                        data.addValue(new Long(shx.getOffsetInBytes((int)recno)));
                        if (LOGGER.isLoggable(Level.FINEST)) {
                            LOGGER.finest("fid " + fid + " found for record #" + data.getValue(0) + " at index file offset " + data.getValue(1));
                        }
                        records.add(data);
                    }
                    catch (Exception e) {
                        IOException exception = new IOException();
                        exception.initCause(e);
                        throw exception;
                        return records;
                    }
                }
            }
            finally {
                shx.close();
            }
        }
        finally {
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CloseableIterator<Data> querySpatialIndex(Envelope bbox) throws DataSourceException, IOException, TreeException {
        CloseableIterator<Data> tmp = null;
        this.createSpatialIndex(false);
        if (this.cachedTree == null) {
            QuadTree quadTree;
            boolean canCache = false;
            URL treeURL = this.shpFiles.acquireRead(ShpFileType.QIX, this.writer);
            try {
                File treeFile = DataUtilities.urlToFile(treeURL);
                if (treeFile != null && treeFile.exists() && treeFile.length() < (long)(1024 * this.maxQixCacheSize)) {
                    canCache = true;
                }
            }
            finally {
                this.shpFiles.unlockRead(treeURL, (FileReader)this.writer);
            }
            if (canCache && (quadTree = this.openQuadTree()) != null) {
                LOGGER.warning("Experimental: loading in memory the quadtree for " + this.shpFiles.get(ShpFileType.SHP));
                this.cachedTree = new CachedQuadTree(quadTree);
                quadTree.close();
            }
        }
        if (this.cachedTree != null) {
            if (!bbox.contains(this.cachedTree.getBounds())) {
                return this.cachedTree.search(bbox);
            }
            return null;
        }
        try {
            QuadTree quadTree = this.openQuadTree();
            if (quadTree != null && !bbox.contains(quadTree.getRoot().getBounds())) {
                tmp = quadTree.search(bbox);
            }
            if (tmp == null && quadTree != null) {
                quadTree.close();
            }
        }
        catch (Exception e) {
            throw new DataSourceException("Error querying QuadTree", e);
        }
        return tmp;
    }

    protected QuadTree openQuadTree() throws StoreException {
        if (!this.shpFiles.isLocal()) {
            return null;
        }
        URL treeURL = this.shpFiles.acquireRead(ShpFileType.QIX, this.writer);
        try {
            File treeFile = DataUtilities.urlToFile(treeURL);
            if (!treeFile.exists() || treeFile.length() == 0L) {
                QuadTree quadTree = null;
                return quadTree;
            }
            FileSystemIndexStore idxStore = new FileSystemIndexStore(treeFile);
            QuadTree quadTree = idxStore.load(this.store.shpManager.openIndexFile(), this.store.isMemoryMapped());
            return quadTree;
        }
        finally {
            this.shpFiles.unlockRead(treeURL, (FileReader)this.writer);
        }
    }

    public void dispose() {
        this.cachedTree = null;
    }

    static {
        int max = -1;
        try {
            String smax = System.getProperty("org.geotools.shapefile.maxQixCacheSize");
            if (smax != null) {
                max = Integer.parseInt(smax);
            }
        }
        catch (Throwable t) {
            LOGGER.log(Level.SEVERE, "Could not set the max qix cache size", t);
        }
        DEFAULT_MAX_QIX_CACHE_SIZE = max;
    }
}

