/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.ui.workflow;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import net.refractions.udig.catalog.ui.CatalogUIPlugin;
import net.refractions.udig.catalog.ui.internal.Messages;
import net.refractions.udig.catalog.ui.workflow.State;
import net.refractions.udig.catalog.ui.workflow.Workflow;
import net.refractions.udig.catalog.ui.workflow.WorkflowWizardPage;
import net.refractions.udig.catalog.ui.workflow.WorkflowWizardPageProvider;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;

public class WorkflowWizard
extends Wizard {
    private Workflow workflow;
    private Map<Class<? extends State>, WorkflowWizardPageProvider> map;

    public WorkflowWizard(Workflow workflow, Map<Class<? extends State>, WorkflowWizardPageProvider> map) {
        this.workflow = workflow;
        this.map = map;
        this.setNeedsProgressMonitor(true);
    }

    public Workflow getWorkflow() {
        return this.workflow;
    }

    protected Map<Class<? extends State>, WorkflowWizardPageProvider> getStateMap() {
        return this.map;
    }

    public void addPages() {
        State[] states = this.workflow.getStates();
        if (states == null || states.length == 0) {
            throw new IllegalStateException(Messages.WorkflowWizard_noStates);
        }
        int i = 0;
        while (i < states.length) {
            State state = states[i];
            WorkflowWizardPage page = this.getPage(state);
            if (page == null) {
                String msg = Messages.WorkflowWizard_noPage;
                throw new IllegalStateException(msg);
            }
            page.setState(state);
            this.addPage((IWizardPage)page);
            ++i;
        }
    }

    public IWizardPage getNextPage(IWizardPage page) {
        State state = this.workflow.getCurrentState();
        if (state == null) {
            return null;
        }
        WorkflowWizardPage next = this.getPage(state);
        if (next == null) {
            String msg = Messages.WorkflowWizard_noPage;
            throw new IllegalStateException(msg);
        }
        next.setState(this.workflow.getCurrentState());
        return next;
    }

    public WorkflowWizardPage getPage(State state) {
        if (state == null) {
            return null;
        }
        Class<?> stateClass = state.getClass();
        WorkflowWizardPageProvider workflowWizardPageProvider = this.map.get(stateClass);
        WorkflowWizardPage page = workflowWizardPageProvider.getWorkflowWizardPage(state);
        this.init((IWizardPage)page);
        return page;
    }

    void init(IWizardPage page) {
        if (page.getWizard() != this) {
            page.setWizard((IWizard)this);
        }
    }

    private boolean isPageComplete() {
        State state = this.workflow.getCurrentState();
        if (state == null) {
            return false;
        }
        WorkflowWizardPage current = this.getPage(state);
        return current.isPageComplete();
    }

    public boolean canFinish() {
        return this.isPageComplete() && (this.workflow.dryRun() || !this.workflow.hasMoreStates());
    }

    public final boolean performFinish() {
        final boolean[] finished = new boolean[1];
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                finished[0] = WorkflowWizard.this.performFinish(monitor);
            }
        };
        try {
            this.run(runnable);
        }
        catch (NullPointerException e) {
            if (CatalogUIPlugin.getDefault().isDebugging()) {
                String name = this.getWindowTitle();
                State state = this.workflow.getCurrentState();
                if (state != null && state.getName() != null) {
                    name = state.getName();
                }
                CatalogUIPlugin.log(String.valueOf(name) + " could not finish.", e);
            }
        }
        catch (Exception e) {
            if (CatalogUIPlugin.getDefault().isDebugging()) {
                String name = this.getWindowTitle();
                State state = this.workflow.getCurrentState();
                if (state != null && state.getName() != null) {
                    name = state.getName();
                }
                CatalogUIPlugin.log(String.valueOf(name) + " could not finish:" + e, e);
            }
            return false;
        }
        return finished[0];
    }

    private void run(final IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
        IWizardContainer wizardContainer = this.getContainer();
        if (wizardContainer != null && Display.getCurrent() != null) {
            wizardContainer.run(false, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    runnable.run(monitor);
                }
            });
        } else {
            runnable.run((IProgressMonitor)new NullProgressMonitor());
        }
    }

    protected boolean performFinish(IProgressMonitor monitor) {
        return true;
    }

    public boolean needsPreviousAndNextButtons() {
        return true;
    }
}

