/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.ui.workflow;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.refractions.udig.catalog.CatalogPlugin;
import net.refractions.udig.catalog.ICatalog;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.catalog.IResolve;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.catalog.IServiceFactory;
import net.refractions.udig.catalog.ui.UDIGConnectionFactory;
import net.refractions.udig.catalog.ui.UDIGConnectionFactoryDescriptor;
import net.refractions.udig.catalog.ui.internal.Messages;
import net.refractions.udig.catalog.ui.workflow.ConnectionErrorState;
import net.refractions.udig.catalog.ui.workflow.State;
import net.refractions.udig.core.Pair;
import net.refractions.udig.ui.PlatformGIS;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;

public class EndConnectionState
extends State {
    UDIGConnectionFactoryDescriptor descriptor;
    UDIGConnectionFactory factory;
    Map<IService, Throwable> errors;
    Collection<IService> services = new HashSet<IService>();
    EndConnectionState nextState;
    private boolean validateServices;
    private Collection<URL> selectedResources;

    public EndConnectionState(UDIGConnectionFactoryDescriptor descriptor, boolean validateServices) {
        this.descriptor = descriptor;
        this.factory = descriptor.getConnectionFactory();
        this.validateServices = validateServices;
    }

    @Override
    public void init(IProgressMonitor monitor) throws IOException {
        super.init(monitor);
        this.disposeOldServices(monitor);
    }

    @Override
    public Pair<Boolean, State> dryRun() {
        boolean hasServices = !this.services.isEmpty();
        return new Pair((Object)hasServices, null);
    }

    @Override
    public boolean run(IProgressMonitor monitor) throws IOException {
        block9: {
            List availableServices;
            Map<String, Serializable> params;
            ICatalog catalog;
            block11: {
                URL url;
                block10: {
                    if (this.factory == null) {
                        return false;
                    }
                    if (!this.services.isEmpty()) {
                        return true;
                    }
                    catalog = CatalogPlugin.getDefault().getLocalCatalog();
                    monitor.beginTask(Messages.ConnectionState_task, -1);
                    this.errors = null;
                    try {
                        Object context = this.getWorkflow().getContext();
                        if (context instanceof IService) {
                            this.services.add((IService)context);
                            break block9;
                        }
                        if (context instanceof IGeoResource) {
                            IService service = ((IGeoResource)context).service(monitor);
                            this.services.add((IService)context);
                            this.services.add(service);
                            break block9;
                        }
                        params = this.factory.createConnectionParameters(context);
                        url = this.factory.createConnectionURL(context);
                        if (params != null || url != null) break block10;
                        return false;
                    }
                    catch (Throwable t) {
                        CatalogPlugin.log((String)t.getLocalizedMessage(), (Throwable)t);
                        return false;
                    }
                }
                if (url == null || (availableServices = catalog.constructServices(url, monitor)).isEmpty()) break block11;
                this.services.add((IService)availableServices.iterator().next());
                return true;
            }
            if (params != null && !params.isEmpty() && !(availableServices = catalog.constructServices(params, monitor)).isEmpty()) {
                this.services.add((IService)availableServices.iterator().next());
            }
        }
        return this.errors == null || this.errors.isEmpty();
    }

    private void disposeOldServices(IProgressMonitor monitor) {
        if (this.services == null || this.services.isEmpty()) {
            return;
        }
        final ArrayList<IService> toDispose = new ArrayList<IService>(this.services);
        this.services.clear();
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                monitor.beginTask("Disposing dereferenced services", toDispose.size());
                for (IService service : toDispose) {
                    if (service.parent(monitor) == null) {
                        service.dispose((IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor));
                    }
                    monitor.worked(1);
                }
            }
        };
        if (Display.getCurrent() != null) {
            PlatformGIS.run((IRunnableWithProgress)runnable);
        } else {
            try {
                runnable.run((IProgressMonitor)new NullProgressMonitor());
            }
            catch (InvocationTargetException e) {
                throw (RuntimeException)new RuntimeException().initCause(e);
            }
            catch (InterruptedException e) {
                throw (RuntimeException)new RuntimeException().initCause(e);
            }
        }
    }

    @Deprecated
    public static Collection<IService> constructServices(IProgressMonitor monitor, Map<String, Serializable> params, Collection<URL> urls) {
        IServiceFactory sFactory = CatalogPlugin.getDefault().getServiceFactory();
        monitor.setTaskName(Messages.ConnectionState_task);
        HashSet<IService> services = new HashSet<IService>();
        if (urls != null && !urls.isEmpty()) {
            for (URL url : urls) {
                Collection<IService> searchResult = EndConnectionState.searchLocalCatalog(url, monitor);
                if (searchResult.isEmpty()) {
                    List created = sFactory.createService(url);
                    services.addAll(created);
                    continue;
                }
                services.addAll(searchResult);
            }
        }
        if (params != null && !params.isEmpty()) {
            HashSet results = new HashSet(sFactory.createService(params));
            for (IService service : results) {
                Collection<IService> searchResult = EndConnectionState.searchLocalCatalog(service.getIdentifier(), monitor);
                if (searchResult.isEmpty()) {
                    services.add(service);
                    continue;
                }
                services.addAll(searchResult);
            }
        }
        return services;
    }

    private static Collection<IService> searchLocalCatalog(URL url, IProgressMonitor monitor) {
        ICatalog localCatalog = CatalogPlugin.getDefault().getLocalCatalog();
        List resolves = localCatalog.find(url, monitor);
        ArrayList<IService> services = new ArrayList<IService>();
        for (IResolve iResolve : resolves) {
            if (!(iResolve instanceof IService)) continue;
            IService service = (IService)iResolve;
            services.add(service);
        }
        return services;
    }

    private String formatServiceID(IService service) {
        URL identifier = service.getIdentifier();
        if ("file".equals(identifier.getProtocol())) {
            File file = new File(identifier.getFile());
            return file.getName();
        }
        String host = identifier.getHost();
        return host;
    }

    @Override
    public boolean hasNext() {
        return this.errors != null && !this.errors.isEmpty() || this.nextState != null;
    }

    @Override
    public State next() {
        if ((this.errors == null || this.errors.isEmpty()) && this.nextState == null) {
            return null;
        }
        if (this.errors != null && !this.errors.isEmpty()) {
            return new ConnectionErrorState(this.errors);
        }
        return this.nextState;
    }

    public UDIGConnectionFactoryDescriptor getDescriptor() {
        return this.descriptor;
    }

    public UDIGConnectionFactory getConnectionFactory() {
        return this.factory;
    }

    public Collection<IService> getServices() {
        return this.services;
    }

    @Override
    public String getName() {
        return Messages.ConnectionState_name;
    }

    public boolean isValidateState() {
        return this.validateServices;
    }

    public void setValidateState(boolean validateState) {
        this.validateServices = validateState;
    }

    public Map<IService, Throwable> getErrors() {
        if (this.errors == null) {
            return Collections.emptyMap();
        }
        return this.errors;
    }

    public void setNextState(EndConnectionState state) {
        this.nextState = state;
    }

    public void setSelectedResources(Collection<URL> resourceIDs) {
        this.selectedResources = new ArrayList<URL>(resourceIDs);
    }

    public Collection<URL> getSelectedResources() {
        if (this.selectedResources == null) {
            return Collections.emptyList();
        }
        return this.selectedResources;
    }

    public void setServices(Collection<IService> services2) {
        this.disposeOldServices((IProgressMonitor)new NullProgressMonitor());
        this.services.addAll(services2);
    }
}

