/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.ui.workflow;

import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.refractions.udig.catalog.ServiceExtension;
import net.refractions.udig.catalog.ServiceExtension2;
import net.refractions.udig.catalog.ui.internal.Messages;
import net.refractions.udig.catalog.ui.workflow.State;
import net.refractions.udig.core.Pair;
import net.refractions.udig.core.internal.ExtensionPointList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;

public class ConnectionFailureState
extends State {
    private Map<String, Serializable> params;
    private List<URL> urls;
    private Map<String, List<Data>> reports = new HashMap<String, List<Data>>();

    public ConnectionFailureState(List<URL> urls, Map<String, Serializable> params) {
        if (params == null) {
            this.urls = urls;
            if (urls != null && urls.isEmpty()) {
                this.urls = null;
            }
        } else {
            this.params = params;
        }
    }

    @Override
    public String getName() {
        return Messages.ConnectionFailureState_name;
    }

    public Map<String, Serializable> getParams() {
        return this.params;
    }

    public List<URL> getUrls() {
        return this.urls;
    }

    public Map<String, List<Data>> getReports() {
        return this.reports;
    }

    @Override
    public void init(IProgressMonitor monitor) throws IOException {
        if (this.params == null && this.urls == null) {
            this.reports.put("msg", Collections.singletonList(new Data("msg", "No Connection Information", "For some reason the previous wizard page did not")));
            return;
        }
        List list = ExtensionPointList.getExtensionPointList((String)"net.refractions.udig.catalog.ServiceExtension");
        for (IConfigurationElement element : list) {
            ArrayList<Data> data = new ArrayList<Data>();
            String id = String.valueOf(element.getNamespaceIdentifier().toString()) + "." + element.getAttribute("id");
            String name = element.getAttribute("name");
            if (name == null) {
                name = element.getAttribute("id");
            }
            try {
                ServiceExtension extension = (ServiceExtension)element.createExecutableExtension("class");
                if (extension instanceof ServiceExtension2) {
                    ServiceExtension2 e2 = (ServiceExtension2)extension;
                    if (this.params != null) {
                        data.add(new Data(id, name, e2.reasonForFailure(this.params)));
                    } else {
                        for (URL url : this.urls) {
                            data.add(new Data(id, name, e2.reasonForFailure(url), url));
                        }
                    }
                }
                if (data.isEmpty()) {
                    data.add(new Data(id, name, "Implementation does not provide any debug information"));
                }
            }
            catch (Throwable e) {
                data.add(new Data(id, name, e.getLocalizedMessage()));
            }
            this.reports.put(id, data);
        }
    }

    @Override
    public Pair<Boolean, State> dryRun() {
        return new Pair((Object)false, null);
    }

    @Override
    public boolean run(IProgressMonitor monitor) throws IOException {
        return false;
    }

    class Data {
        String message;
        String name;
        URL url;
        String id;

        public Data(String id, String name, String message) {
            if (id == null) {
                throw new NullPointerException();
            }
            if (name == null) {
                throw new NullPointerException();
            }
            this.name = name;
            this.message = message;
            this.id = id;
        }

        public Data(String id, String name2, String string, URL url) {
            this(id, name2, string);
            if (url == null) {
                throw new NullPointerException();
            }
            this.url = url;
        }
    }
}

