/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.ui.workflow;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.catalog.ui.IConnectionErrorHandler;
import net.refractions.udig.catalog.ui.internal.Messages;
import net.refractions.udig.catalog.ui.workflow.ConnectionErrorHandlerProcessor;
import net.refractions.udig.catalog.ui.workflow.State;
import net.refractions.udig.core.Pair;
import org.eclipse.core.runtime.IProgressMonitor;

public class ConnectionErrorState
extends State {
    Map<IService, Throwable> errors;
    Map<IService, List<IConnectionErrorHandler>> handlers;

    public ConnectionErrorState(Map<IService, Throwable> errors) {
        this.errors = errors;
    }

    @Override
    public Pair<Boolean, State> dryRun() {
        return new Pair((Object)false, null);
    }

    @Override
    public void init(IProgressMonitor monitor) throws IOException {
        super.init(monitor);
        ConnectionErrorHandlerProcessor p = new ConnectionErrorHandlerProcessor();
        this.handlers = new HashMap<IService, List<IConnectionErrorHandler>>();
        for (Map.Entry<IService, Throwable> e : this.errors.entrySet()) {
            List<IConnectionErrorHandler> l = p.process(e.getKey(), e.getValue());
            if (l == null || l.isEmpty()) continue;
            this.handlers.put(e.getKey(), l);
        }
    }

    @Override
    public boolean run(IProgressMonitor monitor) throws IOException {
        monitor.beginTask(this.getName(), 1);
        monitor.done();
        return false;
    }

    @Override
    public boolean hasNext() {
        return true;
    }

    @Override
    public State next() {
        return this.getPreviousState();
    }

    public Map<IService, List<IConnectionErrorHandler>> getHandlers() {
        return this.handlers;
    }

    public Map<IService, Throwable> getErrors() {
        return this.errors;
    }

    @Override
    public String getName() {
        return Messages.ConnectionErrorState_error_name;
    }
}

