/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.ui.search;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.refractions.udig.catalog.CatalogPlugin;
import net.refractions.udig.catalog.IResolve;
import net.refractions.udig.catalog.ISearch;
import net.refractions.udig.catalog.ui.ResolveContentProvider;
import net.refractions.udig.catalog.ui.ResolveLabelProviderSimple;
import net.refractions.udig.catalog.ui.ResolveTitlesDecorator;
import net.refractions.udig.ui.PlatformGIS;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.geotools.data.FeatureSource;
import org.geotools.geometry.jts.ReferencedEnvelope;

public class ResourceSearchComposite
extends Composite
implements ISelectionProvider {
    private Text text;
    private List<ISearch> catalogs;
    private TreeViewer treeViewer;
    private static final long DELAY = 500L;
    private KeyAdapter keyListener = new KeyAdapter(){

        public void keyReleased(KeyEvent e) {
            ResourceSearchComposite.this.doSearch(500L);
        }
    };
    private SelectionListener selectionListener = new SelectionAdapter(){

        public void widgetDefaultSelected(SelectionEvent e) {
            ResourceSearchComposite.this.doSearch(0L);
        }
    };
    SearchJob search = new SearchJob();

    public ResourceSearchComposite(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(1, false));
        Label hintLabel = new Label((Composite)this, 0);
        hintLabel.setText("Start typing in search term");
        this.text = new Text((Composite)this, 2688);
        this.text.addKeyListener((KeyListener)this.keyListener);
        this.text.addSelectionListener(this.selectionListener);
        this.text.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.treeViewer = new TreeViewer((Composite)this, 2050);
        Tree tree = this.treeViewer.getTree();
        tree.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.treeViewer.setContentProvider((IContentProvider)this.createContentProvider());
        this.treeViewer.setLabelProvider(this.createLabelProvider());
        this.catalogs = Arrays.asList(CatalogPlugin.getDefault().getCatalogs());
    }

    public Control getControl() {
        return this.treeViewer != null ? this.treeViewer.getControl() : null;
    }

    public IStructuredSelection getSelection() {
        return (IStructuredSelection)this.treeViewer.getSelection();
    }

    public void setSelection(ISelection selection) {
        this.treeViewer.setSelection(selection);
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.treeViewer.addSelectionChangedListener(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.treeViewer.removeSelectionChangedListener(listener);
    }

    public void setSearchText(final String search) {
        PlatformGIS.asyncInDisplayThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (ResourceSearchComposite.this.text != null && !ResourceSearchComposite.this.text.isDisposed()) {
                    ResourceSearchComposite.this.text.setText(search != null ? search : "");
                    ResourceSearchComposite.this.doSearch(0L);
                }
            }
        }, (boolean)true);
    }

    public String getSearchText() {
        if (this.text != null && !this.text.isDisposed()) {
            return this.text.getText();
        }
        return null;
    }

    protected IBaseLabelProvider createLabelProvider() {
        ResolveLabelProviderSimple base = new ResolveLabelProviderSimple();
        return new DecoratingLabelProvider((ILabelProvider)base, (ILabelDecorator)new ResolveTitlesDecorator(base));
    }

    protected IStructuredContentProvider createContentProvider() {
        return new ResolveContentProvider();
    }

    protected void doSearch(long delay) {
        String searchText;
        if (this.search.getState() == 4) {
            this.search.cancel();
        }
        if (!(searchText = this.text.getText()).isEmpty()) {
            this.search.setSearchText(searchText);
            this.search.schedule(delay);
        } else {
            ArrayList<IResolve> empty = new ArrayList<IResolve>();
            this.doSearchCallback(empty);
        }
    }

    protected void doSearchCallback(final List<IResolve> resolves) {
        this.reviewResults(resolves);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                ResourceSearchComposite.this.treeViewer.setInput((Object)resolves);
            }
        });
    }

    protected void reviewResults(List<IResolve> resolves) {
    }

    class SearchJob
    extends Job {
        private String searchText;
        private ReferencedEnvelope bounds;

        public SearchJob() {
            super("Search Catalog");
            this.bounds = new ReferencedEnvelope();
        }

        public String getSearchText() {
            return this.searchText;
        }

        public void setSearchText(String searchText) {
            this.searchText = searchText;
        }

        public ReferencedEnvelope getBounds() {
            return this.bounds;
        }

        public void setBounds(ReferencedEnvelope bounds) {
            this.bounds = bounds;
        }

        protected IStatus run(IProgressMonitor monitor) {
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            try {
                monitor.beginTask("Seaching for " + this.searchText, ResourceSearchComposite.this.catalogs.size() * 100);
                CopyOnWriteArrayList<IResolve> resolves = new CopyOnWriteArrayList<IResolve>();
                for (ISearch search : ResourceSearchComposite.this.catalogs) {
                    try {
                        monitor.subTask("Search " + search.getTitle() + " for " + this.searchText);
                        List searchResults = search.search(this.searchText, (Envelope)this.bounds, null);
                        monitor.worked(10);
                        new SubProgressMonitor(monitor, 10, 4);
                        for (IResolve member : searchResults) {
                            if (!member.canResolve(FeatureSource.class)) continue;
                            resolves.add(member);
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                ResourceSearchComposite.this.doSearchCallback(resolves);
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            catch (Exception e) {
                Status failure;
                String message = "Unable to complete search for '" + this.searchText + "':" + e;
                Status status = failure = new Status(4, "net.refractions.udig.catalog.ui", message, (Throwable)e);
                return status;
            }
            finally {
                monitor.done();
            }
        }
    }
}

