/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.ui.preferences;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import net.refractions.udig.catalog.ui.CatalogUIPlugin;
import net.refractions.udig.catalog.ui.internal.Messages;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractProprietaryJarPreferencePage
extends PreferencePage {
    private Color red;
    private Color black;
    private Listener listener;
    private Shell shell;
    private UI[] ui;

    private File getFile(String name, boolean backup) {
        URL localURL;
        URL url = this.getLibsURL();
        if (url == null) {
            return new File("RandomCrazyPlaceholderlkjaljflkasdjfkjlkjasdfiwjkl");
        }
        try {
            localURL = FileLocator.toFileURL((URL)url);
        }
        catch (IOException iOException) {
            return new File("RandomCrazyPlaceholderlkjaljflkasdjfkjlkjasdfiwjkl");
        }
        String prefix = backup ? "." : "";
        File destDriver = new File(String.valueOf(localURL.getFile()) + prefix + name);
        return destDriver;
    }

    protected abstract URL getLibsURL();

    protected abstract boolean installed();

    protected Control createContents(Composite parent) {
        this.shell = parent.getShell();
        Composite comp = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginBottom = 0;
        layout.marginTop = 0;
        layout.marginRight = 0;
        layout.marginLeft = 0;
        comp.setLayout((Layout)layout);
        this.ui = new UI[this.getRequiredJarsCount()];
        ArrayList<Object> tablist = new ArrayList<Object>();
        int i = 0;
        while (i < this.ui.length) {
            this.ui[i] = this.createJDBCdriverUI(this.getDefaultJarName(i), this.getDriverLabel(i), comp, null);
            tablist.add(this.ui[i].input);
            tablist.add(this.ui[i].browse);
            ++i;
        }
        comp.setTabList(tablist.toArray(new Control[0]));
        return comp;
    }

    protected abstract int getRequiredJarsCount();

    protected abstract String getDriverLabel(int var1);

    protected abstract String getDefaultJarName(int var1);

    public AbstractProprietaryJarPreferencePage() {
    }

    private UI createJDBCdriverUI(String jar_name, String label, final Composite comp, Control above) {
        final UI ui = new UI(jar_name);
        ui.label = new Label(comp, 0x800000);
        ui.label.setText(label);
        GridData layoutData = new GridData(16384, 0x1000000, false, false);
        ui.label.setLayoutData((Object)layoutData);
        ui.input = new Text(comp, 2052);
        ui.input.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                File srcDriver = new File(ui.input.getText());
                if (AbstractProprietaryJarPreferencePage.this.installed()) {
                    AbstractProprietaryJarPreferencePage.this.acceptance(Messages.DependencyQueryPreferencePage_fileExists, ui.input);
                } else if (!srcDriver.exists()) {
                    AbstractProprietaryJarPreferencePage.this.error(Messages.DependencyQueryPreferencePage_fileNotFound, ui.input);
                } else {
                    AbstractProprietaryJarPreferencePage.this.error(Messages.DependencyQueryPreferencePage_notValid, ui.input);
                }
            }
        });
        String storedValue = this.getPreferenceStore().getString(ui.jar_name);
        if (storedValue.trim().length() == 0) {
            storedValue = null;
        }
        ui.input.setText(storedValue == null ? ui.jar_name : storedValue);
        layoutData = new GridData(4, 0x1000000, true, false);
        ui.input.setLayoutData((Object)layoutData);
        ui.browse = new Button(comp, 8);
        ui.browse.setText(Messages.DependencyQueryPreferencePage_browse);
        ui.browse.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                FileDialog fileDialog = new FileDialog(comp.getShell(), 4096);
                fileDialog.setFilterExtensions(new String[]{"*.jar"});
                fileDialog.setFilterNames(new String[]{Messages.DependencyQueryPreferencePage_archive});
                String result = fileDialog.open();
                if (result != null) {
                    ui.input.setText(result);
                }
            }
        });
        layoutData = new GridData(131072, 0x1000000, false, false);
        ui.browse.setLayoutData((Object)layoutData);
        return ui;
    }

    public void performDefaults() {
        UI[] uIArray = this.ui;
        int n = this.ui.length;
        int n2 = 0;
        while (n2 < n) {
            UI ui = uIArray[n2];
            if (ui.input != null) {
                ui.input.setText(ui.jar_name);
            }
            ++n2;
        }
        super.performDefaults();
        if (this.listener != null) {
            this.listener.handleEvent(null);
        }
    }

    public boolean performOk() {
        boolean restart;
        UI[] uIArray = this.ui;
        int n = this.ui.length;
        int n2 = 0;
        while (n2 < n) {
            UI current = uIArray[n2];
            if (current.input.getText().trim().length() > 0) {
                File srcDriver;
                block10: {
                    block11: {
                        srcDriver = null;
                        try {
                            srcDriver = new File(current.input.getText());
                            if (srcDriver.exists()) break block10;
                            if (!current.input.getText().equals(current.jar_name)) break block11;
                            return true;
                        }
                        catch (Exception exception) {
                            this.error(Messages.DependencyQueryPreferencePage_copyError, current.input);
                            return false;
                        }
                    }
                    this.error(Messages.DependencyQueryPreferencePage_fileNotFound, current.input);
                    return false;
                }
                try {
                    File destDriver = this.getFile(current.jar_name, false);
                    if (destDriver != null) {
                        this.renameFile(destDriver, "." + destDriver.getName(), false);
                        destDriver.createNewFile();
                        this.copyfile(srcDriver, destDriver);
                    }
                }
                catch (Exception exception) {
                    this.error(Messages.DependencyQueryPreferencePage_copyError, current.input);
                    return false;
                }
                this.getPreferenceStore().putValue(current.jar_name, current.input.getText());
            }
            ++n2;
        }
        if (this.listener != null) {
            this.listener.handleEvent(null);
        }
        if (restart = MessageDialog.openQuestion((Shell)this.getShell(), (String)Messages.DependencyQueryPreferencePage_restartTitle, (String)(String.valueOf(Messages.DependencyQueryPreferencePage_restartNeeded) + Messages.DependencyQueryPreferencePage_restartQuestion))) {
            PlatformUI.getWorkbench().restart();
        }
        return true;
    }

    public Shell getShell() {
        return this.shell;
    }

    public AbstractProprietaryJarPreferencePage(String title) {
        super(title);
    }

    private void renameFile(File flag, String newname, boolean deleteOnFail) {
        block6: {
            if (flag != null) {
                File dest = new File(flag.getParentFile(), newname);
                try {
                    if (dest.exists()) {
                        dest.delete();
                    }
                    flag.renameTo(dest);
                }
                catch (Exception exception) {
                    try {
                        this.copyfile(flag, dest);
                    }
                    catch (IOException e1) {
                        CatalogUIPlugin.log("error renaming flag", e1);
                        if (!deleteOnFail) break block6;
                        flag.delete();
                    }
                }
            }
        }
    }

    private void copyfile(File src, File dest) throws IOException {
        FileChannel srcChannel = null;
        FileChannel dstChannel = null;
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            fileInputStream = new FileInputStream(src);
            fileOutputStream = new FileOutputStream(dest);
            srcChannel = fileInputStream.getChannel();
            dstChannel = fileOutputStream.getChannel();
            dstChannel.transferFrom(srcChannel, 0L, srcChannel.size());
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException e) {
                CatalogUIPlugin.log("", e);
            }
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException e) {
                CatalogUIPlugin.log("", e);
            }
            try {
                if (srcChannel != null) {
                    srcChannel.close();
                }
            }
            catch (IOException e) {
                CatalogUIPlugin.log("", e);
            }
            try {
                if (dstChannel != null) {
                    dstChannel.close();
                }
            }
            catch (IOException e) {
                CatalogUIPlugin.log("", e);
            }
        }
    }

    private void error(String message, Text field) {
        this.setMessage(message, 2);
        field.setForeground(this.getRed());
        field.setToolTipText(message);
    }

    private void acceptance(String message, Text field) {
        this.setMessage(null, 2);
        field.setForeground(this.getBlack());
        field.setToolTipText(message);
    }

    private Color getRed() {
        if (this.red == null) {
            this.red = new Color((Device)this.getShell().getDisplay(), 255, 0, 0);
        }
        return this.red;
    }

    private Color getBlack() {
        if (this.black == null) {
            this.black = new Color((Device)this.getShell().getDisplay(), 0, 0, 0);
        }
        return this.black;
    }

    public void dispose() {
        super.dispose();
        if (this.red != null) {
            this.red.dispose();
            this.red = null;
        }
        if (this.black != null) {
            this.black.dispose();
            this.black = null;
        }
    }

    public void init(IWorkbench workbench) {
    }

    public void setListener(Listener listener) {
        this.listener = listener;
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return PlatformUI.getPreferenceStore();
    }

    public AbstractProprietaryJarPreferencePage(String title, ImageDescriptor desc) {
        super(title, desc);
    }

    protected static class UI {
        public String jar_name;
        public Label label;
        public Text input;
        public Button browse;

        protected UI(String jar_name) {
            this.jar_name = jar_name;
        }
    }
}

