/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.ui.operation;

import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.miginfocom.swt.MigLayout;
import net.refractions.udig.internal.ui.UDigByteAndLocalTransfer;
import net.refractions.udig.ui.filter.ExpressionInput;
import net.refractions.udig.ui.filter.ExpressionViewer;
import net.refractions.udig.ui.filter.IExpressionViewer;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.text.ecql.ECQL;
import org.geotools.process.vector.TransformProcess;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;

public class TransformPanel
extends Composite {
    public static final String MODIFY = "Modify";
    public static final String ORDER = "Order";
    private static final String NO_CONTENT = "--";
    private List<TransformProcess.Definition> transform;
    private ControlDecoration feedbackDecorator;
    private SimpleFeature sample;
    private Text name;
    private IExpressionViewer expression;
    private SimpleFeatureType schema;
    private Composite composite;
    private ListenerList changedListeners = new ListenerList();
    private TableViewer table;
    private ModifyListener nameListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            TransformProcess.Definition definition = TransformPanel.this.selectedDefinition();
            if (definition != null) {
                String text = TransformPanel.this.name.getText();
                if (definition.name == null || !definition.name.equals(text)) {
                    definition.name = text;
                }
            }
            TransformPanel.this.table.refresh((Object)definition, true, true);
            TransformPanel.this.fireChanged(new ChangeEvent(TransformPanel.this.transform));
        }
    };
    private ISelectionChangedListener expressionListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            TransformProcess.Definition definition = TransformPanel.this.selectedDefinition();
            Expression expr = TransformPanel.this.expression.getExpression();
            if (definition.expression == null || !definition.equals(expr)) {
                definition.expression = expr;
                try {
                    Object value = definition.expression.evaluate((Object)TransformPanel.this.sample);
                    definition.binding = value.getClass();
                }
                catch (Throwable throwable) {
                    definition.binding = null;
                }
                TransformPanel.this.table.refresh((Object)definition, true, true);
            }
        }
    };
    private ISelectionChangedListener tableListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            TransformProcess.Definition definition = TransformPanel.this.selectedDefinition();
            TransformPanel.this.listen(false);
            try {
                if (definition == null) {
                    TransformPanel.this.name.setText("");
                    TransformPanel.this.expression.setExpression(Expression.NIL);
                    TransformPanel.this.enable(false);
                } else {
                    TransformPanel.this.name.setText(definition.name);
                    TransformPanel.this.expression.setExpression(definition.expression);
                    TransformPanel.this.enable(true);
                }
            }
            finally {
                TransformPanel.this.listen(true);
            }
        }
    };
    private Label definitionLabel;

    static List<TransformProcess.Definition> createDefaultTransformDefinition(SimpleFeatureType featureType) {
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2();
        ArrayList<TransformProcess.Definition> list = new ArrayList<TransformProcess.Definition>();
        if (featureType != null) {
            for (AttributeDescriptor descriptor : featureType.getAttributeDescriptors()) {
                TransformProcess.Definition definition = new TransformProcess.Definition();
                definition.name = descriptor.getLocalName();
                definition.binding = descriptor.getType().getBinding();
                definition.expression = ff.property(descriptor.getName());
                list.add(definition);
            }
        }
        return list;
    }

    public TransformPanel(Composite parent, int style) {
        super(parent, style);
        this.createExpressionTable(parent);
        this.listen(true);
    }

    public void addChangedListener(ChangeListener listener) {
        this.changedListeners.add((Object)listener);
    }

    public void removeChangedListener(ChangeListener listener) {
        this.changedListeners.remove((Object)listener);
    }

    protected void fireChanged(ChangeEvent changeEvent) {
        Object[] listeners = this.changedListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((ChangeListener)listeners[i]).stateChanged(changeEvent);
            ++i;
        }
    }

    public void setInput(SimpleFeature sample) {
        this.listen(false);
        this.schema = sample.getFeatureType();
        this.sample = sample;
        this.transform = TransformPanel.createDefaultTransformDefinition(this.schema);
        this.table.setInput(this.transform);
        this.table.refresh();
        ExpressionInput expressionInput = new ExpressionInput(this.schema, true);
        expressionInput.setFeedback(this.feedbackDecorator);
        this.expression.setInput(expressionInput);
        this.expression.refresh();
        this.listen(true);
    }

    public Composite getComposite() {
        return this.composite;
    }

    public List<TransformProcess.Definition> getTransform() {
        return this.transform;
    }

    protected Control createExpressionTable(Composite parent) {
        this.setLayout((Layout)new MigLayout("insets 0", "[grow,fill][]", "[][][][][grow,fill][][][][grow,fill][][]"));
        Label label = new Label((Composite)this, 16384);
        label.setText("Transform");
        label.setLayoutData((Object)"cell 0 0 2 1,width pref!,left");
        Button button = new Button((Composite)this, 0x1000000);
        button.setText("Add");
        button.setLayoutData((Object)"cell 1 1 1 1,grow");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int row = TransformPanel.this.table.getTable().getSelectionIndex();
                TransformProcess.Definition definition = new TransformProcess.Definition();
                definition.name = "";
                definition.expression = Expression.NIL;
                TransformPanel.this.transform.add(row, definition);
                TransformPanel.this.table.refresh();
                TransformPanel.this.table.setSelection((ISelection)new StructuredSelection((Object)definition));
            }
        });
        button = new Button((Composite)this, 0x1000000);
        button.setText("Up");
        button.setLayoutData((Object)"cell 1 2 1 1,grow");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int row = TransformPanel.this.table.getTable().getSelectionIndex();
                if (row == 0 || row == -1) {
                    return;
                }
                TransformProcess.Definition definition = TransformPanel.this.selectedDefinition();
                TransformPanel.this.transform.remove(definition);
                TransformPanel.this.transform.add(--row, definition);
                TransformPanel.this.table.refresh();
                TransformPanel.this.table.setSelection((ISelection)new StructuredSelection((Object)definition));
            }
        });
        button = new Button((Composite)this, 0x1000000);
        button.setText("Down");
        button.setLayoutData((Object)"cell 1 3 1 1,grow");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int row = TransformPanel.this.table.getTable().getSelectionIndex();
                if (row == TransformPanel.this.transform.size() - 1 || row == -1) {
                    return;
                }
                TransformProcess.Definition definition = TransformPanel.this.selectedDefinition();
                TransformPanel.this.transform.remove(definition);
                TransformPanel.this.transform.add(++row, definition);
                TransformPanel.this.table.refresh();
                TransformPanel.this.table.setSelection((ISelection)new StructuredSelection((Object)definition));
            }
        });
        button = new Button((Composite)this, 0x1000000);
        button.setText("Remove");
        button.setLayoutData((Object)"cell 1 5 1 1,grow");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int row = TransformPanel.this.table.getTable().getSelectionIndex();
                if (row == -1) {
                    return;
                }
                if (row > 0) {
                    --row;
                }
                TransformProcess.Definition definition = TransformPanel.this.selectedDefinition();
                TransformPanel.this.transform.remove(definition);
                TransformPanel.this.table.refresh();
                if (row < TransformPanel.this.transform.size()) {
                    TransformPanel.this.table.getTable().setSelection(row);
                } else {
                    TransformPanel.this.table.getTable().deselectAll();
                }
            }
        });
        this.table = new TableViewer((Composite)this, 2820);
        this.table.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.table.getControl().setLayoutData((Object)"cell 0 1 1 5, grow, height 200:50%:70%,width 300:pref:100%");
        TableViewerColumn column = new TableViewerColumn(this.table, 0);
        column.getColumn().setWidth(100);
        column.getColumn().setMoveable(false);
        column.getColumn().setResizable(true);
        column.getColumn().setText("Attribute");
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                TransformProcess.Definition definition = (TransformProcess.Definition)element;
                return definition.name;
            }
        });
        column = new TableViewerColumn(this.table, 0);
        column.getColumn().setWidth(60);
        column.getColumn().setMoveable(false);
        column.getColumn().setResizable(true);
        column.getColumn().setText("Type");
        column.getColumn().setAlignment(0x1000000);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                TransformProcess.Definition definition = (TransformProcess.Definition)element;
                return definition.binding == null ? TransformPanel.NO_CONTENT : definition.binding.getSimpleName();
            }
        });
        column = new TableViewerColumn(this.table, 0);
        column.getColumn().setWidth(140);
        column.getColumn().setMoveable(false);
        column.getColumn().setResizable(true);
        column.getColumn().setText("Expression");
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                TransformProcess.Definition definition = (TransformProcess.Definition)element;
                return definition.expression == null ? TransformPanel.NO_CONTENT : ECQL.toCQL((Expression)definition.expression);
            }
        });
        this.table.getTable().setHeaderVisible(true);
        this.table.getTable().setLinesVisible(true);
        this.table.addSelectionChangedListener(this.tableListener);
        Transfer[] types = new Transfer[]{UDigByteAndLocalTransfer.getInstance()};
        this.table.addDragSupport(18, types, (DragSourceListener)new DragSourceAdapter(){

            public void dragSetData(DragSourceEvent event) {
                IStructuredSelection selection = (IStructuredSelection)TransformPanel.this.table.getSelection();
                if (UDigByteAndLocalTransfer.getInstance().isSupportedType(event.dataType)) {
                    event.data = selection.getFirstElement();
                }
            }
        });
        this.table.addDropSupport(18, types, (DropTargetListener)new ViewerDropAdapter((Viewer)this.table){

            public boolean validateDrop(Object target, int operation, TransferData transferType) {
                return target instanceof TransformProcess.Definition;
            }

            public boolean performDrop(Object data) {
                if (data instanceof TransformProcess.Definition) {
                    TransformPanel.this.listen(false);
                    int index = TransformPanel.this.transform.indexOf(this.getCurrentTarget());
                    TransformProcess.Definition definition = (TransformProcess.Definition)data;
                    TransformPanel.this.transform.remove(definition);
                    TransformPanel.this.transform.add(index, definition);
                    TransformPanel.this.table.refresh();
                    TransformPanel.this.table.setSelection((ISelection)new StructuredSelection((Object)definition));
                    TransformPanel.this.listen(true);
                    return true;
                }
                return false;
            }
        });
        this.definitionLabel = new Label((Composite)this, 16384);
        this.definitionLabel.setText("Definition");
        this.definitionLabel.setLayoutData((Object)"cell 0 6 2 1, width pref!,left");
        this.feedbackDecorator = new ControlDecoration((Control)this.definitionLabel, 131200);
        this.name = new Text((Composite)this, 2052);
        this.name.setEditable(true);
        this.name.setText("");
        this.name.setLayoutData((Object)"cell 0 7 2 1");
        this.expression = new ExpressionViewer((Composite)this, 2);
        this.expression.getControl().setLayoutData((Object)"cell 0 8 2 1,height 200:50%:50%,width 300:pref:100%");
        this.expression.addSelectionChangedListener(this.expressionListener);
        this.table.setSelection((ISelection)StructuredSelection.EMPTY);
        this.enable(false);
        return this;
    }

    protected void listen(boolean listen) {
        if (listen) {
            this.name.addModifyListener(this.nameListener);
            this.expression.addSelectionChangedListener(this.expressionListener);
        } else {
            this.name.removeModifyListener(this.nameListener);
            this.expression.removeSelectionChangedListener(this.expressionListener);
        }
    }

    protected void enable(boolean isEditEnable) {
        this.definitionLabel.setEnabled(isEditEnable);
        this.name.setEnabled(isEditEnable);
        this.expression.getControl().setEnabled(isEditEnable);
    }

    protected TransformProcess.Definition selectedDefinition() {
        ISelection selectedRow = this.table.getSelection();
        if (!selectedRow.isEmpty() && selectedRow instanceof StructuredSelection) {
            StructuredSelection selection = (StructuredSelection)selectedRow;
            return (TransformProcess.Definition)selection.getFirstElement();
        }
        return null;
    }
}

