/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.ui.operation;

import java.util.List;
import net.miginfocom.swt.MigLayout;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.catalog.ui.CatalogUIPlugin;
import net.refractions.udig.catalog.ui.internal.Messages;
import net.refractions.udig.catalog.ui.operation.PostReshapeAction;
import net.refractions.udig.catalog.ui.operation.TransformPanel;
import net.refractions.udig.core.IProvider;
import net.refractions.udig.core.StaticProvider;
import net.refractions.udig.core.internal.ExtensionPointList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.geotools.process.vector.TransformProcess;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class TransformDialog
extends Dialog {
    private static final String NO_CONTENT = "--";
    private static final String ACTION_COMBO_SETTINGS = "RESHAPE_ACTION_COMBO_SETTINGS";
    private SimpleFeatureType featureType;
    private Combo actionCombo;
    private IProvider<PostReshapeAction> postActionProvider;
    private ControlDecoration feedbackDecorator;
    private TransformPanel panel;
    private SimpleFeature sampleFeature;

    public TransformDialog(Shell parent, SimpleFeature sample) {
        super(parent);
        this.sampleFeature = sample;
        this.setShellStyle(2160);
    }

    protected Point getInitialSize() {
        return new Point(500, 500);
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(Messages.TransformDialog_Title);
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        dialogArea.setLayoutData((Object)new GridData(4, 4, true, true));
        dialogArea.setLayout((Layout)new MigLayout("flowy"));
        this.panel = new TransformPanel(dialogArea, 16);
        this.panel.setInput(this.sampleFeature);
        this.panel.setLayoutData("width 300:100%:100%,height 450:pref:100%");
        Label label = new Label(dialogArea, 16384);
        label.setText(Messages.TransformDialog_Post_Action_Prompt);
        label.setLayoutData((Object)"width pref!, height pref!");
        this.actionCombo = new Combo(dialogArea, 8);
        this.actionCombo(this.actionCombo);
        this.actionCombo.setLayoutData((Object)"width pref!,height pref!");
        return dialogArea;
    }

    private void actionCombo(Combo actionCombo) {
        actionCombo.add(Messages.ReshapeOperation_noAction);
        actionCombo.setData(Messages.ReshapeOperation_noAction, (Object)new StaticProvider((Object)new Null_Action()));
        int i = 1;
        String lastSelection = CatalogUIPlugin.getDefault().getDialogSettings().get(ACTION_COMBO_SETTINGS);
        int selected = 0;
        List extensions = ExtensionPointList.getExtensionPointList((String)"net.refractions.udig.catalog.ui.reshapePostAction");
        for (final IConfigurationElement configurationElement : extensions) {
            String name = configurationElement.getAttribute("name");
            IProvider<PostReshapeAction> provider = new IProvider<PostReshapeAction>(){

                public PostReshapeAction get(Object ... params) {
                    try {
                        return (PostReshapeAction)configurationElement.createExecutableExtension("class");
                    }
                    catch (CoreException e) {
                        throw (RuntimeException)new RuntimeException().initCause(e);
                    }
                }
            };
            actionCombo.add(name);
            actionCombo.setData(name, (Object)provider);
            String id = String.valueOf(configurationElement.getNamespaceIdentifier()) + "." + configurationElement.getAttribute("id");
            actionCombo.setData(String.valueOf(name) + "id", (Object)id);
            if (id.equals(lastSelection)) {
                selected = i;
            }
            ++i;
        }
        actionCombo.select(selected);
    }

    protected void okPressed() {
        boolean ok = false;
        try {
            List<TransformProcess.Definition> transform = this.panel.getTransform();
            ok = transform != null;
            String selected = this.actionCombo.getItem(this.actionCombo.getSelectionIndex());
            CatalogUIPlugin.getDefault().getDialogSettings().put(ACTION_COMBO_SETTINGS, (String)this.actionCombo.getData(String.valueOf(selected) + "id"));
            this.postActionProvider = (IProvider)this.actionCombo.getData(selected);
        }
        catch (Throwable throwable) {}
        if (ok) {
            super.okPressed();
        }
    }

    public SimpleFeatureType getFeatureType() {
        return this.featureType;
    }

    public void executePostAction(IGeoResource handle, IGeoResource transformed) {
        PostReshapeAction postReshapeAction = (PostReshapeAction)this.postActionProvider.get(new Object[0]);
        postReshapeAction.execute(handle, transformed);
    }

    public List<TransformProcess.Definition> getTransform() {
        return this.panel.getTransform();
    }

    private final class Null_Action
    implements PostReshapeAction {
        private Null_Action() {
        }

        @Override
        public void execute(IGeoResource original, IGeoResource reshaped) {
        }
    }
}

