/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.ui.internal;

import java.io.IOException;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.catalog.IResolve;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.core.SelectionProviderForwarder;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyDialogAction;

public class IServicePropertiesCommandHandler
extends AbstractHandler
implements IHandler {
    public Object execute(ExecutionEvent arg0) throws ExecutionException {
        final IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IShellProvider shellProvider = new IShellProvider(){

            public Shell getShell() {
                return new Shell(activeWorkbenchWindow.getShell());
            }
        };
        IWorkbenchPart activePart = activeWorkbenchWindow.getActivePage().getActivePart();
        ISelectionProvider provider = activePart.getSite().getSelectionProvider();
        if (provider == null) {
            MessageDialog.openInformation((Shell)activeWorkbenchWindow.getShell(), (String)"Service Properties", (String)"Please select a service");
            return null;
        }
        ServiceSelectionProvider selectionProvider = new ServiceSelectionProvider(provider);
        PropertyDialogAction action = new PropertyDialogAction(shellProvider, (ISelectionProvider)selectionProvider);
        PreferenceDialog dialog = action.createDialog();
        dialog.open();
        return null;
    }

    static class ServiceSelectionProvider
    extends SelectionProviderForwarder {
        ServiceSelectionProvider(ISelectionProvider provider) {
            super(provider, IService.class);
        }

        public ISelection getSelection() {
            ISelection selection = this.provider.getSelection();
            if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
                IResolve resolve;
                IStructuredSelection sel = (IStructuredSelection)selection;
                Object element = sel.getFirstElement();
                if (element instanceof IService) {
                    return selection;
                }
                if (element instanceof IGeoResource) {
                    IGeoResource resource = (IGeoResource)element;
                    return this.toServiceSelection(resource);
                }
                if (element instanceof IResolve && (resolve = (IResolve)element).canResolve(IService.class)) {
                    try {
                        IService service = (IService)resolve.resolve(IService.class, (IProgressMonitor)new NullProgressMonitor());
                        return new StructuredSelection((Object)service);
                    }
                    catch (IOException iOException) {
                        return StructuredSelection.EMPTY;
                    }
                }
                if (element instanceof IAdaptable) {
                    IAdaptable adaptable = (IAdaptable)element;
                    IService service = (IService)adaptable.getAdapter(IService.class);
                    if (service != null) {
                        return new StructuredSelection((Object)service);
                    }
                    IGeoResource resource = (IGeoResource)adaptable.getAdapter(IGeoResource.class);
                    if (resource != null) {
                        return this.toServiceSelection(resource);
                    }
                    IResolve resolve2 = (IResolve)adaptable.getAdapter(IResolve.class);
                    if (resolve2 != null && resolve2.canResolve(IService.class)) {
                        try {
                            service = (IService)resolve2.resolve(IService.class, (IProgressMonitor)new NullProgressMonitor());
                            return new StructuredSelection((Object)service);
                        }
                        catch (IOException iOException) {
                            return StructuredSelection.EMPTY;
                        }
                    }
                }
            }
            return StructuredSelection.EMPTY;
        }

        private ISelection toServiceSelection(IGeoResource resource) {
            try {
                IService service = resource.service((IProgressMonitor)new NullProgressMonitor());
                return new StructuredSelection((Object)service);
            }
            catch (IOException iOException) {
                return StructuredSelection.EMPTY;
            }
        }
    }
}

