/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.ui.export;

import com.vividsolutions.jts.geom.Geometry;
import java.util.ArrayList;
import java.util.List;
import org.geotools.feature.DecoratingFeature;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

class FeatureWrapper
extends DecoratingFeature
implements SimpleFeature {
    protected final SimpleFeatureType featureType;
    protected final Geometry[] geometry;
    protected final String[] geomAttNames;
    protected Geometry defaultGeometry;

    public FeatureWrapper(SimpleFeature wrapped, SimpleFeatureType featureType, Geometry[] geometries, String[] geomAttNames) throws IllegalArgumentException {
        super(wrapped);
        this.featureType = featureType;
        this.geometry = geometries;
        this.geomAttNames = geomAttNames;
        String defaultGeomName = featureType.getGeometryDescriptor().getName().getLocalPart();
        this.defaultGeometry = this.findTransformedGeometry(defaultGeomName);
    }

    private Geometry findTransformedGeometry(String defaultGeomName) throws IllegalArgumentException {
        int i = 0;
        while (i < this.geomAttNames.length) {
            String attName = this.geomAttNames[i];
            if (attName.equals(defaultGeomName)) {
                return this.geometry[i];
            }
            ++i;
        }
        throw new IllegalArgumentException("Attribute does not exist:" + defaultGeomName);
    }

    public final Object getAttribute(int index) {
        return this.getAttribute(this.featureType.getDescriptor(index).getName().getLocalPart());
    }

    public final Object getAttribute(String xPath) {
        AttributeDescriptor type = this.featureType.getDescriptor(xPath);
        if (type instanceof GeometryDescriptor) {
            return this.findTransformedGeometry(xPath);
        }
        return this.delegate.getAttribute(xPath);
    }

    static int indexOf(SimpleFeatureType schema, String name) {
        int i = 0;
        while (i < schema.getAttributeCount()) {
            if (schema.getDescriptor(i).getLocalName().equalsIgnoreCase(name)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public ReferencedEnvelope getBounds() {
        ReferencedEnvelope bounds = new ReferencedEnvelope(this.delegate.getBounds());
        if (bounds != null) {
            return bounds;
        }
        CoordinateReferenceSystem crs = this.featureType.getCoordinateReferenceSystem();
        return new ReferencedEnvelope(this.defaultGeometry.getEnvelopeInternal(), crs);
    }

    public Geometry getDefaultGeometry() {
        return this.defaultGeometry;
    }

    public Geometry getPrimaryGeometry() {
        return this.getDefaultGeometry();
    }

    public void setPrimaryGeometry(Geometry geometry) throws IllegalAttributeException {
        this.setDefaultGeometry(geometry);
    }

    public SimpleFeatureType getFeatureType() {
        return this.featureType;
    }

    public String getID() {
        return this.delegate.getID();
    }

    public int getAttributeCount() {
        return this.featureType.getAttributeCount();
    }

    public void setAttribute(int position, Object val) throws IllegalAttributeException, ArrayIndexOutOfBoundsException {
        throw new UnsupportedOperationException();
    }

    public void setAttribute(String xPath, Object attribute) throws IllegalAttributeException {
        throw new UnsupportedOperationException();
    }

    public void setDefaultGeometry(Geometry geometry) throws IllegalAttributeException {
        throw new UnsupportedOperationException();
    }

    public void setParent(FeatureCollection<SimpleFeatureType, SimpleFeature> collection) {
        throw new UnsupportedOperationException();
    }

    public List<Object> getAttributes() {
        ArrayList<Object> attributes = new ArrayList<Object>(this.delegate.getAttributes());
        int i = 0;
        while (i < attributes.size()) {
            Object object = attributes.get(i);
            AttributeDescriptor attributeType = this.delegate.getFeatureType().getDescriptor(i);
            int index = FeatureWrapper.indexOf(this.featureType, attributeType.getName().getLocalPart());
            if (index != -1) {
                if (attributeType instanceof GeometryDescriptor) {
                    attributes.set(index, this.findTransformedGeometry(attributeType.getName().getLocalPart()));
                } else {
                    attributes.set(index, object);
                }
            }
            ++i;
        }
        return attributes;
    }
}

