/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.ui.export;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.catalog.ui.export.Data;
import net.refractions.udig.catalog.ui.internal.Messages;
import net.refractions.udig.catalog.ui.workflow.State;
import net.refractions.udig.core.AdapterUtil;
import net.refractions.udig.core.Pair;
import net.refractions.udig.ui.ProgressManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;

public class ExportResourceSelectionState
extends State {
    List<Data> layers;
    List<Data> selectedLayers;
    ISelection selection = null;
    private String exportDir = Platform.getLocation().toOSString();

    public ExportResourceSelectionState(ISelection selection) {
        this.selection = selection;
    }

    public ExportResourceSelectionState() {
        this(null);
    }

    public List<Data> getLayers() {
        return this.layers;
    }

    public List<Data> getExportData() {
        return this.selectedLayers;
    }

    public void setSelectedLayers(List<Data> selectedLayers) {
        this.selectedLayers = selectedLayers;
    }

    @Override
    public void init(IProgressMonitor monitor) throws IOException {
        super.init(monitor);
        this.layers = new ArrayList<Data>();
        Object[] items = new Object[]{};
        if (this.selection instanceof StructuredSelection) {
            items = ((StructuredSelection)this.selection).toArray();
        }
        if (items.length == 0) {
            items = this.loadNonWorkbencSelection();
        }
        int i = 0;
        while (i < items.length) {
            Object object = items[i];
            this.layers.addAll(this.convertToGeoResource(object));
            ++i;
        }
    }

    protected Object[] loadNonWorkbencSelection() {
        return new Object[0];
    }

    protected Collection<Data> convertToGeoResource(Object object) throws IOException {
        HashSet<Data> data = new HashSet<Data>();
        this.tryAdaptingToGeoResource(object, data);
        this.tryAdaptingToService(object, data);
        return data;
    }

    private void tryAdaptingToGeoResource(Object object, Collection<Data> data) throws IOException {
        if (object instanceof IGeoResource) {
            data.add(new Data((IGeoResource)object));
        } else {
            IGeoResource resource = (IGeoResource)AdapterUtil.instance.adaptTo(IGeoResource.class, object, ProgressManager.instance().get(new Object[0]));
            if (resource != null) {
                data.add(new Data(resource));
            }
        }
    }

    private void tryAdaptingToService(Object object, Collection<Data> data) throws IOException {
        if (object instanceof IService) {
            IService service = (IService)object;
            List resources = service.resources(ProgressManager.instance().get(new Object[0]));
            for (IGeoResource resource : resources) {
                data.add(new Data(resource));
            }
        }
    }

    @Override
    public Pair<Boolean, State> dryRun() {
        boolean result = true;
        if (this.layers == null || this.layers.isEmpty() || this.selectedLayers == null || this.selectedLayers.isEmpty()) {
            result = false;
        }
        return new Pair((Object)result, null);
    }

    @Override
    public boolean run(IProgressMonitor monitor) throws IOException {
        return (Boolean)this.dryRun().getLeft();
    }

    @Override
    public String getName() {
        return Messages.CatalogExport_exportLayersTask;
    }

    public String getExportDir() {
        return this.exportDir;
    }

    public void setExportDir(String text) {
        this.exportDir = text;
    }
}

