/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.ui.export;

import com.vividsolutions.jts.geom.Geometry;
import java.util.Iterator;
import net.refractions.udig.catalog.ui.export.FeatureWrapper;
import net.refractions.udig.catalog.ui.internal.Messages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.collection.AdaptorFeatureCollection;
import org.geotools.geometry.jts.JTS;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

abstract class AbstractGeometryTransformingFeatureCollection
extends AdaptorFeatureCollection {
    private final FeatureCollection<SimpleFeatureType, SimpleFeature> source;
    private final SimpleFeatureType schema;
    private final GeometryDescriptor typeToUseAsGeometry;
    private final IProgressMonitor monitor;
    private final MathTransform mt;

    public AbstractGeometryTransformingFeatureCollection(FeatureCollection<SimpleFeatureType, SimpleFeature> source, SimpleFeatureType schema, GeometryDescriptor typeToUseAsGeometry, MathTransform mt, IProgressMonitor monitor2) {
        super("transform", schema);
        this.source = source;
        this.schema = schema;
        this.typeToUseAsGeometry = typeToUseAsGeometry;
        this.monitor = monitor2;
        this.mt = mt;
    }

    protected void closeIterator(Iterator close) {
        this.source.close(close);
    }

    protected Iterator<SimpleFeature> openIterator() {
        final Iterator iter = this.source.iterator();
        return new Iterator<SimpleFeature>(){
            private SimpleFeature feature;

            @Override
            public boolean hasNext() {
                while (this.feature == null) {
                    if (!iter.hasNext()) {
                        return false;
                    }
                    SimpleFeature next = (SimpleFeature)iter.next();
                    if (next == null) continue;
                    Geometry geometry = (Geometry)next.getAttribute(AbstractGeometryTransformingFeatureCollection.this.typeToUseAsGeometry.getName());
                    if ((geometry = AbstractGeometryTransformingFeatureCollection.this.toCollection(geometry)) != null) {
                        try {
                            geometry = JTS.transform((Geometry)geometry, (MathTransform)AbstractGeometryTransformingFeatureCollection.this.mt);
                        }
                        catch (TransformException e) {
                            throw (RuntimeException)new RuntimeException(String.valueOf(Messages.ReprojectingFeatureCollection_transformationError) + next.getID()).initCause(e);
                        }
                    }
                    this.feature = new FeatureWrapper(next, AbstractGeometryTransformingFeatureCollection.this.schema, new Geometry[]{geometry}, new String[]{AbstractGeometryTransformingFeatureCollection.this.schema.getGeometryDescriptor().getName().getLocalPart()});
                }
                return this.feature != null;
            }

            @Override
            public SimpleFeature next() {
                SimpleFeature tmp = this.feature;
                this.feature = null;
                AbstractGeometryTransformingFeatureCollection.this.monitor.worked(1);
                return tmp;
            }

            @Override
            public void remove() {
                iter.remove();
            }
        };
    }

    protected abstract Geometry toCollection(Geometry var1);

    public int size() {
        return this.source.size();
    }
}

