/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.ui;

import java.util.List;
import net.refractions.udig.catalog.ui.ConnectionFactoryManager;
import net.refractions.udig.catalog.ui.UDIGConnectionFactory;
import net.refractions.udig.catalog.ui.UDIGConnectionPage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class UDIGConnectionFactoryDescriptor {
    UDIGConnectionFactory factory;
    private List<ConnectionFactoryManager.Descriptor<UDIGConnectionPage>> wizardPages;
    private ConnectionFactoryManager.Descriptor<UDIGConnectionFactory> factoryDescriptor;

    public UDIGConnectionFactoryDescriptor(ConnectionFactoryManager.Descriptor<UDIGConnectionFactory> factoryDescriptor) throws CoreException {
        this.factoryDescriptor = factoryDescriptor;
        this.factory = factoryDescriptor.getConcreteInstance();
        this.factory.setDescriptor(this);
        this.wizardPages = ConnectionFactoryManager.instance().getPageDescriptor(factoryDescriptor);
    }

    public UDIGConnectionFactory getConnectionFactory() {
        return this.factory;
    }

    public UDIGConnectionPage createConnectionPage(int pageIndex) throws CoreException {
        UDIGConnectionPage page = this.wizardPages.get(pageIndex).getConcreteInstance();
        page.setTitle(this.getLabel(pageIndex));
        page.setDescription(this.getDescription(pageIndex));
        page.setImageDescriptor(this.getDescriptionImage(pageIndex));
        return page;
    }

    public String getLabel(int pageIndex) {
        return this.wizardPages.get(pageIndex).getConfigurationElement().getAttribute("name");
    }

    public String getDescription(int pageIndex) {
        String desc = this.wizardPages.get(pageIndex).getConfigurationElement().getAttribute("description");
        if (desc == null) {
            return "";
        }
        return desc.trim();
    }

    public String getId() {
        IConfigurationElement configurationElement = this.wizardPages.get(0).getConfigurationElement();
        String deprecatedId = configurationElement.getAttribute("id");
        String id = this.factoryDescriptor.getConfigurationElement().getAttribute("id");
        if (id != null && id.trim().length() > 0) {
            return id;
        }
        return deprecatedId;
    }

    public ImageDescriptor getImage(int pageIndex) {
        String ns = this.wizardPages.get(pageIndex).getConfigurationElement().getNamespaceIdentifier();
        String banner = this.wizardPages.get(pageIndex).getConfigurationElement().getAttribute("icon");
        if (banner == null) {
            return null;
        }
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)ns, (String)banner);
    }

    public ImageDescriptor getDescriptionImage(int pageIndex) {
        String ns = this.wizardPages.get(pageIndex).getConfigurationElement().getNamespaceIdentifier();
        String banner = this.wizardPages.get(pageIndex).getConfigurationElement().getAttribute("banner");
        if (banner == null) {
            return null;
        }
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)ns, (String)banner);
    }

    public String getServiceType(int pageIndex) {
        return this.wizardPages.get(pageIndex).getConfigurationElement().getAttribute("type");
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof UDIGConnectionFactoryDescriptor) {
            UDIGConnectionFactoryDescriptor descriptor = (UDIGConnectionFactoryDescriptor)obj;
            return this.getId() != null && this.getId().equals(descriptor.getId());
        }
        return false;
    }

    public int hashCode() {
        if (this.getId() == null) {
            return "".hashCode();
        }
        return this.getId().hashCode();
    }

    public int getWizardPageCount() {
        return this.wizardPages.size();
    }

    public String toString() {
        StringBuilder build = new StringBuilder(this.factory.getClass().getSimpleName());
        build.append(" Info");
        if (!this.wizardPages.isEmpty()) {
            build.append(" '");
            build.append(this.getLabel(0));
            build.append("'");
        }
        return build.toString();
    }
}

