/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.ui;

import java.io.IOException;
import net.refractions.udig.catalog.CatalogPlugin;
import net.refractions.udig.catalog.ID;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.catalog.IProcess;
import net.refractions.udig.catalog.IResolve;
import net.refractions.udig.catalog.IResolveChangeEvent;
import net.refractions.udig.catalog.IResolveChangeListener;
import net.refractions.udig.catalog.IResolveFolder;
import net.refractions.udig.catalog.ISearch;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.catalog.ui.CatalogUIPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class ResolveLabelProviderSimple
extends LabelProvider
implements IResolveChangeListener {
    public ResolveLabelProviderSimple() {
        CatalogPlugin.addListener((IResolveChangeListener)this);
    }

    public void changed(IResolveChangeEvent event) {
        if (event.getType() != IResolveChangeEvent.Type.POST_CHANGE) {
            return;
        }
        final IResolve resolve = event.getResolve();
        if (resolve == null) {
            return;
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                ResolveLabelProviderSimple.this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)ResolveLabelProviderSimple.this, (Object)resolve));
            }
        });
    }

    public String getText(Object element) {
        if (element instanceof IResolve) {
            IResolve resolve = (IResolve)element;
            try {
                if (resolve instanceof IGeoResource) {
                    IGeoResource resource = (IGeoResource)resolve;
                    String title = resource.getTitle();
                    ID id = resource.getID();
                    if (title == null) {
                        title = id.labelResource();
                    }
                    return title;
                }
                if (resolve instanceof IService) {
                    IService service = (IService)resolve;
                    ID id = service.getID();
                    String title = service.getTitle();
                    if (title == null) {
                        String name = id.toString();
                        name = name.replace('_', ' ');
                        name = name.replace("%20", " ");
                        return name;
                    }
                    if (id.getTypeQualifier() != null) {
                        return String.valueOf(title) + "(" + id.getTypeQualifier() + ")";
                    }
                    return title;
                }
                if (resolve instanceof IProcess) {
                    IProcess proc = (IProcess)element;
                    return proc.getInfo((IProgressMonitor)new NullProgressMonitor()).getTitle();
                }
                if (resolve instanceof ISearch) {
                    ISearch search = (ISearch)element;
                    return search.getInfo((IProgressMonitor)new NullProgressMonitor()).getTitle();
                }
                if (resolve instanceof IResolveFolder) {
                    IResolveFolder folder = (IResolveFolder)element;
                    return folder.getID().toString();
                }
                return resolve.getID().toString();
            }
            catch (IOException e) {
                CatalogUIPlugin.trace("Error fetching the Title for the resource", e);
            }
        }
        return super.getText(element);
    }

    public Image getImage(Object element) {
        if (element instanceof IResolve) {
            return CatalogUIPlugin.image((IResolve)element);
        }
        return super.getImage(element);
    }
}

