/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.ui;

import net.refractions.udig.catalog.ui.CatalogUIPlugin;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWizard;

public abstract class IDataWizard
extends Wizard
implements IWorkbenchWizard {
    static final String SETTINGS = "IDataWizard";
    WizardPage[] pages;
    IStructuredSelection selection = new StructuredSelection();
    IWorkbench workbench;

    public IDataWizard() {
        IDialogSettings settings = CatalogUIPlugin.getDefault().getDialogSettings().getSection(SETTINGS);
        if (settings == null) {
            settings = CatalogUIPlugin.getDefault().getDialogSettings().addNewSection(SETTINGS);
        }
        this.setDialogSettings(settings);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
        this.setNeedsProgressMonitor(true);
    }

    public IStructuredSelection getSelection() {
        return this.selection;
    }

    public IWorkbench getWorkbench() {
        return this.workbench;
    }

    public void addPages() {
        this.pages = this.getPrimaryPages();
        int i = 0;
        while (i < this.pages.length) {
            this.init(this.pages[i]);
            this.addPage((IWizardPage)this.pages[i]);
            ++i;
        }
    }

    public IWizardPage getNextPage(IWizardPage page) {
        return this.getNextPrimaryPage(page);
    }

    public boolean hasMorePrimaryPages() {
        return this.getNextPrimaryPage(this.getContainer().getCurrentPage()) != null;
    }

    private IWizardPage getNextPrimaryPage(IWizardPage page) {
        IWizardPage[] primary = this.getPages();
        while (page != null) {
            int i = 0;
            while (i < primary.length) {
                if (page == primary[i]) {
                    if (i == primary.length - 1) {
                        return null;
                    }
                    return primary[i + 1];
                }
                ++i;
            }
            page = page.getPreviousPage();
        }
        return null;
    }

    public boolean needsPreviousAndNextButtons() {
        return true;
    }

    public boolean canFinish() {
        IWizardPage page = this.getContainer().getCurrentPage();
        if (!page.isPageComplete()) {
            return false;
        }
        if (page.canFlipToNextPage()) {
            return false;
        }
        return this.getNextPrimaryPage(page) == null;
    }

    public void init(WizardPage page) {
        page.setWizard((IWizard)this);
    }

    protected abstract WizardPage[] getPrimaryPages();
}

