/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.ui;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.refractions.udig.catalog.CatalogPlugin;
import net.refractions.udig.catalog.ICatalog;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.catalog.ui.AbstractUDIGImportPage;
import net.refractions.udig.catalog.ui.CatalogUIPlugin;
import net.refractions.udig.catalog.ui.FileConnectionFactory;
import net.refractions.udig.catalog.ui.UDIGConnectionPage;
import net.refractions.udig.catalog.ui.internal.Messages;
import net.refractions.udig.ui.PlatformGIS;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class FileConnectionPage
extends AbstractUDIGImportPage
implements UDIGConnectionPage {
    private final Set<URL> list = new HashSet<URL>();
    private Composite comp;
    private FileConnectionFactory factory = new FileConnectionFactory();
    private FileDialog fileDialog;
    private Collection<URL> resourceIds = new HashSet<URL>();
    private ListViewer viewer;

    public String getId() {
        return "net.refractions.udig.catalog.ui.openFilePage";
    }

    public FileConnectionPage() {
        super(Messages.OpenFilePage_pageTitle);
    }

    List<IService> process(List<URL> urls, IProgressMonitor monitor) {
        ArrayList<IService> resources = new ArrayList<IService>();
        monitor.beginTask(Messages.OpenFilePage_1, this.list.size());
        int worked = 0;
        for (URL url : urls) {
            if (monitor.isCanceled()) {
                return null;
            }
            try {
                monitor.subTask(url.toExternalForm());
                List acquire = CatalogPlugin.getDefault().getServiceFactory().createService(url);
                resources.addAll(acquire);
            }
            catch (Throwable e) {
                CatalogUIPlugin.log("error obtaining services from service factory", e);
            }
            monitor.worked(worked++);
        }
        return resources;
    }

    private void pushButton(int buttonId) {
        try {
            this.findButton(this.getShell().getChildren(), buttonId).notifyListeners(13, new Event());
        }
        catch (Exception e) {
            CatalogUIPlugin.log("", e);
        }
    }

    Button findButton(Control[] children, int id) {
        if ((Integer)this.getShell().getDefaultButton().getData() == id) {
            return this.getShell().getDefaultButton();
        }
        Control[] controlArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Composite composite;
            Button button;
            Button button2;
            Control child = controlArray[n2];
            if (child instanceof Button && (button2 = (Button)child).getData() != null && (Integer)button2.getData() == id) {
                return button2;
            }
            if (child instanceof Composite && (button = this.findButton((composite = (Composite)child).getChildren(), id)) != null) {
                return button;
            }
            ++n2;
        }
        return null;
    }

    protected boolean hasOneResource(SubProgressMonitor monitor, List<IService> services) throws IOException {
        if (services.size() > 1 || services.isEmpty()) {
            return false;
        }
        return services.get(0).resources((IProgressMonitor)monitor).size() == 1;
    }

    @Override
    public boolean canFlipToNextPage() {
        return this.list != null && this.list.size() > 1;
    }

    public void createControl(Composite parent) {
        this.comp = new Composite(parent, 0);
        this.comp.setLayout((Layout)new GridLayout(1, true));
        Label label = new Label(this.comp, 0);
        GridDataFactory.swtDefaults().applyTo((Control)label);
        label.setText(Messages.FileConnectionPage_waitMessage);
        this.viewer = new ListViewer(this.comp, 776);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        GridDataFactory.fillDefaults().grab(true, true).applyTo(this.viewer.getControl());
        this.setControl((Control)this.comp);
    }

    @Override
    public void shown() {
        Runnable openFileDialog = new Runnable(){

            @Override
            public void run() {
                FileConnectionPage.this.selectAndContinueWizard();
            }
        };
        PlatformGIS.asyncInDisplayThread((Runnable)openFileDialog, (boolean)false);
    }

    private void selectAndContinueWizard() {
        this.list.clear();
        boolean okPressed = this.openFileDialog(this.comp);
        this.viewer.setInput(this.list);
        this.getContainer().updateButtons();
        if (okPressed) {
            if (this.findButton(this.getShell().getChildren(), 16).isEnabled()) {
                this.pushButton(16);
            } else {
                this.pushButton(15);
            }
        } else {
            this.pushButton(14);
        }
    }

    private boolean checkDND(FileDialog fileDialog) {
        try {
            Object context = this.getState().getWorkflow().getContext();
            HashSet<URL> urlList = new HashSet<URL>();
            URL url = this.factory.createConnectionURL(context);
            if (url != null) {
                urlList.add(url);
            }
            if (urlList.size() != 0) {
                this.list.addAll(urlList);
                String file = ((URL)urlList.iterator().next()).getFile();
                String ext = file.substring(file.lastIndexOf(46));
                String dir = new File(file).getParent();
                file = file.substring(file.lastIndexOf(File.separator) + 1);
                fileDialog.setFilterPath(dir);
                fileDialog.setFileName(file);
                String[] filters = fileDialog.getFilterExtensions();
                if (filters == null || filters.length == 0) {
                    fileDialog.setFilterExtensions(new String[]{"*" + ext, "*.*"});
                } else {
                    int i = 0;
                    while (i < filters.length) {
                        if (("*" + ext).equals(filters[i])) break;
                        ++i;
                    }
                    if (i < filters.length) {
                        String[] nfilters = new String[filters.length];
                        nfilters[0] = filters[i];
                        System.arraycopy(filters, 0, nfilters, 1, i);
                        System.arraycopy(filters, i + 1, nfilters, i + 1, filters.length - i - 1);
                        fileDialog.setFilterExtensions(nfilters);
                    } else {
                        String[] nfilters = new String[filters.length + 1];
                        nfilters[0] = "*" + ext;
                        System.arraycopy(filters, 0, nfilters, 1, filters.length);
                        fileDialog.setFilterExtensions(nfilters);
                    }
                }
                return true;
            }
        }
        catch (Exception e) {
            CatalogUIPlugin.log(e.getLocalizedMessage(), e);
        }
        return false;
    }

    public FileDialog getFileDialog() {
        return this.fileDialog;
    }

    private boolean openFileDialog(Composite parent) {
        String result;
        String lastOpenedDirectory = PlatformUI.getPreferenceStore().getString("udig.preferences.openDialog.lastDirectory");
        this.fileDialog = new FileDialog(parent.getShell(), 4098);
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<String> extensions = new ArrayList<String>();
        StringBuilder all = new StringBuilder();
        for (FileConnectionFactory.FileType fileType : this.factory.getTypeList()) {
            String name = fileType.getName();
            String fileExtensions = fileType.getExtensions();
            if (name == null) {
                name = fileExtensions;
            }
            names.add(name);
            extensions.add(fileExtensions);
            if (all.length() != 0) {
                all.append(";");
            }
            all.append(fileExtensions);
        }
        names.add(0, "Supported Files");
        extensions.add(0, all.toString());
        String platform = SWT.getPlatform();
        if (platform.equals("win32") || platform.equals("wpf")) {
            names.add("All Files (*.*)");
            extensions.add("*.*");
        } else {
            names.add("All Files (*)");
            extensions.add("*");
        }
        this.fileDialog.setFilterExtensions(extensions.toArray(new String[0]));
        this.fileDialog.setFilterNames(names.toArray(new String[0]));
        if (lastOpenedDirectory != null && !this.checkDND(this.fileDialog)) {
            this.fileDialog.setFilterPath(lastOpenedDirectory);
        }
        if ((result = this.fileDialog.open()) == null) {
            return false;
        }
        String path = this.fileDialog.getFilterPath();
        PlatformUI.getPreferenceStore().setValue("udig.preferences.openDialog.lastDirectory", path);
        String[] filenames = this.fileDialog.getFileNames();
        int i = 0;
        while (i < filenames.length) {
            try {
                URL url = new File(String.valueOf(path) + System.getProperty("file.separator") + filenames[i]).toURI().toURL();
                this.list.add(url);
            }
            catch (Throwable e) {
                CatalogUIPlugin.log("", e);
            }
            ++i;
        }
        return true;
    }

    @Override
    public Collection<IService> getServices() {
        this.resourceIds.clear();
        final ICatalog catalog = CatalogPlugin.getDefault().getLocalCatalog();
        final ArrayList<IService> services = new ArrayList<IService>();
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            /*
             * Unable to fully structure code
             */
            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                availableServices = null;
                if (!FileConnectionPage.access$1(FileConnectionPage.this).isEmpty()) {
                    for (URL url : FileConnectionPage.access$1(FileConnectionPage.this)) {
                        block9: {
                            try {
                                try {
                                    availableServices = catalog.constructServices(url, monitor);
                                    if (!availableServices.isEmpty()) {
                                        service = (IService)availableServices.iterator().next();
                                        FileConnectionPage.access$2(FileConnectionPage.this).add(service.getIdentifier());
                                        services.add(service);
                                    }
                                    break block9;
                                }
                                catch (IOException e) {
                                    throw (RuntimeException)new RuntimeException().initCause(e);
                                }
                            }
                            catch (Throwable var6_10) {
                                members = catalog.checkMembers(availableServices);
                                ** for (service : members)
                            }
lbl-1000:
                            // 1 sources

                            {
                                if (service.equals((Object)service)) continue;
                                service.dispose((IProgressMonitor)new SubProgressMonitor(monitor, 10));
                                continue;
                            }
lbl22:
                            // 1 sources

                            monitor.done();
                            throw var6_10;
                        }
                        members = catalog.checkMembers(availableServices);
                        for (IService service : members) {
                            if (service.equals((Object)service)) continue;
                            service.dispose((IProgressMonitor)new SubProgressMonitor(monitor, 10));
                        }
                        monitor.done();
                    }
                }
            }
        };
        try {
            this.getContainer().run(false, true, runnable);
        }
        catch (InvocationTargetException e) {
            throw (RuntimeException)new RuntimeException().initCause(e);
        }
        catch (InterruptedException e) {
            throw (RuntimeException)new RuntimeException().initCause(e);
        }
        return services;
    }

    @Override
    public Collection<URL> getResourceIDs() {
        return this.resourceIds;
    }

    static /* synthetic */ Set access$1(FileConnectionPage fileConnectionPage) {
        return fileConnectionPage.list;
    }

    static /* synthetic */ Collection access$2(FileConnectionPage fileConnectionPage) {
        return fileConnectionPage.resourceIds;
    }
}

